/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.google.common.collect.Lists;
import com.lootbeams.Configuration;
import com.lootbeams.LootBeams;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextProcessing;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;

public class LootBeamRenderer
extends RenderState {
    private static final ResourceLocation LOOT_BEAM_TEXTURE = new ResourceLocation("lootbeams", "textures/entity/loot_beam.png");
    private static final RenderType LOOT_BEAM_RENDERTYPE = LootBeamRenderer.createRenderType();

    public LootBeamRenderer(String string, Runnable run, Runnable run2) {
        super(string, run, run2);
    }

    public static void renderLootBeam(MatrixStack stack, IRenderTypeBuffer buffer, float pticks, long worldtime, ItemEntity item) {
        float beamAlpha = ((Double)Configuration.BEAM_ALPHA.get()).floatValue();
        if (Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)item) < 2.0) {
            beamAlpha = (float)((double)beamAlpha * Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)item));
        }
        if (beamAlpha <= 0.15f) {
            return;
        }
        float beamRadius = 0.05f * ((Double)Configuration.BEAM_RADIUS.get()).floatValue();
        float glowRadius = beamRadius + beamRadius * 0.2f;
        float beamHeight = ((Double)Configuration.BEAM_HEIGHT.get()).floatValue();
        float yOffset = ((Double)Configuration.BEAM_Y_OFFSET.get()).floatValue();
        Color color = LootBeamRenderer.getItemColor(item);
        float R = (float)color.getRed() / 255.0f;
        float G = (float)color.getGreen() / 255.0f;
        float B = (float)color.getBlue() / 255.0f;
        stack.func_227860_a_();
        stack.func_227860_a_();
        float rotation = (float)Math.floorMod(worldtime, 40L) + pticks;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * 2.25f - 45.0f));
        stack.func_227861_a_(0.0, (double)yOffset, 0.0);
        stack.func_227861_a_(0.0, 1.0, 0.0);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius);
        stack.func_227865_b_();
        stack.func_227861_a_(0.0, (double)yOffset, 0.0);
        stack.func_227861_a_(0.0, 1.0, 0.0);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha * 0.4f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.getBuffer(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha * 0.4f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius);
        stack.func_227865_b_();
        if (((Boolean)Configuration.RENDER_NAMETAGS.get()).booleanValue()) {
            LootBeamRenderer.renderNameTag(stack, buffer, item, color);
        }
    }

    private static void renderNameTag(MatrixStack stack, IRenderTypeBuffer buffer, ItemEntity item, Color color) {
        if (Minecraft.func_71410_x().field_71439_g.func_213453_ef() || ((Boolean)Configuration.RENDER_NAMETAGS_ONLOOK.get()).booleanValue() && LootBeamRenderer.isLookingAt(Minecraft.func_71410_x().field_71439_g, (Entity)item, (Double)Configuration.NAMETAG_LOOK_SENSITIVITY.get())) {
            int count;
            float foregroundAlpha = ((Double)Configuration.NAMETAG_TEXT_ALPHA.get()).floatValue();
            float backgroundAlpha = ((Double)Configuration.NAMETAG_BACKGROUND_ALPHA.get()).floatValue();
            double yOffset = (Double)Configuration.NAMETAG_Y_OFFSET.get();
            int foregroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
            int backgroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, Math.min(1.0, Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)item) * 0.025) + yOffset, 0.0);
            stack.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            float nametagScale = ((Double)Configuration.NAMETAG_SCALE.get()).floatValue();
            stack.func_227862_a_(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            String itemName = StringUtils.func_76338_a((String)item.func_92059_d().func_200301_q().getString());
            if (((Boolean)Configuration.RENDER_STACKCOUNT.get()).booleanValue() && (count = item.func_92059_d().func_190916_E()) > 1) {
                itemName = itemName + " x" + count;
            }
            stack.func_227861_a_(0.0, 0.0, -10.0);
            LootBeamRenderer.RenderText(fontrenderer, stack, buffer, itemName, foregroundColor, backgroundColor, backgroundAlpha);
            stack.func_227861_a_(0.0, 10.0, 0.0);
            stack.func_227862_a_(0.75f, 0.75f, 0.75f);
            boolean textDrawn = false;
            List tooltip = item.func_92059_d().func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            if (tooltip.size() >= 2) {
                Color rarityColor;
                ITextComponent tooltipRarity = (ITextComponent)tooltip.get(1);
                if (((Boolean)Configuration.DMCLOOT_COMPAT_RARITY.get()).booleanValue() && ModList.get().isLoaded("dmcloot") && item.func_92059_d().func_77942_o() && item.func_92059_d().func_77978_p().func_74764_b("dmcloot.rarity")) {
                    rarityColor = (Boolean)Configuration.WHITE_RARITIES.get() != false ? Color.WHITE : LootBeamRenderer.getRawColor(tooltipRarity);
                    TranslationTextComponent translatedRarity = new TranslationTextComponent("rarity.dmcloot." + item.func_92059_d().func_77978_p().func_74779_i("dmcloot.rarity"));
                    LootBeamRenderer.RenderText(fontrenderer, stack, buffer, translatedRarity.getString(), rarityColor.getRGB(), backgroundColor, backgroundAlpha);
                    textDrawn = true;
                }
                if (!textDrawn && ((List)Configuration.CUSTOM_RARITIES.get()).contains(tooltipRarity.getString())) {
                    rarityColor = (Boolean)Configuration.WHITE_RARITIES.get() != false ? Color.WHITE : LootBeamRenderer.getRawColor(tooltipRarity);
                    foregroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
                    backgroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
                    LootBeamRenderer.RenderText(fontrenderer, stack, buffer, tooltipRarity.getString(), foregroundColor, backgroundColor, backgroundAlpha);
                }
            }
            stack.func_227865_b_();
        }
    }

    private static void RenderText(FontRenderer fontRenderer, MatrixStack stack, IRenderTypeBuffer buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (((Boolean)Configuration.BORDERS.get()).booleanValue()) {
            float w = (float)(-fontRenderer.func_78256_a(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            fontRenderer.func_238421_b_(stack, text, w + 1.0f, 0.0f, bg);
            fontRenderer.func_238421_b_(stack, text, w - 1.0f, 0.0f, bg);
            fontRenderer.func_238421_b_(stack, text, w, 1.0f, bg);
            fontRenderer.func_238421_b_(stack, text, w, -1.0f, bg);
            stack.func_227861_a_(0.0, 0.0, -0.01);
            fontRenderer.func_238421_b_(stack, text, w, 0.0f, foregroundColor);
            stack.func_227861_a_(0.0, 0.0, 0.01);
        } else {
            fontRenderer.func_228079_a_(text, (float)(-fontRenderer.func_78256_a(text) / 2), 0.0f, foregroundColor, false, stack.func_227866_c_().func_227870_a_(), buffer, false, backgroundColor, 0xF000E0);
        }
    }

    private static Color getItemColor(ItemEntity item) {
        if (LootBeams.CRASH_BLACKLIST.contains(item.func_92059_d())) {
            return Color.WHITE;
        }
        try {
            Color nameColor;
            Color override = Configuration.getColorFromItemOverrides(item.func_92059_d().func_77973_b());
            if (override != null) {
                return override;
            }
            if (item.func_92059_d().func_77942_o() && item.func_92059_d().func_77978_p().func_74764_b("lootbeams.color")) {
                return Color.decode(item.func_92059_d().func_77978_p().func_74779_i("lootbeams.color"));
            }
            if (((Boolean)Configuration.RENDER_NAME_COLOR.get()).booleanValue() && !(nameColor = LootBeamRenderer.getRawColor(item.func_92059_d().func_200301_q())).equals(Color.WHITE)) {
                return nameColor;
            }
            if (((Boolean)Configuration.RENDER_RARITY_COLOR.get()).booleanValue() && item.func_92059_d().func_77953_t().field_77937_e != null) {
                return new Color(item.func_92059_d().func_77953_t().field_77937_e.func_211163_e());
            }
            return Color.WHITE;
        }
        catch (Exception e) {
            LootBeams.LOGGER.error("Failed to get color for (" + item.func_92059_d().func_151000_E() + "), added to temporary blacklist");
            LootBeams.CRASH_BLACKLIST.add(item.func_92059_d());
            LootBeams.LOGGER.info("Temporary blacklist is now : ");
            for (ItemStack s : LootBeams.CRASH_BLACKLIST) {
                LootBeams.LOGGER.info((Object)s.func_151000_E());
            }
            return Color.WHITE;
        }
    }

    private static Color getRawColor(ITextComponent text) {
        ArrayList list = Lists.newArrayList();
        text.func_230439_a_((acceptor, styleIn) -> {
            TextProcessing.func_238346_c_((String)styleIn, (Style)acceptor, (string, style, consumer) -> {
                list.add(style);
                return true;
            });
            return Optional.empty();
        }, Style.field_240709_b_);
        if (((Style)list.get(0)).func_240711_a_() != null) {
            return new Color(((Style)list.get(0)).func_240711_a_().func_240742_a_());
        }
        return Color.WHITE;
    }

    private static void renderPart(MatrixStack stack, IVertexBuilder builder, float red, float green, float blue, float alpha, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        MatrixStack.Entry matrixentry = stack.func_227866_c_();
        Matrix4f matrixpose = matrixentry.func_227870_a_();
        Matrix3f matrixnormal = matrixentry.func_227872_b_();
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, IVertexBuilder builder, float red, float green, float blue, float alpha, float y, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z, texu, 0.0f, 0.0f);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, IVertexBuilder builder, float red, float green, float blue, float alpha, float y, float x, float z, float texu, float texv) {
        builder.func_227888_a_(pose, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texu, texv).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static RenderType createRenderType() {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(LOOT_BEAM_TEXTURE, false, false)).func_228726_a_(field_228515_g_).func_228727_a_(RenderState.field_228496_F_).func_228717_a_(field_228501_K_).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"loot_beam", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)state);
    }

    private static boolean isLookingAt(ClientPlayerEntity player, Entity target, double accuracy) {
        Vector3d difference = new Vector3d(target.func_226277_ct_() - player.func_226277_ct_(), target.func_226280_cw_() - player.func_226280_cw_(), target.func_226281_cx_() - player.func_226281_cx_());
        double length = difference.func_72433_c();
        double dot = player.func_70676_i(1.0f).func_72432_b().func_72430_b(difference.func_72432_b());
        return dot > 1.0 - accuracy / length && player.func_70685_l(target);
    }
}

