/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.google.common.collect.Lists;
import com.lootbeams.Configuration;
import com.lootbeams.LootBeams;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public class LootBeamRenderer
extends RenderType {
    private static final ResourceLocation LOOT_BEAM_TEXTURE = new ResourceLocation("lootbeams", "textures/entity/loot_beam.png");
    private static final RenderType LOOT_BEAM_RENDERTYPE = LootBeamRenderer.createRenderType();

    public LootBeamRenderer(String name, VertexFormat format, VertexFormat.Mode mode, int size, boolean crumble, boolean sorting, Runnable enable, Runnable disable) {
        super(name, format, mode, size, crumble, sorting, enable, disable);
    }

    public static void renderLootBeam(PoseStack stack, MultiBufferSource buffer, float pticks, long worldtime, ItemEntity item) {
        float beamRadius = 0.05f * ((Double)Configuration.BEAM_RADIUS.get()).floatValue();
        float glowRadius = beamRadius + beamRadius * 0.2f;
        float beamAlpha = ((Double)Configuration.BEAM_ALPHA.get()).floatValue();
        float beamHeight = ((Double)Configuration.BEAM_HEIGHT.get()).floatValue();
        float yOffset = ((Double)Configuration.BEAM_Y_OFFSET.get()).floatValue();
        Color color = LootBeamRenderer.getItemColor(item);
        float R = (float)color.getRed() / 255.0f;
        float G = (float)color.getGreen() / 255.0f;
        float B = (float)color.getBlue() / 255.0f;
        stack.m_85836_();
        stack.m_85836_();
        float rotation = (float)Math.floorMod(worldtime, 40L) + pticks;
        stack.m_85845_(Vector3f.f_122225_.m_122240_(rotation * 2.25f - 45.0f));
        stack.m_85837_(0.0, (double)yOffset, 0.0);
        stack.m_85837_(0.0, 1.0, 0.0);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius);
        stack.m_85849_();
        stack.m_85837_(0.0, (double)yOffset, 0.0);
        stack.m_85837_(0.0, 1.0, 0.0);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha * 0.4f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha * 0.4f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius);
        stack.m_85849_();
        if (((Boolean)Configuration.RENDER_NAMETAGS.get()).booleanValue()) {
            LootBeamRenderer.renderNameTag(stack, buffer, item, color);
        }
    }

    private static void renderNameTag(PoseStack stack, MultiBufferSource buffer, ItemEntity item, Color color) {
        if (Minecraft.m_91087_().f_91074_.m_6047_() || ((Boolean)Configuration.RENDER_NAMETAGS_ONLOOK.get()).booleanValue() && LootBeamRenderer.isLookingAt(Minecraft.m_91087_().f_91074_, (Entity)item, (Double)Configuration.NAMETAG_LOOK_SENSITIVITY.get())) {
            int count;
            float foregroundAlpha = ((Double)Configuration.NAMETAG_TEXT_ALPHA.get()).floatValue();
            float backgroundAlpha = ((Double)Configuration.NAMETAG_BACKGROUND_ALPHA.get()).floatValue();
            double yOffset = (Double)Configuration.NAMETAG_Y_OFFSET.get();
            int foregroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
            int backgroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
            stack.m_85836_();
            stack.m_85837_(0.0, Math.min(1.0, Minecraft.m_91087_().f_91074_.m_20280_((Entity)item) * 0.025) + yOffset, 0.0);
            stack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
            float nametagScale = ((Double)Configuration.NAMETAG_SCALE.get()).floatValue();
            stack.m_85841_(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            Object itemName = StringUtil.m_14406_((String)item.m_32055_().m_41786_().getString());
            if (((Boolean)Configuration.RENDER_STACKCOUNT.get()).booleanValue() && (count = item.m_32055_().m_41613_()) > 1) {
                itemName = (String)itemName + " x" + count;
            }
            stack.m_85837_(0.0, 0.0, -10.0);
            LootBeamRenderer.RenderText(fontrenderer, stack, buffer, (String)itemName, foregroundColor, backgroundColor, backgroundAlpha);
            stack.m_85837_(0.0, 10.0, 0.0);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            boolean textDrawn = false;
            List tooltip = item.m_32055_().m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL);
            if (tooltip.size() >= 2) {
                Color rarityColor;
                Component tooltipRarity = (Component)tooltip.get(1);
                if (((Boolean)Configuration.DMCLOOT_COMPAT_RARITY.get()).booleanValue() && ModList.get().isLoaded("dmcloot") && item.m_32055_().m_41782_() && item.m_32055_().m_41783_().m_128441_("dmcloot.rarity")) {
                    rarityColor = (Boolean)Configuration.WHITE_RARITIES.get() != false ? Color.WHITE : LootBeamRenderer.getRawColor(tooltipRarity);
                    TranslatableComponent translatedRarity = new TranslatableComponent("rarity.dmcloot." + item.m_32055_().m_41783_().m_128461_("dmcloot.rarity"));
                    LootBeamRenderer.RenderText(fontrenderer, stack, buffer, translatedRarity.getString(), rarityColor.getRGB(), backgroundColor, backgroundAlpha);
                    textDrawn = true;
                }
                if (!textDrawn && ((List)Configuration.CUSTOM_RARITIES.get()).contains(tooltipRarity.getString())) {
                    rarityColor = (Boolean)Configuration.WHITE_RARITIES.get() != false ? Color.WHITE : LootBeamRenderer.getRawColor(tooltipRarity);
                    foregroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
                    backgroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
                    LootBeamRenderer.RenderText(fontrenderer, stack, buffer, tooltipRarity.getString(), foregroundColor, backgroundColor, backgroundAlpha);
                }
            }
            stack.m_85849_();
        }
    }

    private static void RenderText(Font fontRenderer, PoseStack stack, MultiBufferSource buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (((Boolean)Configuration.BORDERS.get()).booleanValue()) {
            float w = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            fontRenderer.m_92883_(stack, text, w + 1.0f, 0.0f, bg);
            fontRenderer.m_92883_(stack, text, w - 1.0f, 0.0f, bg);
            fontRenderer.m_92883_(stack, text, w, 1.0f, bg);
            fontRenderer.m_92883_(stack, text, w, -1.0f, bg);
            stack.m_85837_(0.0, 0.0, -0.01);
            fontRenderer.m_92883_(stack, text, w, 0.0f, foregroundColor);
            stack.m_85837_(0.0, 0.0, 0.01);
        } else {
            fontRenderer.m_92811_(text, (float)(-fontRenderer.m_92895_(text) / 2), 0.0f, foregroundColor, false, stack.m_85850_().m_85861_(), buffer, false, backgroundColor, 0xF000E0);
        }
    }

    private static Color getItemColor(ItemEntity item) {
        if (LootBeams.CRASH_BLACKLIST.contains(item.m_32055_())) {
            return Color.WHITE;
        }
        try {
            Color nameColor;
            Color override = Configuration.getColorFromItemOverrides(item.m_32055_().m_41720_());
            if (override != null) {
                return override;
            }
            if (item.m_32055_().m_41782_() && item.m_32055_().m_41783_().m_128441_("lootbeams.color")) {
                return Color.decode(item.m_32055_().m_41783_().m_128461_("lootbeams.color"));
            }
            if (((Boolean)Configuration.RENDER_NAME_COLOR.get()).booleanValue() && !(nameColor = LootBeamRenderer.getRawColor(item.m_32055_().m_41786_())).equals(Color.WHITE)) {
                return nameColor;
            }
            if (((Boolean)Configuration.RENDER_RARITY_COLOR.get()).booleanValue() && item.m_32055_().m_41791_().f_43022_ != null) {
                return new Color(item.m_32055_().m_41791_().f_43022_.m_126665_());
            }
            return Color.WHITE;
        }
        catch (Exception e) {
            LootBeams.LOGGER.error("Failed to get color for (" + item.m_32055_().m_41611_() + "), added to temporary blacklist");
            LootBeams.CRASH_BLACKLIST.add(item.m_32055_());
            LootBeams.LOGGER.info("Temporary blacklist is now : ");
            for (ItemStack s : LootBeams.CRASH_BLACKLIST) {
                LootBeams.LOGGER.info((Object)s.m_41611_());
            }
            return Color.WHITE;
        }
    }

    private static Color getRawColor(Component text) {
        ArrayList list = Lists.newArrayList();
        text.m_7451_((acceptor, styleIn) -> {
            StringDecomposer.m_14346_((String)styleIn, (Style)acceptor, (string, style, consumer) -> {
                list.add(style);
                return true;
            });
            return Optional.empty();
        }, Style.f_131099_);
        if (((Style)list.get(0)).m_131135_() != null) {
            return new Color(((Style)list.get(0)).m_131135_().m_131265_());
        }
        return Color.WHITE;
    }

    private static void renderPart(PoseStack stack, VertexConsumer builder, float red, float green, float blue, float alpha, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        PoseStack.Pose matrixentry = stack.m_85850_();
        Matrix4f matrixpose = matrixentry.m_85861_();
        Matrix3f matrixnormal = matrixentry.m_85864_();
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, VertexConsumer builder, float red, float green, float blue, float alpha, float y, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z, texu, 0.0f, 0.0f);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, VertexConsumer builder, float red, float green, float blue, float alpha, float y, float x, float z, float texu, float texv) {
        builder.m_85982_(pose, x, y, z).m_85950_(red, green, blue, alpha).m_7421_(texu, texv).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173068_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LOOT_BEAM_TEXTURE, false, false)).m_110685_(f_110139_).m_110687_(f_110115_).m_110691_(false);
        return RenderType.m_173215_((String)"loot_beam", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    private static boolean isLookingAt(LocalPlayer player, Entity target, double accuracy) {
        Vec3 difference = new Vec3(target.m_20185_() - player.m_20185_(), target.m_20188_() - player.m_20188_(), target.m_20189_() - player.m_20189_());
        double length = difference.m_82553_();
        double dot = player.m_20252_(1.0f).m_82541_().m_82526_(difference.m_82541_());
        return dot > 1.0 - accuracy / length && !target.m_20145_();
    }
}

