/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.setrion.mushroomified.events.Events;
import net.setrion.mushroomified.registry.MBlockEntityType;
import net.setrion.mushroomified.registry.MBlocks;
import net.setrion.mushroomified.registry.MEntityType;
import net.setrion.mushroomified.registry.MItems;
import net.setrion.mushroomified.registry.ModelLayers;
import net.setrion.mushroomified.world.entity.Cluckshroom;
import net.setrion.mushroomified.world.entity.Creepshroom;
import net.setrion.mushroomified.world.entity.Pigshroom;
import net.setrion.mushroomified.world.entity.Slimeshroom;
import net.setrion.mushroomified.world.entity.Turtshroom;
import net.setrion.mushroomified.world.entity.Zombshroom;
import org.slf4j.Logger;

@Mod(value="mushroomified")
public class Mushroomified {
    public static final String MOD_ID = "mushroomified";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Mushroomified() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MBlockEntityType.BLOCK_ENTITY_TYPES.register(modEventBus);
        MEntityType.ENTITY_TYPES.register(modEventBus);
        MBlocks.BLOCKS.register(modEventBus);
        MItems.ITEMS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupEntityModelLayers);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        WoodType.m_61844_((WoodType)MBlocks.OAKSHROOM);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
            AxeItem.f_150683_.put((Block)MBlocks.OAKSHROOM_LOG.get(), (Block)MBlocks.STRIPPED_OAKSHROOM_LOG.get());
            AxeItem.f_150683_.put((Block)MBlocks.OAKSHROOM_WOOD.get(), (Block)MBlocks.STRIPPED_OAKSHROOM_WOOD.get());
        });
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)MEntityType.CLUCKSHROOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Cluckshroom::checkCluckshroomSpawnRules));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)MEntityType.CREEPSHROOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Creepshroom::checkCreepshroomSpawnRules));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)MEntityType.PIGSHROOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Pigshroom::checkPigshroomSpawnRules));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)MEntityType.SLIMESHROOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Slimeshroom::checkSlimeshroomSpawnRules));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)MEntityType.TURTSHROOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Turtshroom::checkTurtshroomSpawnRules));
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)MEntityType.ZOMBSHROOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Zombshroom::checkZombshroomSpawnRules));
    }

    private void setupEntityModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModelLayers.register(event);
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

