/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified.world.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.setrion.mushroomified.registry.MBlocks;
import net.setrion.mushroomified.registry.MEntityType;
import net.setrion.mushroomified.world.level.block.TurtshroomEggBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Turtshroom
extends Turtle
implements IForgeShearable {
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(Turtle.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Turtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.m_135353_(Turtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> TRAVEL_POS = SynchedEntityData.m_135353_(Turtle.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(Turtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRAVELLING = SynchedEntityData.m_135353_(Turtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int f_30129_;

    public Turtshroom(EntityType<? extends Turtshroom> type, Level level) {
        super(type, level);
    }

    public static boolean checkTurtshroomSpawnRules(EntityType<Turtshroom> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184231_) && Turtshroom.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        return (AgeableMob)((EntityType)MEntityType.TURTSHROOM.get()).m_20615_((Level)level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(TRAVEL_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOING_HOME, (Object)false);
        this.f_19804_.m_135372_(TRAVELLING, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TurtshroomPanicGoal(this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new TurtshroomBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TurtshroomLayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, f_149066_, false));
        this.f_21345_.m_25352_(3, (Goal)new TurtshroomGoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TurtshroomGoHomeGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new TurtshroomTravelGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new TurtshroomRandomStrollGoal(this, 1.0, 100));
    }

    public void m_30219_(BlockPos p_30220_) {
        this.f_19804_.m_135381_(HOME_POS, (Object)p_30220_);
    }

    BlockPos m_30208_() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    void m_30223_(BlockPos p_30224_) {
        this.f_19804_.m_135381_(TRAVEL_POS, (Object)p_30224_);
    }

    BlockPos m_30209_() {
        return (BlockPos)this.f_19804_.m_135370_(TRAVEL_POS);
    }

    public boolean m_30205_() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void m_30234_(boolean p_30235_) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)p_30235_);
    }

    public boolean m_30206_() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    void m_30236_(boolean p_30237_) {
        this.f_30129_ = p_30237_ ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)p_30237_);
    }

    boolean m_30211_() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    void m_30238_(boolean p_30239_) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)p_30239_);
    }

    boolean m_30212_() {
        return (Boolean)this.f_19804_.m_135370_(TRAVELLING);
    }

    void m_30240_(boolean p_30241_) {
        this.f_19804_.m_135381_(TRAVELLING, (Object)p_30241_);
    }

    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        return this.shearInternal(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
    }

    public void shear(SoundSource p_28924_) {
        this.shearInternal(p_28924_).forEach(s -> this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), s)));
    }

    private List<ItemStack> shearInternal(SoundSource p_28924_) {
        this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_12075_, p_28924_, 1.0f, 1.0f);
        if (!this.f_19853_.m_5776_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
            Turtle turtle = (Turtle)EntityType.f_20490_.m_20615_(this.f_19853_);
            turtle.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            turtle.m_21153_(this.m_21223_());
            turtle.f_20883_ = this.f_20883_;
            if (this.m_8077_()) {
                turtle.m_6593_(this.m_7770_());
                turtle.m_20340_(this.m_20151_());
            }
            if (this.m_21532_()) {
                turtle.m_21530_();
            }
            turtle.m_20331_(this.m_20147_());
            this.f_19853_.m_7967_((Entity)turtle);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < 5; ++i) {
                items.add(new ItemStack((ItemLike)Items.f_41953_));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean readyForShearing() {
        return this.m_6084_() && !this.m_6162_();
    }

    public boolean isShearable(@NotNull ItemStack item, Level world, BlockPos pos) {
        return this.readyForShearing();
    }

    static class TurtshroomPanicGoal
    extends PanicGoal {
        TurtshroomPanicGoal(Turtshroom p_30290_, double p_30291_) {
            super((PathfinderMob)p_30290_, p_30291_);
        }

        public boolean m_8036_() {
            if (!this.m_202729_()) {
                return false;
            }
            BlockPos blockpos = this.m_198172_((BlockGetter)this.f_25684_.f_19853_, (Entity)this.f_25684_, 7);
            if (blockpos != null) {
                this.f_25686_ = blockpos.m_123341_();
                this.f_25687_ = blockpos.m_123342_();
                this.f_25688_ = blockpos.m_123343_();
                return true;
            }
            return this.m_25702_();
        }
    }

    static class TurtshroomBreedGoal
    extends BreedGoal {
        private final Turtshroom turtshroom;

        TurtshroomBreedGoal(Turtshroom turtshroom, double p_30245_) {
            super((Animal)turtshroom, p_30245_);
            this.turtshroom = turtshroom;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.turtshroom.m_30205_();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.turtshroom.m_30234_(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource randomsource = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), randomsource.m_188503_(7) + 1));
            }
        }
    }

    static class TurtshroomLayEggGoal
    extends MoveToBlockGoal {
        private final Turtshroom turtshroom;

        TurtshroomLayEggGoal(Turtshroom p_30276_, double p_30277_) {
            super((PathfinderMob)p_30276_, p_30277_, 16);
            this.turtshroom = p_30276_;
        }

        public boolean m_8036_() {
            return this.turtshroom.m_30205_() && this.turtshroom.m_30208_().m_203195_((Position)this.turtshroom.m_20182_(), 9.0) ? super.m_8036_() : false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.turtshroom.m_30205_() && this.turtshroom.m_30208_().m_203195_((Position)this.turtshroom.m_20182_(), 9.0);
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = this.turtshroom.m_20183_();
            if (!this.turtshroom.m_20069_() && this.m_25625_()) {
                if (this.turtshroom.f_30129_ < 1) {
                    this.turtshroom.m_30236_(true);
                } else if (this.turtshroom.f_30129_ > this.m_183277_(200)) {
                    Level level = this.turtshroom.f_19853_;
                    level.m_5594_((Player)null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                    level.m_7731_(this.f_25602_.m_7494_(), (BlockState)((TurtshroomEggBlock)((Object)MBlocks.TURTSHROOM_EGG.get())).m_49966_().m_61124_((Property)TurtshroomEggBlock.f_57754_, (Comparable)Integer.valueOf(this.turtshroom.f_19796_.m_188503_(4) + 1)), 3);
                    this.turtshroom.m_30234_(false);
                    this.turtshroom.m_30236_(false);
                    this.turtshroom.m_27601_(600);
                }
                if (this.turtshroom.m_30206_()) {
                    ++this.turtshroom.f_30129_;
                }
            }
        }

        protected boolean m_6465_(LevelReader p_30280_, BlockPos p_30281_) {
            return !p_30280_.m_46859_(p_30281_.m_7494_()) ? false : TurtshroomEggBlock.m_57800_((BlockGetter)p_30280_, (BlockPos)p_30281_);
        }
    }

    static class TurtshroomGoToWaterGoal
    extends MoveToBlockGoal {
        private final Turtshroom turtshroom;

        TurtshroomGoToWaterGoal(Turtshroom p_30262_, double p_30263_) {
            super((PathfinderMob)p_30262_, p_30262_.m_6162_() ? 2.0 : p_30263_, 24);
            this.turtshroom = p_30262_;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.turtshroom.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtshroom.f_19853_, this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.turtshroom.m_6162_() && !this.turtshroom.m_20069_()) {
                return super.m_8036_();
            }
            return !this.turtshroom.m_30211_() && !this.turtshroom.m_20069_() && !this.turtshroom.m_30205_() ? super.m_8036_() : false;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader p_30270_, BlockPos p_30271_) {
            return p_30270_.m_8055_(p_30271_).m_60713_(Blocks.f_49990_);
        }
    }

    static class TurtshroomGoHomeGoal
    extends Goal {
        private final Turtshroom turtshroom;
        private final double speedModifier;
        private boolean stuck;
        private int closeToHomeTryTicks;

        TurtshroomGoHomeGoal(Turtshroom p_30253_, double p_30254_) {
            this.turtshroom = p_30253_;
            this.speedModifier = p_30254_;
        }

        public boolean m_8036_() {
            if (this.turtshroom.m_6162_()) {
                return false;
            }
            if (this.turtshroom.m_30205_()) {
                return true;
            }
            if (this.turtshroom.m_217043_().m_188503_(TurtshroomGoHomeGoal.m_186073_((int)700)) != 0) {
                return false;
            }
            return !this.turtshroom.m_30208_().m_203195_((Position)this.turtshroom.m_20182_(), 64.0);
        }

        public void m_8056_() {
            this.turtshroom.m_30238_(true);
            this.stuck = false;
            this.closeToHomeTryTicks = 0;
        }

        public void m_8041_() {
            this.turtshroom.m_30238_(false);
        }

        public boolean m_8045_() {
            return !this.turtshroom.m_30208_().m_203195_((Position)this.turtshroom.m_20182_(), 7.0) && !this.stuck && this.closeToHomeTryTicks <= this.m_183277_(600);
        }

        public void m_8037_() {
            BlockPos blockpos = this.turtshroom.m_30208_();
            boolean flag = blockpos.m_203195_((Position)this.turtshroom.m_20182_(), 16.0);
            if (flag) {
                ++this.closeToHomeTryTicks;
            }
            if (this.turtshroom.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockpos);
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtshroom, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtshroom, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null && !flag && !this.turtshroom.f_19853_.m_8055_(new BlockPos(vec31)).m_60713_(Blocks.f_49990_)) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtshroom, (int)16, (int)5, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtshroom.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }
    }

    static class TurtshroomTravelGoal
    extends Goal {
        private final Turtshroom turtshroom;
        private final double speedModifier;
        private boolean stuck;

        TurtshroomTravelGoal(Turtshroom p_30333_, double p_30334_) {
            this.turtshroom = p_30333_;
            this.speedModifier = p_30334_;
        }

        public boolean m_8036_() {
            return !this.turtshroom.m_30211_() && !this.turtshroom.m_30205_() && this.turtshroom.m_20069_();
        }

        public void m_8056_() {
            RandomSource randomsource = this.turtshroom.f_19796_;
            int k = randomsource.m_188503_(1025) - 512;
            int l = randomsource.m_188503_(9) - 4;
            int i1 = randomsource.m_188503_(1025) - 512;
            if ((double)l + this.turtshroom.m_20186_() > (double)(this.turtshroom.f_19853_.m_5736_() - 1)) {
                l = 0;
            }
            BlockPos blockpos = new BlockPos((double)k + this.turtshroom.m_20185_(), (double)l + this.turtshroom.m_20186_(), (double)i1 + this.turtshroom.m_20189_());
            this.turtshroom.m_30223_(blockpos);
            this.turtshroom.m_30240_(true);
            this.stuck = false;
        }

        public void m_8037_() {
            if (this.turtshroom.m_21573_().m_26571_()) {
                int j;
                int i;
                Vec3 vec3 = Vec3.m_82539_((Vec3i)this.turtshroom.m_30209_());
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtshroom, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtshroom, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null && !this.turtshroom.f_19853_.m_151572_((i = Mth.m_14107_((double)vec31.f_82479_)) - 34, (j = Mth.m_14107_((double)vec31.f_82481_)) - 34, i + 34, j + 34)) {
                    vec31 = null;
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtshroom.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }

        public boolean m_8045_() {
            return !this.turtshroom.m_21573_().m_26571_() && !this.stuck && !this.turtshroom.m_30211_() && !this.turtshroom.m_27593_() && !this.turtshroom.m_30205_();
        }

        public void m_8041_() {
            this.turtshroom.m_30240_(false);
            super.m_8041_();
        }
    }

    static class TurtshroomRandomStrollGoal
    extends RandomStrollGoal {
        private final Turtshroom turtshroom;

        TurtshroomRandomStrollGoal(Turtshroom p_30303_, double p_30304_, int p_30305_) {
            super((PathfinderMob)p_30303_, p_30304_, p_30305_);
            this.turtshroom = p_30303_;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && !this.turtshroom.m_30211_() && !this.turtshroom.m_30205_() ? super.m_8036_() : false;
        }
    }

    static class TurtshroomPathNavigation
    extends AmphibiousPathNavigation {
        TurtshroomPathNavigation(Turtshroom p_30294_, Level p_30295_) {
            super((Mob)p_30294_, p_30295_);
        }

        public boolean m_6342_(BlockPos p_30300_) {
            Turtshroom turtshroom;
            Mob mob = this.f_26494_;
            if (mob instanceof Turtshroom && (turtshroom = (Turtshroom)mob).m_30212_()) {
                return this.f_26495_.m_8055_(p_30300_).m_60713_(Blocks.f_49990_);
            }
            return !this.f_26495_.m_8055_(p_30300_.m_7495_()).m_60795_();
        }
    }

    static class TurtshroomMoveControl
    extends MoveControl {
        private final Turtshroom turtshroom;

        TurtshroomMoveControl(Turtshroom p_30286_) {
            super((Mob)p_30286_);
            this.turtshroom = p_30286_;
        }

        private void updateSpeed() {
            if (this.turtshroom.m_20069_()) {
                this.turtshroom.m_20256_(this.turtshroom.m_20184_().m_82520_(0.0, 0.005, 0.0));
                if (!this.turtshroom.m_30208_().m_203195_((Position)this.turtshroom.m_20182_(), 16.0)) {
                    this.turtshroom.m_7910_(Math.max(this.turtshroom.m_6113_() / 2.0f, 0.08f));
                }
                if (this.turtshroom.m_6162_()) {
                    this.turtshroom.m_7910_(Math.max(this.turtshroom.m_6113_() / 3.0f, 0.06f));
                }
            } else if (this.turtshroom.f_19861_) {
                this.turtshroom.m_7910_(Math.max(this.turtshroom.m_6113_() / 2.0f, 0.06f));
            }
        }

        public void m_8126_() {
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.turtshroom.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.turtshroom.m_20185_();
                double d1 = this.f_24976_ - this.turtshroom.m_20186_();
                double d2 = this.f_24977_ - this.turtshroom.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.turtshroom.m_146922_(this.m_24991_(this.turtshroom.m_146908_(), f, 90.0f));
                this.turtshroom.f_20883_ = this.turtshroom.m_146908_();
                float f1 = (float)(this.f_24978_ * this.turtshroom.m_21133_(Attributes.f_22279_));
                this.turtshroom.m_7910_(Mth.m_14179_((float)0.125f, (float)this.turtshroom.m_6113_(), (float)f1));
                this.turtshroom.m_20256_(this.turtshroom.m_20184_().m_82520_(0.0, (double)this.turtshroom.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.turtshroom.m_7910_(0.0f);
            }
        }
    }
}

