/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.setrion.mushroomified.world.entity.vehicle.Boat;

public class BoatModel
extends ListModel<Boat> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public BoatModel(ModelPart root, boolean hasChest) {
        this.leftPaddle = root.m_171324_("left_paddle");
        this.rightPaddle = root.m_171324_("right_paddle");
        this.waterPatch = root.m_171324_("water_patch");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{root.m_171324_("bottom"), root.m_171324_("back"), root.m_171324_("front"), root.m_171324_("right"), root.m_171324_("left"), this.leftPaddle, this.rightPaddle});
        if (hasChest) {
            builder.add((Object)root.m_171324_("chest_bottom"));
            builder.add((Object)root.m_171324_("chest_lid"));
            builder.add((Object)root.m_171324_("chest_lock"));
        }
        this.parts = builder.build();
    }

    public static LayerDefinition createBodyModel(boolean hasChest) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        partdefinition.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), PartPose.m_171423_((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        partdefinition.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        partdefinition.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)9.0f));
        if (hasChest) {
            partdefinition.m_171599_("chest_bottom", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 8.0f, 12.0f), PartPose.m_171423_((float)-2.0f, (float)-5.0f, (float)-6.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            partdefinition.m_171599_("chest_lid", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 4.0f, 12.0f), PartPose.m_171423_((float)-2.0f, (float)-9.0f, (float)-6.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            partdefinition.m_171599_("chest_lock", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        }
        partdefinition.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partdefinition.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(62, 20).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        partdefinition.m_171599_("water_patch", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)(hasChest ? 128 : 64));
    }

    public void setupAnim(Boat boat, float p_102270_, float p_102271_, float p_102272_, float p_102273_, float p_102274_) {
        BoatModel.animatePaddle(boat, 0, this.leftPaddle, p_102270_);
        BoatModel.animatePaddle(boat, 1, this.rightPaddle, p_102270_);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    public ModelPart waterPatch() {
        return this.waterPatch;
    }

    private static void animatePaddle(Boat boat, int paddle, ModelPart part, float angle) {
        float f = boat.getRowingTime(paddle, angle);
        part.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        part.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (paddle == 1) {
            part.f_104204_ = (float)Math.PI - part.f_104204_;
        }
    }
}

