/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.setrion.mushroomified.client.model.BoatModel;
import net.setrion.mushroomified.registry.ModelLayers;
import net.setrion.mushroomified.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class BoatRenderer
extends EntityRenderer<Boat> {
    private final Map<Boat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public BoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("mushroomified", BoatRenderer.getTextureLocation(type, hasChest)), (Object)((Object)this.createBoatModel(context, (Boat.Type)((Object)type), hasChest)))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, Boat.Type type, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? ModelLayers.createChestBoatModelName(type) : ModelLayers.createBoatModelName(type);
        return new BoatModel(context.m_174023_(modellayerlocation), hasChest);
    }

    private static String getTextureLocation(Boat.Type type, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(Boat boat, float p_113930_, float p_113931_, PoseStack stack, MultiBufferSource buffer, int p_113934_) {
        float f2;
        stack.m_85836_();
        stack.m_85837_(0.0, 0.375, 0.0);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_113930_));
        float f = (float)boat.getHurtTime() - p_113931_;
        float f1 = boat.getDamage() - p_113931_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.getHurtDir()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.getBubbleAngle(p_113931_)), (float)0.0f)) {
            stack.m_252781_(new Quaternionf().setAngleAxis(boat.getBubbleAngle(p_113931_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)((Object)pair.getSecond());
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        boatmodel.setupAnim(boat, p_113931_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(boatmodel.m_103119_(resourcelocation));
        boatmodel.m_7695_(stack, vertexconsumer, p_113934_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_110478_());
            boatmodel.waterPatch().m_104301_(stack, vertexconsumer1, p_113934_, OverlayTexture.f_118083_);
        }
        stack.m_85849_();
        super.m_7392_((Entity)boat, p_113930_, p_113931_, stack, buffer, p_113934_);
    }

    @Deprecated
    public ResourceLocation getTextureLocation(Boat p_113927_) {
        return (ResourceLocation)this.getModelWithLocation(p_113927_).getFirst();
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        return this.boatResources.get((Object)boat.getBoatType());
    }
}

