/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified.world.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import net.setrion.mushroomified.registry.MEntityType;
import net.setrion.mushroomified.world.entity.Cluckshroom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Zombshroom
extends Zombie
implements IForgeShearable {
    public Zombshroom(EntityType<? extends Zombshroom> type, Level level) {
        super(type, level);
    }

    public static boolean checkZombshroomSpawnRules(EntityType<Zombshroom> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Zombshroom.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184231_));
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean m_7327_(Entity p_32892_) {
        boolean flag = super.m_7327_(p_32892_);
        if (flag && this.m_21205_().m_41619_() && p_32892_ instanceof LivingEntity) {
            float f = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            ((LivingEntity)p_32892_).m_147207_(new MobEffectInstance(MobEffects.f_19614_, 140 * (int)f), (Entity)this);
        }
        return flag;
    }

    protected boolean m_7593_() {
        return true;
    }

    protected void m_7595_() {
        this.m_34310_(EntityType.f_20501_);
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_((Player)null, 1041, this.m_20183_(), 0);
        }
    }

    protected ItemStack m_5728_() {
        return ItemStack.f_41583_;
    }

    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        return this.shearInternal(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
    }

    public void shear(SoundSource p_28924_) {
        this.shearInternal(p_28924_).forEach(s -> this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), s)));
    }

    private List<ItemStack> shearInternal(SoundSource p_28924_) {
        this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12075_, p_28924_, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
            Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(this.m_9236_());
            zombie.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            zombie.m_21153_(this.m_21223_());
            zombie.f_20883_ = this.f_20883_;
            if (this.m_8077_()) {
                zombie.m_6593_(this.m_7770_());
                zombie.m_20340_(this.m_20151_());
            }
            if (this.m_21532_()) {
                zombie.m_21530_();
            }
            this.copyEquipment(this, zombie);
            zombie.m_20331_(this.m_20147_());
            this.m_9236_().m_7967_((Entity)zombie);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < 5; ++i) {
                items.add(new ItemStack((ItemLike)Items.f_41953_));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean readyForShearing() {
        return this.m_6084_() && !this.m_6162_();
    }

    public boolean isShearable(@NotNull ItemStack item, Level world, BlockPos pos) {
        return this.readyForShearing();
    }

    private void copyEquipment(Zombie zombie, Zombie zombie1) {
        zombie1.m_8061_(EquipmentSlot.HEAD, zombie.m_6844_(EquipmentSlot.HEAD));
        zombie1.m_8061_(EquipmentSlot.CHEST, zombie.m_6844_(EquipmentSlot.CHEST));
        zombie1.m_8061_(EquipmentSlot.LEGS, zombie.m_6844_(EquipmentSlot.LEGS));
        zombie1.m_8061_(EquipmentSlot.FEET, zombie.m_6844_(EquipmentSlot.FEET));
        zombie1.m_8061_(EquipmentSlot.MAINHAND, zombie.m_6844_(EquipmentSlot.MAINHAND));
        zombie1.m_8061_(EquipmentSlot.OFFHAND, zombie.m_6844_(EquipmentSlot.OFFHAND));
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData groupData, @javax.annotation.Nullable CompoundTag tag) {
        RandomSource randomsource = level.m_213780_();
        groupData = super.m_6518_(level, difficulty, spawnType, groupData, tag);
        float f = difficulty.m_19057_();
        this.m_21553_(randomsource.m_188501_() < 0.55f * f);
        if (groupData == null) {
            groupData = new Zombie.ZombieGroupData(Zombshroom.m_219162_((RandomSource)randomsource), true);
        }
        if (groupData instanceof Zombie.ZombieGroupData) {
            Zombie.ZombieGroupData zombie$zombiegroupdata = (Zombie.ZombieGroupData)groupData;
            if (zombie$zombiegroupdata.f_34354_) {
                this.m_6863_(true);
                if (zombie$zombiegroupdata.f_34355_) {
                    if ((double)randomsource.m_188501_() < 0.05) {
                        List list1;
                        List list = level.m_6443_(Chicken.class, this.m_20191_().m_82377_(5.0, 3.0, 5.0), EntitySelector.f_20404_);
                        if (!list.isEmpty()) {
                            Chicken chicken = (Chicken)list.get(0);
                            chicken.m_28273_(true);
                            this.m_20329_((Entity)chicken);
                        }
                        if (!(list1 = level.m_6443_(Cluckshroom.class, this.m_20191_().m_82377_(5.0, 3.0, 5.0), EntitySelector.f_20404_)).isEmpty()) {
                            Cluckshroom chicken = (Cluckshroom)((Object)list1.get(0));
                            chicken.m_28273_(true);
                            this.m_20329_((Entity)chicken);
                        }
                    } else if ((double)randomsource.m_188501_() < 0.05) {
                        Chicken chicken1 = (double)randomsource.m_188501_() < 0.5 ? (Chicken)EntityType.f_20555_.m_20615_(this.m_9236_()) : (Chicken)((EntityType)MEntityType.CLUCKSHROOM.get()).m_20615_(this.m_9236_());
                        chicken1.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                        chicken1.m_6518_(level, difficulty, MobSpawnType.JOCKEY, (SpawnGroupData)null, (CompoundTag)null);
                        chicken1.m_28273_(true);
                        this.m_20329_((Entity)chicken1);
                        level.m_7967_((Entity)chicken1);
                    }
                }
            }
            this.m_34336_(this.m_7586_() && randomsource.m_188501_() < f * 0.1f);
            this.m_213945_(randomsource, difficulty);
            this.m_213946_(randomsource, difficulty);
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && randomsource.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(randomsource.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        this.m_34339_(f);
        return groupData;
    }
}

