/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.setrion.mushroomified.registry.MBlocks;
import net.setrion.mushroomified.registry.MEntityType;
import net.setrion.mushroomified.registry.MItems;

public class Boat
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(Boat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int PADDLE_LEFT = 0;
    public static final int PADDLE_RIGHT = 1;
    public static final double PADDLE_SOUND_TIME = 0.7853981852531433;
    public static final int BUBBLE_TIME = 60;
    private final float[] paddlePositions = new float[2];
    private float invFriction;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private double waterLevel;
    private float landFriction;
    private Status status;
    private Status oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;

    public Boat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public Boat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)MEntityType.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected float m_6380_(Pose pose, EntityDimensions size) {
        return size.f_20378_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.OAKSHROOM.ordinal());
        this.f_19804_.m_135372_(DATA_ID_PADDLE_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_PADDLE_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_BUBBLE_TIME, (Object)0);
    }

    public boolean m_7337_(Entity other) {
        return Boat.canVehicleCollide(this, other);
    }

    public static boolean canVehicleCollide(Entity vehicle, Entity other) {
        return (other.m_5829_() || other.m_6094_()) && !vehicle.m_20365_(other);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle rect) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axis, rect));
    }

    public double m_6048_() {
        return -0.1;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            boolean bl = flag = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.destroy(source);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    protected void destroy(DamageSource source) {
        this.m_19998_((ItemLike)this.getDropItem());
    }

    public void m_6845_(boolean isDown) {
        if (!this.m_9236_().m_5776_()) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = isDown;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(60);
            }
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
            this.m_146852_(GameEvent.f_157784_, (Entity)this.m_6688_());
        }
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof Boat) {
            if (entity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entity);
            }
        } else if (entity.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(entity);
        }
    }

    public Item getDropItem() {
        switch (this.getBoatType()) {
            default: 
        }
        return (Item)MItems.OAKSHROOM_BOAT.get();
    }

    public void animateHurt() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int steps, boolean bool) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    public void m_8119_() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.m_9236_().m_5776_() && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        if (this.m_6109_()) {
            if (!(this.m_146895_() instanceof Player)) {
                this.setPaddleState(false, false);
            }
            this.floatBoat();
            if (this.m_9236_().m_5776_()) {
                Entity entity = this.m_146895_();
                if (entity instanceof LocalPlayer) {
                    LocalPlayer player = (LocalPlayer)entity;
                    Input input = player.f_108618_;
                    this.inputLeft = input.f_108570_;
                    this.inputRight = input.f_108571_;
                    this.inputUp = input.f_108568_;
                    this.inputDown = input.f_108569_;
                }
                this.controlBoat();
                this.m_9236_().m_5503_((Packet)new ServerboundPaddleBoatPacket(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.tickBubbleColumn();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.m_20067_() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.paddlePositions[i] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3 vec3 = this.m_20252_(1.0f);
                    double d0 = i == 1 ? -vec3.f_82481_ : vec3.f_82481_;
                    double d1 = i == 1 ? vec3.f_82479_ : -vec3.f_82479_;
                    this.m_9236_().m_6263_((Player)null, this.m_20185_() + d0, this.m_20186_(), this.m_20189_() + d1, soundevent, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                }
                int n = i;
                this.paddlePositions[n] = this.paddlePositions[n] + 0.3926991f;
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.m_20101_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.m_9236_().m_5776_() && !(this.m_6688_() instanceof Player);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < this.getMaxPassengers() && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    private void tickBubbleColumn() {
        if (this.m_9236_().m_5776_()) {
            int i = this.getBubbleTime();
            this.bubbleMultiplier = i > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = Mth.m_14036_((float)this.bubbleMultiplier, (float)0.0f, (float)1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5f * (float)this.m_9236_().m_46467_()) * this.bubbleMultiplier;
        } else {
            int k;
            if (!this.isAboveBubbleColumn) {
                this.setBubbleTime(0);
            }
            if ((k = this.getBubbleTime()) > 0) {
                this.setBubbleTime(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setBubbleTime(0);
                    Vec3 vec3 = this.m_20184_();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.m_20256_(vec3.m_82520_(0.0, -0.7, 0.0));
                        this.m_20153_();
                    } else {
                        this.m_20334_(vec3.f_82479_, this.m_146862_(p_150274_ -> p_150274_ instanceof Player) ? 2.7 : 0.6, vec3.f_82481_);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getStatus()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.f_11707_;
            }
            case ON_LAND: {
                return SoundEvents.f_11706_;
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void setPaddleState(boolean p_38340_, boolean p_38341_) {
        this.f_19804_.m_135381_(DATA_ID_PADDLE_LEFT, (Object)p_38340_);
        this.f_19804_.m_135381_(DATA_ID_PADDLE_RIGHT, (Object)p_38341_);
    }

    public float getRowingTime(int p_38316_, float p_38317_) {
        return this.getPaddleState(p_38316_) ? Mth.m_144920_((float)(this.paddlePositions[p_38316_] - 0.3926991f), (float)this.paddlePositions[p_38316_], (float)p_38317_) : 0.0f;
    }

    private Status getStatus() {
        Status boat$status = this.isUnderwater();
        if (boat$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return boat$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos));
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!this.m_20069_()) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderwater() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!this.m_20069_() || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void floatBoat() {
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.m_6688_() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)this.invFriction, vec3.f_82480_ + d1, vec3.f_82481_ * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d2 > 0.0) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(vec31.f_82479_, (vec31.f_82480_ + d2 * 0.06153846016296973) * 0.75, vec31.f_82481_);
            }
        }
    }

    private void controlBoat() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            if (this.inputUp) {
                f += 0.04f;
            }
            if (this.inputDown) {
                f -= 0.005f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            float f = this.getSinglePassengerXOffset();
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + entity.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(entity);
                f = i == 0 ? 0.2f : -0.6f;
                if (entity instanceof Animal) {
                    f += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            entity.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            entity.m_146922_(entity.m_146908_() + this.deltaRotation);
            entity.m_5616_(entity.m_6080_() + this.deltaRotation);
            this.clampRotation(entity);
            if (entity instanceof Animal && this.m_20197_().size() == this.getMaxPassengers()) {
                int j = entity.m_19879_() % 2 == 0 ? 90 : 270;
                entity.m_5618_(((Animal)entity).f_20883_ + (float)j);
                entity.m_5616_(entity.m_6080_() + (float)j);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Vec3 vec3 = Boat.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)entity.m_20205_(), (float)entity.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = new BlockPos((int)d0, (int)this.m_20191_().f_82292_, (int)d1);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.m_9236_().m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.m_9236_().m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : entity.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec31, (LivingEntity)entity, (Pose)pose)) continue;
                    entity.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(entity);
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity entity) {
        this.clampRotation(entity);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getBoatType().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setType(Type.byName(tag.m_128461_("Type")));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.m_9236_().f_46443_) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7840_(double distance, boolean flying, BlockState state, BlockPos pos) {
        this.lastYd = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (flying) {
                if (this.f_19789_ > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getBoatType().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.m_20069_() && distance < 0.0) {
                this.f_19789_ -= (float)distance;
            }
        }
    }

    public boolean getPaddleState(int state) {
        return (Boolean)this.f_19804_.m_135370_(state == 0 ? DATA_ID_PADDLE_LEFT : DATA_ID_PADDLE_RIGHT) != false && this.m_6688_() != null;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    private void setBubbleTime(int i) {
        this.f_19804_.m_135381_(DATA_ID_BUBBLE_TIME, (Object)i);
    }

    private int getBubbleTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_BUBBLE_TIME);
    }

    public float getBubbleAngle(float angle) {
        return Mth.m_14179_((float)angle, (float)this.bubbleAngleO, (float)this.bubbleAngle);
    }

    public void setHurtDir(int i) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setType(Type type) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public Type getBoatType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        return 2;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return (LivingEntity)this.m_146895_();
    }

    public void setInput(boolean left, boolean right, boolean up, boolean down) {
        this.inputLeft = left;
        this.inputRight = right;
        this.inputUp = up;
        this.inputDown = down;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public static enum Type {
        OAKSHROOM((Block)MBlocks.OAKSHROOM_PLANKS.get(), "oakshroom");

        private final String name;
        private final Block planks;

        private Type(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aboat$type = Type.values();
            if (id < 0 || id >= aboat$type.length) {
                id = 0;
            }
            return aboat$type[id];
        }

        public static Type byName(String name) {
            Type[] aboat$type = Type.values();
            for (int i = 0; i < aboat$type.length; ++i) {
                if (!aboat$type[i].getName().equals(name)) continue;
                return aboat$type[i];
            }
            return aboat$type[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

