/*
 * Decompiled with CFR 0.152.
 */
package net.setrion.mushroomified.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.setrion.mushroomified.registry.MEntityType;
import net.setrion.mushroomified.registry.MItems;
import net.setrion.mushroomified.world.entity.vehicle.Boat;

public class ChestBoat
extends Boat
implements HasCustomInventoryScreen,
ContainerEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));

    public ChestBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
    }

    public ChestBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)MEntityType.CHEST_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected float getSinglePassengerXOffset() {
        return 0.15f;
    }

    @Override
    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_219943_(tag);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_219934_(tag);
    }

    @Override
    public void destroy(DamageSource source) {
        super.destroy(source);
        this.m_219927_(source, this.m_9236_(), this);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_() && reason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    @Override
    public InteractionResult m_6096_(Player p_219898_, InteractionHand p_219899_) {
        if (this.m_7310_((Entity)p_219898_) && !p_219898_.m_36341_()) {
            return super.m_6096_(p_219898_, p_219899_);
        }
        InteractionResult interactionresult = this.m_268996_(p_219898_);
        if (interactionresult.m_19077_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)p_219898_);
            PiglinAi.m_34873_((Player)p_219898_, (boolean)true);
        }
        return interactionresult;
    }

    public void m_213583_(Player player) {
        player.m_5893_((MenuProvider)this);
        if (!player.m_9236_().m_5776_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    @Override
    public Item getDropItem() {
        switch (this.getBoatType()) {
            default: 
        }
        return (Item)MItems.OAKSHROOM_CHEST_BOAT.get();
    }

    public void m_6211_() {
        this.m_219953_();
    }

    public int m_6643_() {
        return 27;
    }

    public ItemStack m_8020_(int slot) {
        return this.m_219947_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.m_219936_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.m_219945_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.m_219940_(slot, stack);
    }

    public SlotAccess m_141942_(int slot) {
        return this.m_219951_(slot);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return this.m_219954_(player);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.lootTable != null && player.m_5833_()) {
            return null;
        }
        this.unpackLootTable(inventory.f_35978_);
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    public void unpackLootTable(@Nullable Player player) {
        this.m_219949_(player);
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    public void m_214199_(@Nullable ResourceLocation loot) {
        this.lootTable = loot;
    }

    public long m_213803_() {
        return this.lootTableSeed;
    }

    public void m_214065_(long seed) {
        this.lootTableSeed = seed;
    }

    public NonNullList<ItemStack> m_213659_() {
        return this.itemStacks;
    }

    public void m_213775_() {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    }
}

