/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nmuk.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.siphalor.nmuk.NMUK;
import de.siphalor.nmuk.impl.AlternativeKeyBinding;
import de.siphalor.nmuk.impl.AmecsProxy;
import de.siphalor.nmuk.impl.IKeyBinding;
import de.siphalor.nmuk.impl.mixin.ControlsOptionsScreenAccessor;
import de.siphalor.nmuk.impl.mixin.EntryListWidgetAccessor;
import de.siphalor.nmuk.impl.mixin.GameOptionsAccessor;
import de.siphalor.nmuk.impl.mixin.KeyBindingRegistryImplAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_459;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NMUKKeyBindingHelper {
    public static final Multimap<class_304, class_304> defaultAlternatives = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    private static final boolean isAmecsLoaded = FabricLoader.getInstance().isModLoaded("amecsapi");

    public static void removeKeyBinding(class_304 binding) {
        List<class_304> moddedKeyBindings = KeyBindingRegistryImplAccessor.getModdedKeyBindings();
        boolean success = moddedKeyBindings.remove(binding);
        if (!success) {
            NMUK.log(Level.ERROR, "Failed to remove modded keybinding!");
        }
        GameOptionsAccessor options = (GameOptionsAccessor)class_310.method_1551().field_1690;
        Object[] keysAll = options.getKeysAll();
        int index = ArrayUtils.indexOf((Object[])keysAll, (Object)binding);
        class_304[] newKeysAll = new class_304[keysAll.length - 1];
        System.arraycopy(keysAll, 0, newKeysAll, 0, index);
        System.arraycopy(keysAll, index + 1, newKeysAll, index, keysAll.length - index - 1);
        options.setKeysAll(newKeysAll);
        class_304.method_1426();
    }

    public static void registerKeyBinding(class_304 binding) {
        KeyBindingHelper.registerKeyBinding((class_304)binding);
        GameOptionsAccessor options = (GameOptionsAccessor)class_310.method_1551().field_1690;
        if (options != null) {
            class_304[] keysAll = options.getKeysAll();
            class_304[] newKeysAll = new class_304[keysAll.length + 1];
            System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
            newKeysAll[keysAll.length] = binding;
            options.setKeysAll(newKeysAll);
        }
        class_304.method_1426();
    }

    public static void registerKeyBindings(class_315 gameOptions, Collection<class_304> bindings) {
        GameOptionsAccessor options = (GameOptionsAccessor)gameOptions;
        class_304[] keysAll = options.getKeysAll();
        class_304[] newKeysAll = new class_304[keysAll.length + bindings.size()];
        System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
        int i = keysAll.length;
        for (class_304 binding : bindings) {
            KeyBindingHelper.registerKeyBinding((class_304)binding);
            newKeysAll[i] = binding;
            ++i;
        }
        options.setKeysAll(newKeysAll);
        class_304.method_1426();
    }

    public static void resetSingleKeyBinding(class_304 keyBinding) {
        keyBinding.method_1422(keyBinding.method_1429());
        if (isAmecsLoaded) {
            AmecsProxy.resetKeyModifiers(keyBinding);
        }
    }

    public static class_304 createAlternativeKeyBinding(class_304 base) {
        return NMUKKeyBindingHelper.createAlternativeKeyBinding(base, -1);
    }

    public static class_304 createAlternativeKeyBinding(class_304 base, int code) {
        return NMUKKeyBindingHelper.createAlternativeKeyBinding(base, class_3675.class_307.field_1668, code);
    }

    public static class_304 createAlternativeKeyBinding(class_304 base, class_3675.class_307 type, int code) {
        IKeyBinding parent = (IKeyBinding)base;
        AlternativeKeyBinding alt = new AlternativeKeyBinding(base, base.method_1431() + "%" + parent.nmuk_getNextChildId(), type, code, base.method_1423());
        parent.nmuk_addAlternative(alt);
        return alt;
    }

    public static List<class_459.class_462> getControlsListWidgetEntries() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof ControlsOptionsScreenAccessor) {
            return ((EntryListWidgetAccessor)((ControlsOptionsScreenAccessor)screen).getKeyBindingListWidget()).getChildren();
        }
        return null;
    }

    public static class_459.class_462 createKeyBindingEntry(class_459 listWidget, class_304 binding, class_2561 text) {
        try {
            Constructor constructor = class_459.class_462.class.getDeclaredConstructor(class_459.class, class_304.class, class_2561.class);
            constructor.setAccessible(true);
            return (class_459.class_462)constructor.newInstance(listWidget, binding, text);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

