/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.utils;

import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Timer {
    private final int TICKS;
    private final Action ACTION;
    private int tick;

    private Timer(int ticks, Action action) {
        this.TICKS = ticks;
        this.ACTION = action;
    }

    public static void create(int ticks, Action action) {
        Timer event = new Timer(ticks, action);
        MinecraftForge.EVENT_BUS.register((Object)event);
    }

    @SubscribeEvent
    public void tick(@Nonnull TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tick;
        if (this.tick >= this.TICKS) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        ExceptionFilter.of(() -> this.ACTION.run(this));
    }

    @SubscribeEvent
    public void tick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tick;
        if (this.tick >= this.TICKS) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        ExceptionFilter.of(() -> this.ACTION.run(this));
    }

    public int getTick() {
        return this.tick;
    }

    public int getMaxTick() {
        return this.TICKS;
    }

    @FunctionalInterface
    public static interface Action {
        public void run(Timer var1) throws Exception;
    }
}

