/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.obscuria.tooltips.ObscureTooltipsConfig;
import com.obscuria.tooltips.client.StyleManager;
import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.Effects;
import com.obscuria.tooltips.client.style.TooltipStyle;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class TooltipRenderer {
    @Nullable
    private static TooltipStyle renderStyle = null;
    @Nullable
    private static ArmorStand renderStand;
    private static ItemStack renderStack;
    private static long tooltipStartMillis;
    private static float tooltipSeconds;

    public static boolean render(TooltipContext renderer, ItemStack stack, Font font, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner) {
        TooltipRenderer.updateStyle(stack);
        if (renderStyle == null || components.isEmpty()) {
            return false;
        }
        renderer.define(renderStack, tooltipSeconds);
        Component summaryField = TooltipRenderer.getRarityName(stack);
        Point size = TooltipRenderer.calculateSize(font, components, summaryField);
        Vector2ic rawPos = positioner.m_262814_(renderer.width(), renderer.height(), x, y, size.x, size.y);
        Vec2 pos = new Vec2((float)rawPos.x(), (float)rawPos.y());
        renderer.pose().m_85836_();
        renderer.drawManaged(() -> renderStyle.renderEffects(Effects.Order.LAYER_1_BACK, renderer, pos, size));
        renderer.drawManaged(() -> renderStyle.renderBack(renderer, pos, size, true));
        renderer.pose().m_252880_(0.0f, 0.0f, 400.0f);
        renderer.context().m_280430_(Minecraft.m_91087_().f_91062_, summaryField, (int)pos.f_82470_ + 26, (int)pos.f_82471_ + 13, -11513776);
        renderer.drawManaged(() -> renderStyle.renderEffects(Effects.Order.LAYER_2_BACK$TEXT, renderer, pos, size));
        TooltipRenderer.renderText(renderer, font, components, pos);
        TooltipRenderer.renderImages(renderer, font, components, pos);
        renderer.drawManaged(() -> renderStyle.renderFront(renderer, pos, size));
        renderer.drawManaged(() -> renderStyle.renderEffects(Effects.Order.LAYER_5_FRONT, renderer, pos, size));
        renderer.pose().m_85849_();
        if (stack.m_41720_() instanceof ArmorItem && ((Boolean)ObscureTooltipsConfig.Client.displayArmorModels.get()).booleanValue()) {
            Vec2 center = TooltipRenderer.renderSecondPanel(renderer, pos);
            TooltipRenderer.equip(stack);
            TooltipRenderer.renderStand(renderer, center.m_165910_(new Vec2(0.0f, 26.0f)));
        } else if (stack.m_41720_() instanceof TieredItem && ((Boolean)ObscureTooltipsConfig.Client.displayToolModels.get()).booleanValue()) {
            Vec2 center = TooltipRenderer.renderSecondPanel(renderer, pos);
            renderer.pose().m_85836_();
            renderer.pose().m_252880_(center.f_82470_, center.f_82471_, 500.0f);
            renderer.pose().m_85841_(2.75f, 2.75f, 2.75f);
            renderer.pose().m_252781_(Axis.f_252529_.m_252977_(-30.0f));
            renderer.pose().m_252781_(Axis.f_252436_.m_252977_((float)((double)System.currentTimeMillis() / 1000.0 % 360.0) * -20.0f));
            renderer.pose().m_252781_(Axis.f_252403_.m_252977_(-45.0f));
            renderer.pose().m_85836_();
            renderer.pose().m_252880_(-8.0f, -8.0f, -150.0f);
            renderer.context().m_280480_(stack, 0, 0);
            renderer.pose().m_85849_();
            renderer.pose().m_85849_();
        }
        renderer.flush();
        return true;
    }

    private static Vec2 renderSecondPanel(TooltipContext renderer, Vec2 pos) {
        renderer.drawManaged(() -> renderStyle.renderBack(renderer, pos.m_165910_(new Vec2(-55.0f, 0.0f)), new Point(30, 60), false));
        return pos.m_165910_(new Vec2(-40.0f, 30.0f));
    }

    @Contract(value="_ -> new")
    private static Component getRarityName(ItemStack stack) {
        return Component.m_237115_((String)("rarity." + stack.m_41791_().name().toLowerCase() + ".name"));
    }

    private static Point calculateSize(Font font, List<ClientTooltipComponent> components, Component summaryField) {
        int width = 26 + components.get(0).m_142069_(font);
        int height = 14;
        for (ClientTooltipComponent component : components) {
            int componentWidth = component.m_142069_(font);
            if (componentWidth > width) {
                width = componentWidth;
            }
            height += component.m_142103_();
        }
        int SummaryWidth = 26 + font.m_92895_(summaryField.getString());
        if (SummaryWidth > width) {
            width = SummaryWidth;
        }
        return new Point(width, height);
    }

    private static void renderText(TooltipContext renderer, Font font, List<ClientTooltipComponent> components, Vec2 pos) {
        int offset = (int)pos.f_82471_ + 3;
        for (int i = 0; i < components.size(); ++i) {
            ClientTooltipComponent component = components.get(i);
            component.m_142440_(font, (int)pos.f_82470_ + (i == 0 ? 26 : 0), offset, renderer.pose().m_85850_().m_252922_(), renderer.bufferSource());
            offset += component.m_142103_() + (i == 0 ? 13 : 0);
        }
    }

    private static void renderImages(TooltipContext renderer, Font font, List<ClientTooltipComponent> components, Vec2 pos) {
        int offset = (int)pos.f_82471_ + 4;
        for (int i = 0; i < components.size(); ++i) {
            ClientTooltipComponent component = components.get(i);
            component.m_183452_(font, (int)pos.f_82470_, offset, renderer.context());
            offset += component.m_142103_() + (i == 0 ? 13 : 0);
        }
    }

    private static void renderStand(TooltipContext renderer, Vec2 pos) {
        if (renderStand == null || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        renderer.push(() -> {
            renderer.translate(pos.f_82470_, pos.f_82471_, 500.0f);
            renderer.scale(-30.0f, -30.0f, 30.0f);
            renderer.mul(Axis.f_252529_.m_252977_(25.0f));
            renderer.mul(Axis.f_252436_.m_252977_((float)((double)System.currentTimeMillis() / 1000.0 % 360.0) * 20.0f));
            Lighting.m_166384_();
            EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
            entityrenderdispatcher.m_114468_(false);
            RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)renderStand, 0.0, 0.0, 0.0, 0.0f, 1.0f, renderer.pose(), (MultiBufferSource)renderer.bufferSource(), 0xF000F0));
            renderer.flush();
            entityrenderdispatcher.m_114468_(true);
        });
        Lighting.m_84931_();
    }

    private static void equip(ItemStack stack) {
        if (renderStand == null) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            renderStand.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            renderStand.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            renderStand.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
            renderStand.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
            renderStand.m_8061_(armorItem.m_40402_(), stack);
        }
    }

    private static void updateStyle(ItemStack stack) {
        if (renderStand == null && Minecraft.m_91087_().f_91073_ != null) {
            renderStand = new ArmorStand(EntityType.f_20529_, (Level)Minecraft.m_91087_().f_91073_);
        }
        if (stack.m_41619_()) {
            TooltipRenderer.reset();
        } else {
            tooltipSeconds = (float)(System.currentTimeMillis() - tooltipStartMillis) / 1000.0f;
            if (stack == renderStack) {
                return;
            }
            TooltipRenderer.reset();
            renderStack = stack;
            renderStyle = StyleManager.getStyleFor(stack).orElse(null);
            if (renderStyle != null) {
                renderStyle.reset();
            }
        }
        renderStack = stack;
    }

    private static void reset() {
        if (renderStyle != null) {
            renderStyle.reset();
        }
        renderStyle = null;
        tooltipStartMillis = System.currentTimeMillis();
        tooltipSeconds = 0.0f;
    }

    public static void clear() {
        renderStack = ItemStack.f_41583_;
        if (renderStyle != null) {
            renderStyle.reset();
        }
        renderStyle = null;
    }

    static {
        renderStack = ItemStack.f_41583_;
        tooltipStartMillis = 0L;
        tooltipSeconds = 0.0f;
    }
}

