/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style.effect;

import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.Effects;
import com.obscuria.tooltips.client.style.effect.TooltipEffect;
import com.obscuria.tooltips.client.style.particle.EnderParticle;
import com.obscuria.tooltips.client.style.particle.TooltipParticle;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec2;

public class EnderEffect
implements TooltipEffect {
    protected final int CENTER_COLOR;
    protected final int EDGE_COLOR;
    protected final List<TooltipParticle> particles = new ArrayList<TooltipParticle>();
    protected float lastParticle = -0.2f;

    public EnderEffect(int centerColor, int edgeColor) {
        this.CENTER_COLOR = centerColor;
        this.EDGE_COLOR = edgeColor;
    }

    @Override
    public void render(TooltipContext context, Vec2 pos, Point size) {
        if (context.time() - this.lastParticle >= 0.25f) {
            this.lastParticle = context.time();
            Vec2 center = new Vec2(pos.f_82470_ + 13.0f, pos.f_82471_ + 13.0f);
            this.particles.add(new EnderParticle(this.CENTER_COLOR, this.EDGE_COLOR, 3.0f, center, 13.0f));
        }
        context.renderParticles(this.particles);
    }

    @Override
    public void reset() {
        this.lastParticle = -0.2f;
        this.particles.clear();
    }

    @Override
    public Effects.Order order() {
        return Effects.Order.LAYER_5_FRONT;
    }

    @Override
    public boolean canStackWith(TooltipEffect other) {
        return !(other instanceof EnderEffect);
    }
}

