/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscuretooltips;

import com.obscuria.obscureapi.ObscureAPI;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModConfig {
    public static void init() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "Obscuria");
        try {
            Files.createDirectory(modConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ObscureAPI.LOGGER.error("Failed to create Obscuria config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Client.CLIENT_SPEC, "Obscuria/obscure-tooltips-client.toml");
    }

    public static class Client {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec CLIENT_SPEC;
        public static final ForgeConfigSpec.BooleanValue armorPreview;
        public static final ForgeConfigSpec.BooleanValue model;
        public static final ForgeConfigSpec.DoubleValue scale;

        static {
            BUILDER.push("Settings");
            armorPreview = BUILDER.worldRestart().comment("If enabled, armor model will be displayed next to tooltip.").define("ArmorPreview", true);
            model = BUILDER.worldRestart().comment(new String[]{"If enabled, item icons will be 3D. This option is", "overridden by entries from the resource pack."}).define("3DModels", true);
            scale = BUILDER.worldRestart().comment(new String[]{"Basic icon scale. This option is overridden by entries from", "the resource pack."}).defineInRange("Scale", 2.0, 1.0, 20.0);
            BUILDER.pop();
            CLIENT_SPEC = BUILDER.build();
        }
    }
}

