/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscuretooltips.tooltips;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.obscuria.obscureapi.utils.TextHelper;
import com.obscuria.obscuretooltips.ModConfig;
import com.obscuria.obscuretooltips.Resources;
import com.obscuria.obscuretooltips.tooltips.Override;
import com.obscuria.obscuretooltips.tooltips.Style;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TooltipRenderer {
    private static LivingEntity ARMOR_STAND = null;
    private static int tickLerp = 0;
    private static int tick = 0;

    public static void onTick(TickEvent.ClientTickEvent event) {
        if (ARMOR_STAND == null) {
            LivingEntity livingEntity = ARMOR_STAND = Minecraft.m_91087_().f_91073_ != null ? (LivingEntity)EntityType.f_20529_.m_20615_((Level)Minecraft.m_91087_().f_91073_) : null;
        }
        if (ARMOR_STAND != null) {
            ++TooltipRenderer.ARMOR_STAND.f_19797_;
        }
        if (event.phase == TickEvent.Phase.START) {
            tickLerp = tick;
            tick += 3;
        }
    }

    public static void onTooltip(@NotNull RenderTooltipEvent event) {
        if (event.getItemStack() == ItemStack.f_41583_) {
            return;
        }
        event.setCanceled(true);
        TooltipRenderer.drawTooltip(event.getPoseStack(), event.getComponents(), event.getFont(), event.getItemStack(), event.getX(), event.getY());
    }

    private static void drawTooltip(PoseStack pose, @NotNull List<ClientTooltipComponent> components, Font font, ItemStack stack, int x, int y) {
        ClientTooltipComponent tooltipComponent;
        int i;
        if (components.isEmpty() || Minecraft.m_91087_().f_91080_ == null) {
            return;
        }
        ArrayList<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>(components);
        Override override = Resources.INSTANCE.getOverride(stack.m_41720_());
        Style style = Resources.INSTANCE.getStyle(stack, override);
        Component type = TextHelper.component((String)("\u00a77" + Resources.INSTANCE.getType(stack, override)));
        String render = Resources.INSTANCE.getRender(stack, override);
        float scale = Resources.INSTANCE.getScale(stack, override);
        int xOffset = override.X_OFFSET;
        int yOffset = override.Y_OFFSET;
        int width = 0;
        int height = lines.size() == 1 ? -2 : 0;
        int totalLines = 0;
        if (lines.size() > 1 && ((ClientTooltipComponent)lines.get(1)).m_142069_(font) == 0) {
            lines.remove(1);
        }
        for (ClientTooltipComponent clienttooltipcomponent : lines) {
            int lineWidth = 12 + clienttooltipcomponent.m_142069_(font) + (totalLines == 0 ? 36 : 0);
            if (lineWidth > width) {
                width = lineWidth;
            }
            height += clienttooltipcomponent.m_142103_() + (totalLines == 1 ? 27 : 0);
            ++totalLines;
        }
        if (font.m_92852_((FormattedText)type) + 48 > width) {
            width = font.m_92852_((FormattedText)type) + 48;
        }
        height = Math.max(30, height) + 12;
        int xPos = x + 6;
        int yPos = y - 18;
        if (xPos + width > Minecraft.m_91087_().f_91080_.f_96543_) {
            xPos -= 28 + width;
        }
        if (yPos + height + 6 > Minecraft.m_91087_().f_91080_.f_96544_) {
            yPos = Minecraft.m_91087_().f_91080_.f_96544_ - height - 6;
        }
        if (stack.m_41720_() instanceof ArmorItem && ((Boolean)ModConfig.Client.armorPreview.get()).booleanValue()) {
            TooltipRenderer.drawArmorPreview(pose, stack, xPos, yPos);
        }
        TooltipRenderer.drawFrame(style, pose, xPos, yPos, 400, width, height, true, true);
        pose.m_85836_();
        float blitOffset = Minecraft.m_91087_().m_91291_().f_115093_;
        Minecraft.m_91087_().m_91291_().f_115093_ = 400.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = pose.m_85850_().m_85861_();
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        pose.m_85837_(0.0, 0.0, 400.0);
        int yPosLine = yPos + 11;
        for (i = 0; i < lines.size(); ++i) {
            tooltipComponent = (ClientTooltipComponent)lines.get(i);
            tooltipComponent.m_142440_(font, xPos + 6 + (i == 0 ? 36 : 0), yPosLine, matrix4f, multibuffersource$buffersource);
            yPosLine += tooltipComponent.m_142103_() + (i == 0 ? 2 : 0);
            if (i != 0) continue;
            yPosLine += 20;
        }
        multibuffersource$buffersource.m_109911_();
        pose.m_85849_();
        yPosLine = yPos + 11;
        for (i = 0; i < lines.size(); ++i) {
            tooltipComponent = (ClientTooltipComponent)lines.get(i);
            tooltipComponent.m_183452_(font, xPos + 6 + (i == 0 ? 36 : 0), yPosLine, pose, Minecraft.m_91087_().m_91291_(), 400);
            yPosLine += tooltipComponent.m_142103_() + (i == 0 ? 2 : 0);
            if (i != 0) continue;
            yPosLine += 20;
        }
        pose.m_85836_();
        pose.m_85837_((double)xPos, (double)yPos, 400.0);
        font.m_92763_(pose, type, 42.0f, 22.0f, 0);
        pose.m_85849_();
        Minecraft.m_91087_().m_91291_().f_115093_ = blitOffset;
        if (render.equals("model")) {
            TooltipRenderer.renderItemModel(stack, xPos, yPos, scale, xOffset, yOffset);
        } else {
            TooltipRenderer.renderItemFlat(stack, xPos, yPos, scale, xOffset, yOffset);
        }
    }

    private static void drawFrame(@NotNull Style style, @NotNull PoseStack pose, int xPos, int yPos, int depth, int width, int height, boolean item, boolean delimiter) {
        pose.m_85836_();
        pose.m_85837_((double)xPos, (double)yPos, (double)depth);
        TooltipRenderer.start();
        RenderSystem.m_157456_((int)0, (ResourceLocation)style.BACKGROUND);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)4, (int)4, (int)8, (int)8);
        GuiComponent.m_93133_((PoseStack)pose, (int)(4 + Math.max(++width - 8, 0)), (int)0, (float)4.0f, (float)0.0f, (int)4, (int)4, (int)8, (int)8);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)(4 + Math.max(++height - 8, 0)), (float)0.0f, (float)4.0f, (int)4, (int)4, (int)8, (int)8);
        GuiComponent.m_93133_((PoseStack)pose, (int)(4 + Math.max(width - 8, 0)), (int)(4 + Math.max(height - 8, 0)), (float)4.0f, (float)4.0f, (int)4, (int)4, (int)8, (int)8);
        if (width > 8) {
            pose.m_85836_();
            pose.m_85837_(4.0, 0.0, 0.0);
            pose.m_85841_((float)(width - 8), 1.0f, 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)4.0f, (float)0.0f, (int)1, (int)4, (int)8, (int)8);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_(4.0, (double)(4 + Math.max(height - 8, 0)), 0.0);
            pose.m_85841_((float)(width - 8), 1.0f, 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)4.0f, (float)4.0f, (int)1, (int)4, (int)8, (int)8);
            pose.m_85849_();
        }
        if (height > 8) {
            pose.m_85836_();
            pose.m_85837_(0.0, 4.0, 0.0);
            pose.m_85841_(1.0f, (float)(height - 8), 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)4.0f, (int)4, (int)1, (int)8, (int)8);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_((double)(4 + Math.max(width - 8, 0)), 4.0, 0.0);
            pose.m_85841_(1.0f, (float)(height - 8), 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)4.0f, (float)4.0f, (int)4, (int)1, (int)8, (int)8);
            pose.m_85849_();
        }
        if (width > 8 && height > 8) {
            pose.m_85836_();
            pose.m_85837_(4.0, 4.0, 0.0);
            pose.m_85841_((float)(width - 8), (float)(height - 8), 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)4.0f, (float)4.0f, (int)1, (int)1, (int)8, (int)8);
            pose.m_85849_();
        }
        TooltipRenderer.end();
        --width;
        --height;
        TooltipRenderer.start();
        RenderSystem.m_157456_((int)0, (ResourceLocation)style.BORDER);
        pose.m_85836_();
        pose.m_85837_(1.0, 1.0, 0.0);
        pose.m_85841_((float)(width - 2) / 100.0f, 1.0f, 1.0f);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)100, (int)1, (int)100, (int)100);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(1.0, (double)(height - 2), 0.0);
        pose.m_85841_((float)(width - 2) / 100.0f, 1.0f, 1.0f);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)99.0f, (int)100, (int)1, (int)100, (int)100);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(1.0, 1.0, 0.0);
        pose.m_85841_(1.0f, (float)(height - 2) / 100.0f, 1.0f);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)1, (int)100, (int)100, (int)100);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_((double)(width - 2), 1.0, 0.0);
        pose.m_85841_(1.0f, (float)(height - 2) / 100.0f, 1.0f);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)99.0f, (float)0.0f, (int)1, (int)100, (int)100, (int)100);
        pose.m_85849_();
        if (item) {
            pose.m_85836_();
            pose.m_85837_(7.0, 7.0, 0.0);
            pose.m_85841_(2.0f, 2.0f, 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)2.0f, (float)4.0f, (int)24, (int)24, (int)100, (int)100);
            pose.m_85849_();
        }
        if (delimiter && height > 42) {
            pose.m_85836_();
            pose.m_85837_(3.0, 38.0, 0.0);
            pose.m_85841_((float)(width - 6) / 96.0f, 1.0f, 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)2.0f, (float)2.0f, (int)96, (int)1, (int)100, (int)100);
            pose.m_85849_();
        }
        TooltipRenderer.end();
        TooltipRenderer.start();
        RenderSystem.m_157456_((int)0, (ResourceLocation)style.DECOR);
        pose.m_85836_();
        pose.m_85837_(-1.0, -1.0, 0.0);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)80, (int)32);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(-1.0, (double)(height - 15), 0.0);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)16.0f, (int)16, (int)16, (int)80, (int)32);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_((double)(width - 15), -1.0, 0.0);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)64.0f, (float)0.0f, (int)16, (int)16, (int)80, (int)32);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_((double)(width - 15), (double)(height - 15), 0.0);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)64.0f, (float)16.0f, (int)16, (int)16, (int)80, (int)32);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_((double)(Math.round((float)width / 2.0f) - 24), -6.0, 0.0);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)16.0f, (float)0.0f, (int)48, (int)16, (int)80, (int)32);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_((double)(Math.round((float)width / 2.0f) - 24), (double)(height - 10), 0.0);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)16.0f, (float)16.0f, (int)48, (int)16, (int)80, (int)32);
        pose.m_85849_();
        TooltipRenderer.end();
        pose.m_85849_();
    }

    private static void renderItemModel(ItemStack stack, int xPos, int yPos, float scale, int xOffset, int yOffset) {
        PoseStack pose = RenderSystem.m_157191_();
        float rot = Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)tickLerp, (float)tick);
        float xO = (float)(Math.sin(Math.toRadians(rot)) * (double)(150.0f * scale));
        float zO = (float)(Math.cos(Math.toRadians(rot)) * (double)(150.0f * scale));
        float x02 = (float)(Math.sin(Math.toRadians(rot + 90.0f)) * (double)(8.0f * scale));
        float zO2 = (float)(Math.cos(Math.toRadians(rot + 90.0f)) * (double)(8.0f * scale));
        pose.m_85836_();
        pose.m_85837_((double)((float)(xPos + 21 + xOffset) - xO - x02), (double)((float)(yPos + 13 + yOffset) - 8.0f * (scale - 1.0f)), (double)(400.0f - zO - zO2));
        pose.m_85841_(scale, scale, scale);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(rot));
        Minecraft.m_91087_().m_91291_().m_115203_(stack, 0, 0);
        pose.m_85849_();
    }

    private static void renderItemFlat(ItemStack stack, int xPos, int yPos, float scale, int xOffset, int yOffset) {
        PoseStack pose = RenderSystem.m_157191_();
        pose.m_85836_();
        pose.m_85837_((double)((float)(xPos + 13 + xOffset) - 8.0f * (scale - 1.0f)), (double)((float)(yPos + 13 + yOffset) - 8.0f * (scale - 1.0f)), 400.0);
        pose.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_115203_(stack, 0, 0);
        pose.m_85849_();
    }

    private static void drawArmorPreview(PoseStack pose, ItemStack stack, int x, int y) {
        if (ARMOR_STAND == null) {
            return;
        }
        TooltipRenderer.clearArmorStand();
        TooltipRenderer.drawFrame(Resources.DEFAULT_STYLE, pose, x - 60, y, 400, 46, 80, false, false);
        ARMOR_STAND.m_8061_(LivingEntity.m_147233_((ItemStack)stack), stack.m_41777_());
        TooltipRenderer.renderEntity(x - 37, y + 68, 30, 0.0f, 0.0f, ARMOR_STAND);
    }

    private static void clearArmorStand() {
        if (ARMOR_STAND == null) {
            return;
        }
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ARMOR_STAND.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
        for (EquipmentSlot equipmentSlot : InteractionHand.values()) {
            ARMOR_STAND.m_21008_((InteractionHand)equipmentSlot, ItemStack.f_41583_);
        }
    }

    private static void renderEntity(int x, int y, int scale, float xHead, float yHead, @NotNull LivingEntity entity) {
        RenderSystem.m_69482_();
        float f = (float)Math.atan(xHead / 40.0f);
        float f1 = (float)Math.atan(yHead / 40.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 500.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 0.0);
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        posestack1.m_85845_(Vector3f.f_122223_.m_122240_(200.0f));
        posestack1.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)tickLerp, (float)tick)));
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion.m_80157_();
        entityrenderdispatcher.m_114412_(quaternion);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private static void start() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    private static void end() {
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

