/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi;

import com.obscuria.obscureapi.ObscureAPIConfig;
import com.obscuria.obscureapi.animations.HekateHandler;
import com.obscuria.obscureapi.attributes.AttributesHandler;
import com.obscuria.obscureapi.classes.ObscureClass;
import com.obscuria.obscureapi.library.world.items.ChakraItem;
import com.obscuria.obscureapi.network.AnimationMessage;
import com.obscuria.obscureapi.registry.ObscureAPIAttributes;
import com.obscuria.obscureapi.registry.ObscureAPIEnchantments;
import com.obscuria.obscureapi.registry.ObscureAPIItems;
import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="obscure_api")
public class ObscureAPI {
    public static final Logger LOGGER = LogManager.getLogger(ObscureAPI.class);
    public static final String MODID = "obscure_api";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("obscure_api", "obscure_api"), () -> "1", "1"::equals, "1"::equals);
    public static final HashMap<String, String> COLLECTION = new HashMap();
    public static final EnchantmentCategory CHAKRA_CATEGORY = EnchantmentCategory.create((String)"Chakra", item -> item instanceof ChakraItem);
    private static int messageID = 0;

    public ObscureAPI() {
        ObscureAPI.addMod(MODID, "obscure-api");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ObscureAPIConfig.init();
        ObscureAPIItems.REGISTRY.register(bus);
        ObscureAPIEnchantments.REGISTRY.register(bus);
        ObscureAPIMobEffects.REGISTRY.register(bus);
        ObscureAPIAttributes.REGISTRY.register(bus);
        MinecraftForge.EVENT_BUS.addListener(HekateHandler::onEntityTick);
        MinecraftForge.EVENT_BUS.addListener(AttributesHandler::onPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(AttributesHandler::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(AttributesHandler::onLivingDamage);
        MinecraftForge.EVENT_BUS.addListener(AttributesHandler::onLivingHeal);
        MinecraftForge.EVENT_BUS.addListener(AttributesHandler::onLivingHurt);
        bus.addListener(AttributesHandler::addAttributes);
        ObscureAPI.addAnimationMessage();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void addAnimationMessage() {
        PACKET_HANDLER.messageBuilder(AnimationMessage.class, messageID, NetworkDirection.PLAY_TO_CLIENT).encoder(AnimationMessage::encode).decoder(AnimationMessage::new).consumer(AnimationMessage::handle).add();
        ++messageID;
    }

    public static void addMod(String modID, String curseforgeSlug) {
        COLLECTION.put(modID, curseforgeSlug);
    }

    public static class Classes {
        private static final HashMap<ResourceLocation, ObscureClass> CLASSES = new HashMap();
        public static final ObscureClass BLANK = new ObscureClass("obscure_api", "blank");
        public static final ObscureClass PALADIN = Classes.register(new ObscureClass("obscure_api", "paladin"));
        public static final ObscureClass DARK_KNIGHT = Classes.register(new ObscureClass("obscure_api", "dark_knight"));
        public static final ObscureClass NECROMANCER = Classes.register(new ObscureClass("obscure_api", "necromancer"));
        public static final ObscureClass REAPER = Classes.register(new ObscureClass("obscure_api", "reaper"));
        public static final ObscureClass SHAMAN = Classes.register(new ObscureClass("obscure_api", "shaman"));
        public static final ObscureClass WARLOCK = Classes.register(new ObscureClass("obscure_api", "warlock"));
        public static final ObscureClass CHARMER = Classes.register(new ObscureClass("obscure_api", "charmer"));
        public static final ObscureClass ROGUE = Classes.register(new ObscureClass("obscure_api", "rogue"));
        public static final ObscureClass HUNTER = Classes.register(new ObscureClass("obscure_api", "hunter"));
        public static final ObscureClass CHIEFTAIN = Classes.register(new ObscureClass("obscure_api", "chieftain"));

        public static ObscureClass register(ObscureClass obscureClass) {
            CLASSES.put(obscureClass.getRegistry(), obscureClass);
            return obscureClass;
        }

        public static boolean isPresent(ResourceLocation key) {
            return CLASSES.containsKey(key);
        }

        public static ObscureClass get(ResourceLocation key) {
            return CLASSES.getOrDefault(key, BLANK);
        }
    }
}

