/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.animations;

import com.obscuria.obscureapi.animations.AnimatedPart;
import com.obscuria.obscureapi.animations.HekateAnimation;
import com.obscuria.obscureapi.animations.HekateProvider;
import com.obscuria.obscureapi.animations.IHekateProvider;
import com.obscuria.obscureapi.animations.KeyFrame;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class HekateLib {
    public static void updateScale(Entity entity, float scale, float speed) {
        float scaleIn = entity.getPersistentData().m_128457_("HScale");
        entity.getPersistentData().m_128350_("HScaleLerp", scaleIn);
        scaleIn = scale != scaleIn ? Mth.m_14179_((float)speed, (float)scaleIn, (float)scale) : scaleIn;
        entity.getPersistentData().m_128350_("HScale", scaleIn);
    }

    public static void i(@NotNull ModelPart part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer) {
        part.f_104203_ += render.idle(x, baseX * -1.0f, speed, offset, timer);
        part.f_104204_ += render.idle(y, baseY * -1.0f, speed, offset, timer);
        part.f_104205_ += render.idle(z, baseZ, speed, offset, timer);
    }

    public static void i(@NotNull ModelPart part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod2) {
        part.f_104203_ += render.idle(x, baseX * -1.0f, speed, offset, timer, mod2);
        part.f_104204_ += render.idle(y, baseY * -1.0f, speed, offset, timer, mod2);
        part.f_104205_ += render.idle(z, baseZ, speed, offset, timer, mod2);
    }

    public static void i(@NotNull ModelPart part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod1, float mod2) {
        part.f_104203_ += render.idle(x, baseX * -1.0f, speed, offset, timer, mod1, mod2);
        part.f_104204_ += render.idle(y, baseY * -1.0f, speed, offset, timer, mod1, mod2);
        part.f_104205_ += render.idle(z, baseZ, speed, offset, timer, mod1, mod2);
    }

    public static void m(@NotNull ModelPart part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod2) {
        part.f_104203_ += render.move(x, baseX * -1.0f, speed, offset, timer, mod2);
        part.f_104204_ += render.move(y, baseY * -1.0f, speed, offset, timer, mod2);
        part.f_104205_ += render.move(z, baseZ, speed, offset, timer, mod2);
    }

    public static void m(@NotNull ModelPart part, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod1, float mod2) {
        part.f_104203_ += render.move(x, baseX * -1.0f, speed, offset, timer, mod1, mod2);
        part.f_104204_ += render.move(y, baseY * -1.0f, speed, offset, timer, mod1, mod2);
        part.f_104205_ += render.move(z, baseZ, speed, offset, timer, mod1, mod2);
    }

    public static void m(@NotNull ModelPart part, boolean invert, float x, float baseX, float y, float baseY, float z, float baseZ, float speed, float offset, float timer, float mod2) {
        part.f_104203_ += render.move(invert, x, baseX * -1.0f, speed, offset, timer, mod2);
        part.f_104204_ += render.move(invert, y, baseY * -1.0f, speed, offset, timer, mod2);
        part.f_104205_ += render.move(invert, z, baseZ, speed, offset, timer, mod2);
    }

    public static void k(@NotNull ModelPart part, float x, float y, float z, float mod2) {
        part.f_104203_ += render.keyFrame(x * -1.0f, mod2);
        part.f_104204_ += render.keyFrame(y * -1.0f, mod2);
        part.f_104205_ += render.keyFrame(z, mod2);
    }

    public static void k(@NotNull ModelPart part, float x, float y, float z, float mod1, float mod2) {
        part.f_104203_ += render.keyFrame(x * -1.0f, mod1, mod2);
        part.f_104204_ += render.keyFrame(y * -1.0f, mod1, mod2);
        part.f_104205_ += render.keyFrame(z, mod1, mod2);
    }

    public static void r(@NotNull ModelPart part, float mod2) {
        mod2 = 1.0f - mod2;
        part.f_104203_ *= mod2;
        part.f_104204_ *= mod2;
        part.f_104205_ *= mod2;
    }

    public static float translate(float value, float target, float speed) {
        return value + (target - value) * speed;
    }

    public static float convert(float value) {
        return value * ((float)Math.PI / 180);
    }

    public static class render {
        public static void tick(Entity entity) {
            if (entity instanceof IHekateProvider) {
                IHekateProvider iProvider = (IHekateProvider)entity;
                HekateProvider provider = iProvider.getHekateProvider();
                float lastTime = provider.currentTime;
                provider.currentTime = (float)Util.m_137569_() / 1.0E9f;
                provider.deltaTime = provider.currentTime - lastTime;
            }
        }

        public static void prepare(ModelPart ... parts) {
            for (ModelPart part : parts) {
                part.m_171327_(0.0f, 0.0f, 0.0f);
            }
        }

        public static void animation(Entity entity, String animation, float timer, KeyFrame ... frames) {
            if (entity instanceof IHekateProvider) {
                IHekateProvider iProvider = (IHekateProvider)entity;
                HekateProvider provider = iProvider.getHekateProvider();
                int tick = provider.getTick(animation);
                int i = 0;
                for (KeyFrame frame : frames) {
                    boolean active;
                    float mod2 = provider.getModifier(animation + ++i);
                    boolean bl = active = tick > 0 && tick > frame.TICK_END && tick <= frame.TICK_START;
                    if (!Minecraft.m_91087_().m_91104_()) {
                        mod2 += active ? (1.0f - mod2) * Math.min(1.0f, frame.SPEED_IN * provider.deltaTime) : (0.0f - mod2) * Math.min(1.0f, frame.SPEED_OUT * provider.deltaTime);
                    }
                    provider.getModifiers().put(animation + i, Float.valueOf(mod2));
                    for (AnimatedPart part : frame.PARTS) {
                        HekateLib.r(part.PART, mod2);
                        if (part.SWING) {
                            HekateLib.i(part.PART, part.X, part.XBase, part.Y, part.YBase, part.Z, part.ZBase, part.SPEED, part.OFFSET, timer, mod2);
                            continue;
                        }
                        HekateLib.k(part.PART, part.X, part.Y, part.Z, mod2);
                    }
                }
            }
        }

        public static float idle(float deg1, float deg2, float speed, float offset, float timer) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (deg1 *= (float)Math.PI / 180) * Mth.m_14089_((float)(timer * speed + offset * 6.283f)) + (deg2 *= (float)Math.PI / 180);
        }

        public static float idle(float deg1, float deg2, float speed, float offset, float timer, float mod1) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return mod1 <= 0.0f ? 0.0f : render.idle(deg1, deg2, speed, offset, timer) * mod1;
        }

        public static float idle(float deg1, float deg2, float speed, float offset, float timer, float mod1, float mod2) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (mod2 = 1.0f - mod2) <= 0.0f ? 0.0f : render.idle(deg1, deg2, speed, offset, timer, mod1) * mod2;
        }

        public static float move(float deg1, float deg2, float speed, float offset, float timer, float mod1) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (mod1 * (deg1 *= (float)Math.PI / 180) * Mth.m_14089_((float)(timer * speed + offset * 6.283f)) + (deg2 *= (float)Math.PI / 180)) * mod1;
        }

        public static float move(float deg1, float deg2, float speed, float offset, float timer, float mod1, float mod2) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            return (mod2 = 1.0f - mod2) <= 0.0f ? 0.0f : render.move(deg1, deg2, speed, offset, timer, mod1) * mod2;
        }

        public static float move(boolean invert, float deg1, float deg2, float speed, float offset, float timer, float mod1) {
            if (deg1 == 0.0f && deg2 == 0.0f) {
                return 0.0f;
            }
            float result = mod1 * (deg1 *= (float)Math.PI / 180) * Mth.m_14089_((float)(timer * speed + offset * 6.283f));
            return ((!invert && result < 0.0f ? -result : (invert && result > 0.0f ? -result : result)) + (deg2 *= (float)Math.PI / 180)) * mod1;
        }

        public static float spawn(float p, float mod2, float deg) {
            return p * mod2 + (deg *= (float)Math.PI / 180) * (1.0f - mod2);
        }

        public static float headYaw(float yaw, float mod2) {
            return yaw / 57.295776f * mod2;
        }

        public static float spin(float timer, float speed, float mod2) {
            return timer * speed % 6.282f * mod2;
        }

        public static float keyFrame(float deg, float mod2) {
            if (deg == 0.0f) {
                return 0.0f;
            }
            return (deg *= (float)Math.PI / 180) * mod2;
        }

        public static float keyFrame(float deg, float mod1, float mod2) {
            if (deg == 0.0f) {
                return 0.0f;
            }
            mod2 = Math.max(mod2, 0.0f);
            mod2 = Math.min(mod2, 1.0f);
            return (deg *= (float)Math.PI / 180) * mod1 * mod2;
        }
    }

    public static class effect {
        public static float cyclicPause(float f1, float f2, float f3) {
            return 0.5f + Mth.m_14089_((float)(f1 * f2 + f3 * 6.283f)) * 0.5f;
        }
    }

    public static class mod {
        public static float idle(float f1, float f2) {
            return Math.max(1.0f - f1 * f2, 0.0f);
        }

        public static float move(float f1, float f2) {
            return Math.min(f1 * f2, 1.0f);
        }

        public static float get(Entity entity, String animation, float speedIn, float speedOut) {
            if (entity instanceof IHekateProvider) {
                IHekateProvider iProvider = (IHekateProvider)entity;
                HekateProvider provider = iProvider.getHekateProvider();
                int tick = provider.getTick(animation);
                float mod2 = provider.getModifier(animation);
                if (!Minecraft.m_91087_().m_91104_()) {
                    mod2 += tick > 0 ? (1.0f - mod2) * Math.min(1.0f, speedIn * provider.deltaTime) : (0.0f - mod2) * Math.min(1.0f, speedOut * provider.deltaTime);
                }
                provider.getModifiers().put(animation, Float.valueOf(mod2));
                return mod2;
            }
            return 0.0f;
        }

        public static float scale(Entity entity) {
            float scale = entity.getPersistentData().m_128457_("HScale");
            float scaleLerp = entity.getPersistentData().m_128457_("HScaleLerp");
            return Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)scaleLerp, (float)scale);
        }
    }

    public static class network {
        public static boolean readPacket(int id, CompoundTag animations) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(id);
            if (entity instanceof IHekateProvider) {
                IHekateProvider provider = (IHekateProvider)entity;
                provider.getHekateProvider().getAnimations().clear();
                for (String animation : animations.m_128431_()) {
                    provider.getHekateProvider().getAnimations().add(new HekateAnimation(animation, animations.m_128451_(animation)));
                }
            }
            return true;
        }
    }
}

