/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.animations;

import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.animations.HekateAnimation;
import com.obscuria.obscureapi.network.AnimationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public class HekateProvider {
    private final Entity entity;
    private final List<HekateAnimation> animations = new ArrayList<HekateAnimation>();
    private final HashMap<String, Float> modifiers = new HashMap();
    public float currentTime = 0.0f;
    public float deltaTime = 0.0f;

    public HekateProvider(Entity entity) {
        this.entity = entity;
    }

    public List<HekateAnimation> getAnimations() {
        return this.animations;
    }

    public HashMap<String, Float> getModifiers() {
        return this.modifiers;
    }

    public float getModifier(String name) {
        return this.modifiers.containsKey(name) ? this.modifiers.get(name).floatValue() : 0.0f;
    }

    public void play(String animation, int ticks) {
        if (this.entity.m_183503_().m_5776_()) {
            return;
        }
        this.prepare(animation);
        this.animations.add(new HekateAnimation(animation, ticks));
        this.sendPacket(this.entity);
    }

    public void stop(Entity entity, String animation) {
        if (entity.m_183503_().m_5776_()) {
            return;
        }
        ArrayList<HekateAnimation> list = new ArrayList<HekateAnimation>(this.animations);
        for (HekateAnimation anim : list) {
            if (!anim.name.equals(animation)) continue;
            this.animations.remove(anim);
        }
        this.sendPacket(entity);
    }

    public boolean isPlaying(String animation) {
        for (HekateAnimation anim : this.animations) {
            if (!anim.name.equals(animation)) continue;
            return true;
        }
        return false;
    }

    public int getTick(String animation) {
        for (HekateAnimation anim : this.animations) {
            if (!anim.name.equals(animation)) continue;
            return anim.ticks;
        }
        return 0;
    }

    public void playSound(String animation, int tick, String sound, SoundSource source, float volume, float pitch) {
        if (this.entity.m_183503_().m_5776_() && this.isPlaying(animation) && this.getTick(animation) == tick - 1) {
            this.entity.m_183503_().m_7785_(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), new SoundEvent(new ResourceLocation(sound)), source, volume, pitch, false);
        }
    }

    private void prepare(String animation) {
        ArrayList<HekateAnimation> list = new ArrayList<HekateAnimation>(this.animations);
        for (HekateAnimation anim : list) {
            if (!anim.name.equals(animation)) continue;
            this.animations.remove(anim);
        }
    }

    private void sendPacket(Entity entity) {
        ObscureAPI.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new AnimationMessage(this.packAnimations(), entity.m_142049_()));
    }

    private CompoundTag packAnimations() {
        CompoundTag packet = new CompoundTag();
        for (HekateAnimation animation : this.animations) {
            packet.m_128405_(animation.name, animation.ticks);
        }
        return packet;
    }
}

