/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.classes;

import com.google.common.collect.Multimap;
import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.ObscureAPIConfig;
import com.obscuria.obscureapi.classes.IAbilityItem;
import com.obscuria.obscureapi.classes.IBonusItem;
import com.obscuria.obscureapi.classes.IClassItem;
import com.obscuria.obscureapi.classes.ObscureAbility;
import com.obscuria.obscureapi.classes.ObscureBonus;
import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import com.obscuria.obscureapi.utils.ItemHelper;
import com.obscuria.obscureapi.utils.TextHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TooltipHandler {
    @SubscribeEvent
    public static void initClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(TooltipHandler::modifyTooltips);
        Lore.add("obscure_api:vial_of_knowledge", "vial_of_knowledge");
    }

    private static void modifyTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List list = event.getToolTip();
        Player player = event.getPlayer();
        Modules.fixAttributes(stack, list);
        Modules.perks(stack, list);
        Modules.abilities(player, stack, list);
        Modules.knowledge(player, stack, list);
        Modules.lore(stack, list);
        Modules.itemClass(stack, list);
        Modules.icons(stack, list);
    }

    public static String applyIcons(String text) {
        return text.replace("[i]", "\u00a7f" + new TranslatableComponent("icon.info").getString()).replace("[u]", "\u00a7f" + new TranslatableComponent("icon.rmb").getString()).replace("[b]", "\u00a7f" + new TranslatableComponent("icon.boss").getString()).replace("[h1]", "\u00a7f" + new TranslatableComponent("icon.heart_1").getString()).replace("[h2]", "\u00a7f" + new TranslatableComponent("icon.heart_2").getString()).replace("[h3]", "\u00a7f" + new TranslatableComponent("icon.heart_3").getString());
    }

    public static class Lore {
        private static final HashMap<ResourceLocation, String> LORE = new HashMap();

        public static void add(String id, String lore) {
            LORE.put(new ResourceLocation(id), lore);
        }

        public static boolean contains(ItemStack stack) {
            return LORE.containsKey(stack.m_41720_().getRegistryName());
        }

        public static String get(ItemStack stack) {
            return LORE.get(stack.m_41720_().getRegistryName());
        }
    }

    public static class Modules {
        public static void fixAttributes(ItemStack stack, List<Component> list) {
            if (stack.m_41782_()) {
                Modules.replaceAttribute(stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_), "damage", "attribute.name.generic.attack_damage", list);
                Modules.replaceAttribute(stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_), "attack_speed", "attribute.name.generic.attack_speed", list);
            }
        }

        public static void perks(ItemStack stack, List<Component> list) {
            if (ItemHelper.hasPerks(stack)) {
                for (String perk : ItemHelper.getOrCreatePerks(stack).m_128431_()) {
                    list.add(1, (Component)new TranslatableComponent("perk." + perk + ".name").m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("obscure_api", new TranslatableComponent("perk." + perk + ".style").getString()))));
                }
            }
        }

        public static void abilities(Player player, ItemStack stack, List<Component> list) {
            if (player != null && stack.m_41720_() instanceof IAbilityItem || stack.m_41720_() instanceof IBonusItem || ItemHelper.hasPerks(stack)) {
                if (stack.m_41793_() || ItemHelper.hasPerks(stack)) {
                    list.add(1, (Component)new TextComponent(""));
                }
                if (Screen.m_96638_()) {
                    Object item;
                    Item item2;
                    if (ItemHelper.hasPerks(stack)) {
                        Modules.extendPerks(stack, list);
                    }
                    if ((item2 = stack.m_41720_()) instanceof IAbilityItem) {
                        item = (IAbilityItem)item2;
                        Modules.extendAbilities((IAbilityItem)item, player, list);
                    }
                    if ((item2 = stack.m_41720_()) instanceof IBonusItem) {
                        item = (IBonusItem)item2;
                        Modules.extendBonuses((IBonusItem)item, list);
                    }
                    list.add(1, TextHelper.component(new TranslatableComponent("tooltip.collapse").getString()));
                } else {
                    list.add(1, TextHelper.component(new TranslatableComponent("tooltip.expand").getString()));
                }
            }
        }

        public static void knowledge(Player player, ItemStack stack, List<Component> list) {
            if (player != null && player.m_21023_((MobEffect)ObscureAPIMobEffects.KNOWLEDGE.get()) && Knowledge.contains(stack)) {
                String text = TooltipHandler.applyIcons(new TranslatableComponent("tooltip.knowledge." + Knowledge.get(stack)).getString());
                StringTokenizer token = new StringTokenizer(text, ">");
                ArrayList<String> lines = new ArrayList<String>();
                while (token.hasMoreTokens()) {
                    lines.add(0, token.nextToken());
                }
                while (!lines.isEmpty()) {
                    list.add(1, TextHelper.component("\u00a79 " + (String)lines.get(0)));
                    lines.remove(0);
                }
                list.add(1, TextHelper.component("\u00a79" + new TranslatableComponent("tooltip.knowledge").getString()));
            }
        }

        public static void lore(ItemStack stack, List<Component> list) {
            if (Lore.contains(stack)) {
                String text = TooltipHandler.applyIcons(new TranslatableComponent("tooltip.lore." + Lore.get(stack)).getString());
                StringTokenizer token = new StringTokenizer(text, ">");
                ArrayList<String> lines = new ArrayList<String>();
                while (token.hasMoreTokens()) {
                    lines.add(0, token.nextToken());
                }
                while (!lines.isEmpty()) {
                    list.add(1, TextHelper.component("\u00a77" + (String)lines.get(0)));
                    lines.remove(0);
                }
            }
        }

        public static void itemClass(ItemStack stack, List<Component> list) {
            Item item = stack.m_41720_();
            if (item instanceof IClassItem) {
                IClassItem item2 = (IClassItem)item;
                if (!ObscureAPI.COLLECTION.containsKey("obscure_tooltips")) {
                    list.add(1, TextHelper.component(new TranslatableComponent("icon.star").getString() + "\u00a76" + item2.getObscureClass().getLabel(item2.getObscureType())));
                }
            }
        }

        public static void icons(ItemStack stack, List<Component> list) {
            if (((Boolean)ObscureAPIConfig.Client.foodIcons.get()).booleanValue() && stack.m_41720_().m_41472_()) {
                Icons.putFoodIcons(list, stack);
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:obscuria/icons/custom")))) {
                Icons.putCustomIcons(list, stack);
            } else if (((Boolean)ObscureAPIConfig.Client.equipmentIcons.get()).booleanValue() && (stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof ArmorItem)) {
                Icons.putIcons(list, stack);
            }
        }

        private static void extendPerks(ItemStack stack, List<Component> list) {
            for (String perk : ItemHelper.getOrCreatePerks(stack).m_128431_()) {
                String text = new TranslatableComponent("perk." + perk + ".text").getString();
                StringTokenizer token = new StringTokenizer(text, ">");
                ArrayList<String> lines = new ArrayList<String>();
                while (token.hasMoreTokens()) {
                    lines.add(0, token.nextToken());
                }
                while (!lines.isEmpty()) {
                    if (lines.size() == 1) {
                        list.add(1, (Component)new TextComponent(new TranslatableComponent("icon.stick").getString() + (String)lines.get(0)).m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("obscure_api", new TranslatableComponent("perk." + perk + ".style").getString()))));
                    } else {
                        list.add(1, TextHelper.component(new TranslatableComponent("icon.stick").getString() + " \u00a77" + (String)lines.get(0)));
                    }
                    lines.remove(0);
                }
            }
        }

        private static void extendAbilities(IAbilityItem item, Player player, List<Component> list) {
            for (ObscureAbility ability : item.getObscureAbilities()) {
                String text = TooltipHandler.applyIcons(new TranslatableComponent("ability." + ability.TEXT).getString().replace("#1", ability.getAmountString((Entity)player, 0)).replace("#2", ability.getAmountString((Entity)player, 1)).replace("#3", ability.getAmountString((Entity)player, 2)));
                ArrayList<Object> lines = new ArrayList<Object>();
                for (String line : text.split(">")) {
                    lines.add(0, line);
                }
                while (!lines.isEmpty()) {
                    if (lines.size() == 1) {
                        lines.set(0, (String)lines.get(0) + ability.getCostString((Entity)player));
                        list.add(1, TextHelper.component(new TranslatableComponent("icon.stick").getString() + (String)lines.get(0)));
                    } else {
                        list.add(1, TextHelper.component(new TranslatableComponent("icon.stick").getString() + " \u00a77" + (String)lines.get(0)));
                    }
                    lines.remove(0);
                }
            }
        }

        private static void extendBonuses(IBonusItem item, List<Component> list) {
            for (ObscureBonus bonus : item.getObscureBonuses()) {
                String text = bonus.getBonusString();
                StringTokenizer token = new StringTokenizer(text, ">");
                ArrayList<String> lines = new ArrayList<String>();
                while (token.hasMoreTokens()) {
                    lines.add(0, token.nextToken());
                }
                while (!lines.isEmpty()) {
                    list.add(1, TextHelper.component(new TranslatableComponent("icon.stick").getString() + " \u00a77" + (String)lines.get(0)));
                    lines.remove(0);
                }
            }
            list.add(1, TextHelper.component(new TranslatableComponent("icon.stick").getString() + new TranslatableComponent("ability.bonuses").getString()));
        }

        /*
         * Unable to fully structure code
         */
        private static void replaceAttribute(Collection<AttributeModifier> map, String type, String loc, List<Component> list) {
            mod = 0.0;
            var6 = map.iterator();
            block8: while (true) {
                if (!var6.hasNext()) {
                    var6 = map.iterator();
                    block9: while (true) {
                        if (!var6.hasNext()) {
                            return;
                        }
                        attr = var6.next();
                        if (attr.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                        i = 1;
                        while (true) {
                            if (i < list.size()) ** break;
                            continue block9;
                            var13_12 = type;
                            var14_14 = -1;
                            switch (var13_12.hashCode()) {
                                case -1339126929: {
                                    if (!var13_12.equals("damage")) break;
                                    var14_14 = 0;
                                    break;
                                }
                                case 840596368: {
                                    if (!var13_12.equals("attack_speed")) break;
                                    var14_14 = 1;
                                }
                            }
                            switch (var14_14) {
                                case 0: {
                                    v0 = new DecimalFormat("##.#").format(1.0 + attr.m_22218_() + attr.m_22218_() * mod).replace(".0", "");
                                    break;
                                }
                                case 1: {
                                    v0 = new DecimalFormat("##.#").format(4.0 + attr.m_22218_() + attr.m_22218_() * mod).replace(".0", "");
                                    break;
                                }
                                default: {
                                    v0 = "0";
                                }
                            }
                            var14 = v0;
                            amount = var14;
                            str1 = list.get(i).getString();
                            var10000 = attr.m_22218_() < 0.0 ? Integer.valueOf((int)attr.m_22218_()) : "+" + (int)attr.m_22218_();
                            str2 = var10000 + " " + new TranslatableComponent(loc).getString();
                            var14 = attr.m_22218_() < 0.0 ? new DecimalFormat("##.#").format(attr.m_22218_()) : "+" + new DecimalFormat("##.#").format(attr.m_22218_());
                            str3 = (String)var14 + " " + new TranslatableComponent(loc).getString();
                            if (str1.equals(str2)) {
                                list.set(i, (Component)new TextComponent("\u00a72 " + amount + " " + new TranslatableComponent(loc).getString() + (String)(mod > 0.0 ? "\u00a78 +" + (int)(mod * 100.0) + "%" : "")));
                            } else if (str1.equals(str3)) {
                                list.set(i, (Component)new TextComponent("\u00a72 " + amount + " " + new TranslatableComponent(loc).getString() + (String)(mod > 0.0 ? "\u00a78 +" + (int)(mod * 100.0) + "%" : "")));
                            }
                            ++i;
                        }
                        break;
                    }
                }
                attr = var6.next();
                if (attr.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                mod += attr.m_22218_();
                i = 1;
                while (true) {
                    if (i < list.size()) ** break;
                    continue block8;
                    amount = list.get(i).getString();
                    if (amount.equals(str1 = (var10000 = attr.m_22218_() < 0.0 ? Integer.valueOf((int)(attr.m_22218_() * 100.0)) : "+" + (int)(attr.m_22218_() * 100.0)) + "% " + new TranslatableComponent(loc).getString())) {
                        list.remove(i);
                        --i;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private static class Icons {
        private Icons() {
        }

        private static void putIcons(List<Component> list, ItemStack stack) {
            Object icons = "";
            Multimap mainhandMap = stack.m_41638_(EquipmentSlot.MAINHAND);
            Multimap headMap = stack.m_41638_(EquipmentSlot.HEAD);
            Multimap chestMap = stack.m_41638_(EquipmentSlot.CHEST);
            Multimap legsMap = stack.m_41638_(EquipmentSlot.LEGS);
            Multimap feetMap = stack.m_41638_(EquipmentSlot.FEET);
            if (!mainhandMap.isEmpty()) {
                icons = (String)icons + Icons.getIcon(false, "icon.damage", 1.0, mainhandMap.get((Object)Attributes.f_22281_)) + Icons.getAttackSpeedIcon(mainhandMap.get((Object)Attributes.f_22283_));
            }
            if (!headMap.isEmpty()) {
                icons = (String)icons + Icons.getIcon(false, "icon.armor", 0.0, headMap.get((Object)Attributes.f_22284_)) + Icons.getIcon(false, "icon.armor_toughness", 0.0, headMap.get((Object)Attributes.f_22285_)) + Icons.getIcon(true, "icon.knockback_resistance", 0.0, headMap.get((Object)Attributes.f_22278_));
            }
            if (!chestMap.isEmpty()) {
                icons = (String)icons + Icons.getIcon(false, "icon.armor", 0.0, chestMap.get((Object)Attributes.f_22284_)) + Icons.getIcon(false, "icon.armor_toughness", 0.0, chestMap.get((Object)Attributes.f_22285_)) + Icons.getIcon(true, "icon.knockback_resistance", 0.0, chestMap.get((Object)Attributes.f_22278_));
            }
            if (!legsMap.isEmpty()) {
                icons = (String)icons + Icons.getIcon(false, "icon.armor", 0.0, legsMap.get((Object)Attributes.f_22284_)) + Icons.getIcon(false, "icon.armor_toughness", 0.0, legsMap.get((Object)Attributes.f_22285_)) + Icons.getIcon(true, "icon.knockback_resistance", 0.0, legsMap.get((Object)Attributes.f_22278_));
            }
            if (!feetMap.isEmpty()) {
                icons = (String)icons + Icons.getIcon(false, "icon.armor", 0.0, feetMap.get((Object)Attributes.f_22284_)) + Icons.getIcon(false, "icon.armor_toughness", 0.0, feetMap.get((Object)Attributes.f_22285_)) + Icons.getIcon(true, "icon.knockback_resistance", 0.0, feetMap.get((Object)Attributes.f_22278_));
            }
            icons = (String)icons + Icons.getDurabilityIcon(stack);
            list.add(1, TextHelper.component((String)icons));
        }

        private static void putCustomIcons(List<Component> list, ItemStack stack) {
            Object icons = "";
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:obscuria/icons/souls")))) {
                String text = new TranslatableComponent("icon.soul." + Objects.requireNonNull(stack.m_41720_().getRegistryName()).m_135815_()).getString();
                icons = (String)icons + (String)(text.equals("icon.soul." + stack.m_41720_().getRegistryName().m_135815_()) ? "" : text + " ") + new TranslatableComponent("icon.soul").getString() + (stack.m_41776_() - stack.m_41773_()) + "\u00a78/" + stack.m_41776_() + "\u00a7f ";
            }
            list.add(1, TextHelper.component((String)icons));
        }

        private static String getIcon(boolean percent, String icon, double base, Collection<AttributeModifier> modifier) {
            if (modifier != null && !modifier.isEmpty()) {
                double modAmount = 0.0;
                double modPercent = 0.0;
                for (AttributeModifier attribute : modifier) {
                    if (attribute.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        modAmount += attribute.m_22218_();
                        continue;
                    }
                    if (attribute.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                    modPercent += attribute.m_22218_();
                }
                if ((modAmount += base + modAmount * modPercent) == 0.0) {
                    return "";
                }
                if (percent) {
                    return new TranslatableComponent(icon).getString() + (modPercent > 0.0 ? "\u00a72" : "") + new DecimalFormat("##.#").format(modAmount * 100.0).replace(".0", "") + "% ";
                }
                return new TranslatableComponent(icon).getString() + (modPercent > 0.0 ? "\u00a72" : "") + new DecimalFormat("##.#").format(modAmount).replace(".0", "") + " ";
            }
            return "";
        }

        private static String getAttackSpeedIcon(Collection<AttributeModifier> modifier) {
            if (modifier != null && !modifier.isEmpty()) {
                String icon;
                double modAmount = 0.0;
                double modPercent = 0.0;
                for (AttributeModifier attribute : modifier) {
                    if (attribute.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        modAmount += attribute.m_22218_();
                        continue;
                    }
                    if (attribute.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                    modPercent += attribute.m_22218_();
                }
                if ((modAmount += 4.0 + modAmount * modPercent) <= 0.6) {
                    icon = new TranslatableComponent("icon.attack_speed").getString();
                    return icon + new TranslatableComponent("icon.attack_speed.very_slow").getString() + " ";
                }
                if (modAmount <= 1.0) {
                    icon = new TranslatableComponent("icon.attack_speed").getString();
                    return icon + new TranslatableComponent("icon.attack_speed.slow").getString() + " ";
                }
                if (modAmount <= 2.0) {
                    icon = new TranslatableComponent("icon.attack_speed").getString();
                    return icon + new TranslatableComponent("icon.attack_speed.medium").getString() + " ";
                }
                if (modAmount <= 3.0) {
                    icon = new TranslatableComponent("icon.attack_speed").getString();
                    return icon + new TranslatableComponent("icon.attack_speed.fast").getString() + " ";
                }
                icon = new TranslatableComponent("icon.attack_speed").getString();
                return icon + new TranslatableComponent("icon.attack_speed.very_fast").getString() + " ";
            }
            return "";
        }

        private static String getDurabilityIcon(ItemStack stack) {
            if (stack.m_41776_() > 0) {
                String icon = new TranslatableComponent("icon.durability").getString();
                return icon + (stack.m_41776_() - stack.m_41773_()) + "\u00a78/" + stack.m_41776_() + "\u00a7f ";
            }
            return "";
        }

        private static void putFoodIcons(List<Component> list, ItemStack stack) {
            Object icons = "";
            if (Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38744_() > 0) {
                icons = (String)icons + new TranslatableComponent("icon.food").getString() + Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38744_() + " ";
            }
            if (Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38745_() > 0.0f) {
                icons = (String)icons + new TranslatableComponent("icon.food_saturation").getString() + (int)(Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38745_() * 100.0f) + "% ";
            }
            if (!((String)icons).equals("")) {
                list.add(1, TextHelper.component((String)icons));
            }
        }
    }

    public static class Knowledge {
        private static final HashMap<ResourceLocation, String> KNOWLEDGE = new HashMap();

        public static void add(String id, String lore) {
            KNOWLEDGE.put(new ResourceLocation(id), lore);
        }

        public static boolean contains(ItemStack stack) {
            return KNOWLEDGE.containsKey(stack.m_41720_().getRegistryName());
        }

        public static String get(ItemStack stack) {
            return KNOWLEDGE.get(stack.m_41720_().getRegistryName());
        }
    }
}

