/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.library.world.entities;

import com.obscuria.obscureapi.animations.HekateLib;
import com.obscuria.obscureapi.registry.ObscureAPIEnchantments;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChakraEntity
extends Mob {
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_SPEED = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> SUMMONER_UUID = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<ItemStack> RELATED_STACK = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> UNRELATED = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPIN = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> USES = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(ChakraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public Entity SUMMONER = null;

    public ChakraEntity(EntityType<? extends ChakraEntity> type, Level world) {
        super(type, world);
        this.m_21557_(true);
        this.m_21530_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public boolean m_6783_(double d0) {
        double d1 = 100.0;
        return d0 < 10000.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(SCALE_SPEED, (Object)Float.valueOf(0.3f));
        this.m_20088_().m_135372_(SUMMONER_UUID, (Object)UUID.randomUUID().toString());
        this.m_20088_().m_135372_(RELATED_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(UNRELATED, (Object)false);
        this.m_20088_().m_135372_(SPIN, (Object)0);
        this.m_20088_().m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(LIFETIME, (Object)0);
        this.m_20088_().m_135372_(USES, (Object)0);
        this.m_20088_().m_135372_(DAMAGE, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag data = new CompoundTag();
        data.m_128350_("Scale", ((Float)this.m_20088_().m_135370_(SCALE)).floatValue());
        data.m_128350_("ScaleSpeed", ((Float)this.m_20088_().m_135370_(SCALE_SPEED)).floatValue());
        data.m_128359_("Summoner", (String)this.m_20088_().m_135370_(SUMMONER_UUID));
        data.m_128365_("ItemStack", (Tag)((ItemStack)this.m_20088_().m_135370_(RELATED_STACK)).m_41739_(new CompoundTag()));
        data.m_128379_("Unrelated", ((Boolean)this.m_20088_().m_135370_(UNRELATED)).booleanValue());
        data.m_128405_("Spin", ((Integer)this.m_20088_().m_135370_(SPIN)).intValue());
        data.m_128350_("Offset", ((Float)this.m_20088_().m_135370_(OFFSET)).floatValue());
        data.m_128405_("LifeTime", ((Integer)this.m_20088_().m_135370_(LIFETIME)).intValue());
        data.m_128405_("Uses", ((Integer)this.m_20088_().m_135370_(USES)).intValue());
        data.m_128405_("Damage", ((Integer)this.m_20088_().m_135370_(DAMAGE)).intValue());
        tag.m_128365_("ChakraData", (Tag)data);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag data = (CompoundTag)tag.m_128423_("ChakraData");
        if (data == null) {
            return;
        }
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(data.m_128457_("Scale")));
        this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(data.m_128457_("ScaleSpeed")));
        this.m_20088_().m_135381_(SUMMONER_UUID, (Object)data.m_128461_("Summoner"));
        this.m_20088_().m_135381_(RELATED_STACK, (Object)ItemStack.m_41712_((CompoundTag)data.m_128469_("ItemStack")));
        this.m_20088_().m_135381_(UNRELATED, (Object)data.m_128471_("Unrelated"));
        this.m_20088_().m_135381_(SPIN, (Object)data.m_128451_("Spin"));
        this.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(data.m_128457_("Offset")));
        this.m_20088_().m_135381_(LIFETIME, (Object)data.m_128451_("LifeTime"));
        this.m_20088_().m_135381_(USES, (Object)data.m_128451_("Uses"));
        this.m_20088_().m_135381_(DAMAGE, (Object)data.m_128451_("Damage"));
    }

    public void defineSummoner(LivingEntity entity, @Nullable ItemStack stack) {
        if (stack != null) {
            this.m_20088_().m_135381_(RELATED_STACK, (Object)stack);
        } else {
            this.m_20088_().m_135381_(UNRELATED, (Object)true);
        }
        this.m_20088_().m_135381_(SUMMONER_UUID, (Object)entity.m_142081_().toString());
        this.SUMMONER = entity;
    }

    public void m_6075_() {
        HekateLib.updateScale((Entity)this, ((Float)this.m_20088_().m_135370_(SCALE)).floatValue(), ((Float)this.m_20088_().m_135370_(SCALE_SPEED)).floatValue());
        Level level = this.m_183503_();
        if (level instanceof ServerLevel) {
            LivingEntity summoner;
            Entity entity;
            ServerLevel server = (ServerLevel)level;
            this.m_20088_().m_135381_(SPIN, (Object)((Integer)this.m_20088_().m_135370_(SPIN) + 1));
            this.m_20088_().m_135381_(LIFETIME, (Object)((Integer)this.m_20088_().m_135370_(LIFETIME) - 1));
            this.SUMMONER = server.m_8791_(UUID.fromString((String)this.m_20088_().m_135370_(SUMMONER_UUID)));
            if ((Integer)this.m_20088_().m_135370_(LIFETIME) == 8 || (entity = this.SUMMONER) instanceof LivingEntity && !(summoner = (LivingEntity)entity).m_6084_()) {
                this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(0.0f));
                this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(0.4f));
            }
            if (this.SUMMONER == null || (Integer)this.m_20088_().m_135370_(USES) <= 0 || (Integer)this.m_20088_().m_135370_(LIFETIME) <= 0) {
                this.m_146870_();
                return;
            }
            Vec3 center = new Vec3(this.SUMMONER.m_20185_(), this.SUMMONER.m_20186_() + (double)this.SUMMONER.m_20206_() * 0.33, this.SUMMONER.m_20189_());
            this.chakraMove(this.SUMMONER, center);
        }
        if (this.SUMMONER != null) {
            Vec3 center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            List<LivingEntity> list = this.f_19853_.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_((double)this.getAttackRange()), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
            for (LivingEntity entity : list) {
                if (entity == this.SUMMONER || !(entity.m_20318_(1.0f).m_82554_(center) <= (double)this.getAttackRange())) continue;
                this.chakraAttack(entity);
            }
        }
        super.m_6075_();
    }

    public void chakraAttack(LivingEntity entity) {
        if (entity.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)((LivingEntity)this.SUMMONER)), (float)((Integer)this.m_20088_().m_135370_(DAMAGE)).intValue())) {
            this.m_20088_().m_135381_(USES, (Object)((Integer)this.m_20088_().m_135370_(USES) - 1));
        }
    }

    public void chakraMove(Entity entity, Vec3 center) {
        float radius = this.getRadius(4.0f);
        float speed = this.getSpinSpeed(0.06f);
        float offset = this.getSpinOffset();
        Vec3 orbit = new Vec3(center.f_82479_ + Math.cos(speed + offset) * (double)radius, center.f_82480_, center.f_82481_ + Math.sin(speed + offset) * (double)radius);
        this.m_20219_(orbit);
    }

    public static void chakraSummon(LivingEntity summoner, EntityType<? extends ChakraEntity> type, Level world, @Nullable ItemStack stack, int damage, float offset, int lifetime, int maxUses) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            if (stack != null && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ObscureAPIEnchantments.MIRROR.get()), (ItemStack)stack) > 0) {
                Entity chakra1 = type.m_20615_((Level)server);
                Entity chakra2 = type.m_20615_((Level)server);
                if (chakra1 instanceof ChakraEntity) {
                    ChakraEntity _chakra1 = (ChakraEntity)chakra1;
                    if (chakra2 instanceof ChakraEntity) {
                        ChakraEntity _chakra2 = (ChakraEntity)chakra2;
                        _chakra1.defineSummoner(summoner, stack);
                        _chakra2.defineSummoner(summoner, stack);
                        _chakra1.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(offset));
                        _chakra2.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(offset + 0.5f));
                        _chakra1.m_20088_().m_135381_(LIFETIME, (Object)lifetime);
                        _chakra2.m_20088_().m_135381_(LIFETIME, (Object)lifetime);
                        _chakra1.m_20088_().m_135381_(USES, (Object)maxUses);
                        _chakra2.m_20088_().m_135381_(USES, (Object)maxUses);
                        _chakra1.m_20088_().m_135381_(DAMAGE, (Object)((int)Math.round((double)damage * 0.5)));
                        _chakra2.m_20088_().m_135381_(DAMAGE, (Object)((int)Math.round((double)damage * 0.5)));
                        _chakra1.m_7678_(summoner.m_20185_(), summoner.m_20186_() + (double)(summoner.m_20206_() / 2.0f), summoner.m_20189_(), 0.0f, 0.0f);
                        _chakra2.m_7678_(summoner.m_20185_(), summoner.m_20186_() + (double)(summoner.m_20206_() / 2.0f), summoner.m_20189_(), 0.0f, 0.0f);
                        _chakra1.m_6518_((ServerLevelAccessor)server, world.m_6436_(_chakra1.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                        _chakra2.m_6518_((ServerLevelAccessor)server, world.m_6436_(_chakra2.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                        world.m_7967_((Entity)_chakra1);
                        world.m_7967_((Entity)_chakra2);
                    }
                }
            } else {
                Entity chakra = type.m_20615_((Level)server);
                if (chakra instanceof ChakraEntity) {
                    ChakraEntity _chakra = (ChakraEntity)chakra;
                    _chakra.defineSummoner(summoner, stack);
                    _chakra.m_20088_().m_135381_(OFFSET, (Object)Float.valueOf(offset));
                    _chakra.m_20088_().m_135381_(LIFETIME, (Object)lifetime);
                    _chakra.m_20088_().m_135381_(USES, (Object)maxUses);
                    _chakra.m_20088_().m_135381_(DAMAGE, (Object)damage);
                    _chakra.m_7678_(summoner.m_20185_(), summoner.m_20186_() + (double)(summoner.m_20206_() / 2.0f), summoner.m_20189_(), 0.0f, 0.0f);
                    _chakra.m_6518_((ServerLevelAccessor)server, world.m_6436_(_chakra.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                    world.m_7967_((Entity)_chakra);
                }
            }
        }
    }

    public float getAttackRange() {
        return 2.0f;
    }

    public float getSpinSpeed(float speed) {
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(RELATED_STACK);
        if (stack.m_41619_()) {
            return (float)((Integer)this.m_20088_().m_135370_(SPIN)).intValue() * speed;
        }
        return (float)((Integer)this.m_20088_().m_135370_(SPIN)).intValue() * (speed * (1.0f + 0.25f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ObscureAPIEnchantments.FAST_SPIN.get()), (ItemStack)stack)));
    }

    public float getRadius(float radius) {
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(RELATED_STACK);
        if (stack.m_41619_()) {
            return radius;
        }
        return radius * (1.0f + 0.2f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ObscureAPIEnchantments.DISTANCE.get()), (ItemStack)stack));
    }

    public float getSpinOffset() {
        return 6.315f * ((Float)this.m_20088_().m_135370_(OFFSET)).floatValue();
    }

    public void m_8107_() {
        super.m_8107_();
    }

    protected void m_6138_() {
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source != DamageSource.f_19317_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_142535_(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 250.0);
        builder = builder.m_22268_(Attributes.f_22284_, 100.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.3);
        return builder;
    }
}

