/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.utils;

import com.obscuria.obscureapi.classes.IAbilityItem;
import com.obscuria.obscureapi.classes.IBonusItem;
import com.obscuria.obscureapi.classes.IClassItem;
import com.obscuria.obscureapi.classes.TooltipHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    public static void addLore(String id, String lore) {
        TooltipHandler.Lore.add(id, lore);
    }

    public static void addKnowledge(String id, String knowledge) {
        TooltipHandler.Knowledge.add(id, knowledge);
    }

    public static boolean hasClass(ItemStack stack) {
        return stack.m_41720_() instanceof IClassItem;
    }

    public static boolean hasBonus(ItemStack stack) {
        return stack.m_41720_() instanceof IBonusItem;
    }

    public static boolean hasAbility(ItemStack stack) {
        return stack.m_41720_() instanceof IAbilityItem;
    }

    @Nullable
    public static CompoundTag getData(ItemStack stack) {
        return stack.m_41783_() == null ? null : stack.m_41783_().m_128469_("ObscureData");
    }

    public static CompoundTag getOrCreateData(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("ObscureData")) {
            stack.m_41784_().m_128365_("ObscureData", (Tag)new CompoundTag());
        }
        return stack.m_41784_().m_128469_("ObscureData");
    }

    @Nullable
    public static CompoundTag getPerks(ItemStack stack) {
        CompoundTag data = ItemHelper.getData(stack);
        return data == null ? null : data.m_128469_("Perks");
    }

    public static CompoundTag getOrCreatePerks(ItemStack stack) {
        if (!ItemHelper.getOrCreateData(stack).m_128441_("Perks")) {
            ItemHelper.getOrCreateData(stack).m_128365_("Perks", (Tag)new CompoundTag());
        }
        return ItemHelper.getOrCreateData(stack).m_128469_("Perks");
    }

    public static boolean hasPerks(ItemStack stack) {
        CompoundTag perks = ItemHelper.getPerks(stack);
        return perks != null && !perks.m_128456_();
    }

    public static boolean hasPerk(ItemStack stack, String perk) {
        CompoundTag perks = ItemHelper.getPerks(stack);
        return perks != null && perks.m_128441_(perk);
    }

    public static void addPerk(ItemStack stack, String perk, int level) {
        ItemHelper.getOrCreatePerks(stack).m_128405_(perk, level);
    }

    public static void removePerk(ItemStack stack, String perk) {
        CompoundTag perks = ItemHelper.getPerks(stack);
        if (perks != null && perks.m_128441_(perk)) {
            perks.m_128473_(perk);
        }
    }
}

