/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscuretooltips;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.obscuria.obscureapi.classes.IClassItem;
import com.obscuria.obscuretooltips.ModConfig;
import com.obscuria.obscuretooltips.tooltips.Override;
import com.obscuria.obscuretooltips.tooltips.Style;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Resources
implements ResourceManagerReloadListener {
    public static final Resources INSTANCE = new Resources();
    public static final Style DEFAULT_STYLE = new Style("textures/common/back.png", "textures/common/border.png", "textures/common/decor.png");
    public static final Override NO_OVERRIDE = new Override(0, 0);
    private final HashMap<String, Style> STYLES = new HashMap();
    private final HashMap<Item, Override> OVERRIDES = new HashMap();
    private final HashMap<String, Style> RARITIES = new HashMap();
    private final HashMap<String, Style> MODS = new HashMap();

    private Resources() {
    }

    public void m_6213_(@NotNull ResourceManager resourceManager) {
        JsonObject object;
        JsonObject rootObject;
        InputStream inputStream;
        this.STYLES.clear();
        this.OVERRIDES.clear();
        this.RARITIES.clear();
        this.MODS.clear();
        try {
            for (Resource resource : resourceManager.m_213829_(new ResourceLocation("obscure_tooltips", "styles.json"))) {
                inputStream = resource.m_215507_();
                try {
                    rootObject = GsonHelper.m_13861_((Reader)new InputStreamReader(inputStream), (boolean)true);
                    for (Map.Entry entry : rootObject.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonObject() || !(object = ((JsonElement)entry.getValue()).getAsJsonObject()).has("background") || !object.has("border") || !object.has("decorations")) continue;
                        this.STYLES.put((String)entry.getKey(), new Style(object.get("background").getAsString(), object.get("border").getAsString(), object.get("decorations").getAsString()));
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : resourceManager.m_213829_(new ResourceLocation("obscure_tooltips", "items.json"))) {
                inputStream = resource.m_215507_();
                try {
                    rootObject = GsonHelper.m_13861_((Reader)new InputStreamReader(inputStream), (boolean)true);
                    for (Map.Entry entry : rootObject.entrySet()) {
                        if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation((String)entry.getKey())) || !((JsonElement)entry.getValue()).isJsonObject()) continue;
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)entry.getKey()));
                        JsonObject object2 = ((JsonElement)entry.getValue()).getAsJsonObject();
                        Override override = new Override(object2.has("xOffset") ? object2.get("xOffset").getAsInt() : 0, object2.has("yOffset") ? object2.get("yOffset").getAsInt() : 0);
                        if (object2.has("style")) {
                            override.setStyle(this.getStyle(object2.get("style").getAsString()));
                        }
                        if (object2.has("render")) {
                            override.setRender(object2.get("render").getAsString());
                        }
                        if (object2.has("type")) {
                            override.setType(object2.get("type").getAsString());
                        }
                        if (object2.has("scale")) {
                            override.setScale(object2.get("scale").getAsFloat());
                        }
                        this.OVERRIDES.put(item, override);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : resourceManager.m_213829_(new ResourceLocation("obscure_tooltips", "groups.json"))) {
                inputStream = resource.m_215507_();
                try {
                    rootObject = GsonHelper.m_13861_((Reader)new InputStreamReader(inputStream), (boolean)true);
                    for (Map.Entry entry : rootObject.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                        object = ((JsonElement)entry.getValue()).getAsJsonObject();
                        JsonObject overrides = object.getAsJsonObject("overrides");
                        JsonArray items = object.getAsJsonArray("items");
                        Override override = new Override(overrides.has("xOffset") ? overrides.get("xOffset").getAsInt() : 0, overrides.has("yOffset") ? overrides.get("yOffset").getAsInt() : 0);
                        if (overrides.has("style")) {
                            override.setStyle(this.getStyle(overrides.get("style").getAsString()));
                        }
                        if (overrides.has("render")) {
                            override.setRender(overrides.get("render").getAsString());
                        }
                        if (overrides.has("type")) {
                            override.setType(overrides.get("type").getAsString());
                        }
                        if (overrides.has("scale")) {
                            override.setScale(overrides.get("scale").getAsFloat());
                        }
                        for (JsonElement item : items) {
                            if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item.getAsString()))) continue;
                            this.OVERRIDES.put((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.getAsString())), override);
                        }
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : resourceManager.m_213829_(new ResourceLocation("obscure_tooltips", "definitions.json"))) {
                inputStream = resource.m_215507_();
                try {
                    rootObject = GsonHelper.m_13861_((Reader)new InputStreamReader(inputStream), (boolean)true);
                    if (rootObject.has("rarities") && rootObject.get("rarities").isJsonObject()) {
                        for (Map.Entry entry : rootObject.get("rarities").getAsJsonObject().entrySet()) {
                            this.RARITIES.put((String)entry.getKey(), this.getStyle(((JsonElement)entry.getValue()).getAsString()));
                            this.RARITIES.put(((String)entry.getKey()).toUpperCase(), this.getStyle(((JsonElement)entry.getValue()).getAsString()));
                        }
                    }
                    if (!rootObject.has("mods") || !rootObject.get("mods").isJsonObject()) continue;
                    for (Map.Entry entry : rootObject.get("mods").getAsJsonObject().entrySet()) {
                        this.MODS.put((String)entry.getKey(), this.getStyle(((JsonElement)entry.getValue()).getAsString()));
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Style getStyle(String key) {
        return this.STYLES.getOrDefault(key, DEFAULT_STYLE);
    }

    public Override getOverride(Item item) {
        return this.OVERRIDES.getOrDefault(item, NO_OVERRIDE);
    }

    public Style getStyle(ItemStack stack, Override override) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("TooltipStyle")) {
            return this.getStyle(stack.m_41783_().m_128461_("TooltipStyle"));
        }
        return override.hasStyle ? override.STYLE : this.MODS.getOrDefault(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())).toString(), this.RARITIES.getOrDefault(stack.m_41791_().name(), DEFAULT_STYLE));
    }

    public String getType(ItemStack stack, Override override) {
        Item item = stack.m_41720_();
        if (item instanceof IClassItem) {
            IClassItem classItem = (IClassItem)item;
            return Component.m_237115_((String)"icon.star").getString() + "\u00a76" + classItem.getObscureClass().getLabel(((IClassItem)item).getObscureType());
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("TooltipType")) {
            return stack.m_41783_().m_128461_("TooltipType");
        }
        String type = override.hasType ? override.TYPE : (item instanceof ArmorItem ? "armor" : (item instanceof ShieldItem ? "shield" : (item instanceof SwordItem ? "weapon" : (item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem ? "ranged_weapon" : (item instanceof TieredItem || item.getMaxDamage(stack) > 0 ? "tool" : (item.m_41472_() ? "food" : (item instanceof PotionItem ? "potion" : (item instanceof EnchantedBookItem ? "magic" : (item instanceof BlockItem ? "block" : (item instanceof ArrowItem ? "ammo" : "material"))))))))));
        return Component.m_237115_((String)("tooltip.item_type." + type)).getString();
    }

    public String getRender(ItemStack stack, Override override) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("TooltipRender")) {
            return stack.m_41783_().m_128461_("TooltipRender");
        }
        return override.hasRender ? override.RENDER : ((Boolean)ModConfig.Client.model.get() != false ? "model" : "flat");
    }

    public float getScale(ItemStack stack, Override override) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("TooltipScale")) {
            return stack.m_41783_().m_128457_("TooltipScale");
        }
        return override.hasScale ? override.SCALE : ((Double)ModConfig.Client.scale.get()).floatValue();
    }
}

