/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.attributes;

import com.obscuria.obscureapi.classes.ICombatTriggerItem;
import com.obscuria.obscureapi.registry.ObscureAPIAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;

public class AttributesHandler {
    public static void addAttributes(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            event.add(type, (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            event.add(type, (Attribute)ObscureAPIAttributes.CRITICAL_DAMAGE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.DODGE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.PARRY.get());
            event.add(type, (Attribute)ObscureAPIAttributes.ACCURACY.get());
            event.add(type, (Attribute)ObscureAPIAttributes.MAGIC_DAMAGE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.MAGIC_RESISTANCE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.PENETRATION.get());
            event.add(type, (Attribute)ObscureAPIAttributes.REGENERATION.get());
            event.add(type, (Attribute)ObscureAPIAttributes.HEALING_POWER.get());
            event.add(type, (Attribute)ObscureAPIAttributes.RESILIENCE.get());
        }
    }

    public static void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        float heal = ObscureAPIAttributes.getRegeneration((LivingEntity)player);
        if (heal <= 0.0f) {
            return;
        }
        int regen = player.getPersistentData().m_128451_("HPRegen");
        if (regen > 400) {
            player.getPersistentData().m_128405_("HPRegen", 0);
            player.m_5634_(heal);
        } else {
            player.getPersistentData().m_128405_("HPRegen", regen + 1);
        }
    }

    public static void onLivingHeal(@NotNull LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        float amount = event.getAmount();
        float modifier = ObscureAPIAttributes.getHealingPower(entity);
        event.setAmount(amount * modifier);
    }

    public static void onLivingAttack(@NotNull LivingAttackEvent event) {
        LivingEntity living;
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        LivingEntity source = entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null;
        float amount = event.getAmount();
        if (entity == null || source == null || entity.f_19802_ > 10) {
            return;
        }
        float accuracy = ObscureAPIAttributes.getAccuracy(source);
        float parry = ObscureAPIAttributes.getParry(entity);
        if (Math.random() <= (double)(parry - accuracy)) {
            event.setCanceled(true);
            entity.f_19802_ = 20;
            source.m_6469_(DamageSource.m_19370_((LivingEntity)entity), amount);
            return;
        }
        float dodge = ObscureAPIAttributes.getDodge(entity);
        if (Math.random() <= (double)(dodge - accuracy)) {
            event.setCanceled(true);
            entity.f_19802_ = 20;
        }
    }

    public static void onLivingHurt(@NotNull LivingHurtEvent event) {
        LivingEntity living;
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        LivingEntity source = entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null;
        float amount = event.getAmount();
        if (entity == null || source == null) {
            return;
        }
        ItemStack weapon = source.m_21205_();
        if (!event.getSource().m_19387_()) {
            double criticalHit = ObscureAPIAttributes.getCriticalHit(source);
            double criticalDamage = ObscureAPIAttributes.getCriticalDamage(source);
            double resilience = ObscureAPIAttributes.getResilience(entity);
            if (Math.random() <= criticalHit - resilience) {
                float criticalAmount = amount * (float)criticalDamage * (float)(1.0 - resilience);
                Item item = weapon.m_41720_();
                if (item instanceof ICombatTriggerItem) {
                    ICombatTriggerItem item2 = (ICombatTriggerItem)item;
                    item2.onObscureTrigger(weapon, "critical_hit", entity, source, criticalAmount);
                }
                event.setAmount(criticalAmount);
                System.out.println("Chance:" + criticalHit + " / Resilience:" + resilience + " / Amount: " + amount * (float)criticalDamage * (float)(1.0 - resilience));
            }
        }
        if (event.getSource().m_19387_()) {
            event.setAmount(amount * (1.0f - ObscureAPIAttributes.getMagicResistance(entity)));
        }
    }

    public static void onLivingDamage(@NotNull LivingDamageEvent event) {
        double magicDamage;
        LivingEntity living;
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        LivingEntity source = entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null;
        float amount = event.getAmount();
        if (entity == null || source == null) {
            return;
        }
        ItemStack weapon = source.m_21205_();
        CompoundTag tag = weapon.m_41784_();
        if (!entity.m_6673_(DamageSource.f_19319_) && (magicDamage = (double)(ObscureAPIAttributes.getMagicDamage(source) * (1.0f - ObscureAPIAttributes.getMagicResistance(entity)))) > 0.0) {
            event.setAmount(event.getAmount() + (float)magicDamage);
        }
    }
}

