/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.classes;

import com.obscuria.obscureapi.classes.IBonusItem;
import com.obscuria.obscureapi.classes.IClassItem;
import com.obscuria.obscureapi.classes.ObscureBonus;
import com.obscuria.obscureapi.classes.ObscureClass;
import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import com.obscuria.obscureapi.utils.TextHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;

public class ObscureAbility {
    public final Item ITEM;
    public final String TEXT;
    public final String COST_TYPE;
    public final int COST;
    public final int[] VALUES;

    public ObscureAbility(Item item, String text) {
        this(item, text, "none", 0);
    }

    public ObscureAbility(Item item, String text, String costType, int cost) {
        this(item, text, costType, cost, 0, 0, 0);
    }

    public ObscureAbility(Item item, String text, String costType, int cost, int i1) {
        this(item, text, costType, cost, i1, 0, 0);
    }

    public ObscureAbility(Item item, String text, String costType, int cost, int i1, int i2) {
        this(item, text, costType, cost, i1, i2, 0);
    }

    public ObscureAbility(Item item, String text, String costType, int cost, int i1, int i2, int i3) {
        this.ITEM = item;
        this.TEXT = text;
        this.COST_TYPE = costType;
        this.COST = cost;
        this.VALUES = new int[]{i1, i2, i3};
    }

    public int getCost(Entity entity) {
        Item item;
        LivingEntity living;
        if (this.COST_TYPE.equals("none")) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (this.COST_TYPE.equals("cooldown") && entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)ObscureAPIMobEffects.RUSH.get())) {
            mod2 += -10 - 10 * Objects.requireNonNull(living.m_21124_((MobEffect)ObscureAPIMobEffects.RUSH.get())).m_19564_();
        }
        if ((item = this.ITEM) instanceof IClassItem) {
            IClassItem classitem = (IClassItem)item;
            if (entity instanceof LivingEntity) {
                IBonusItem item2;
                List<ObscureBonus> list;
                List<ObscureBonus> list2;
                List<ObscureBonus> list3;
                List<ObscureBonus> list4;
                LivingEntity living2 = (LivingEntity)entity;
                ObscureClass itemclass = classitem.getObscureClass();
                String itemtype = classitem.getObscureType();
                Item item3 = living2.m_6844_(EquipmentSlot.HEAD).m_41720_();
                if (item3 instanceof IBonusItem) {
                    IBonusItem item4 = (IBonusItem)item3;
                    list4 = item4.getObscureBonuses();
                } else {
                    list4 = null;
                }
                List<ObscureBonus> ARMOR_HEAD = list4;
                Item item5 = living2.m_6844_(EquipmentSlot.CHEST).m_41720_();
                if (item5 instanceof IBonusItem) {
                    IBonusItem item6 = (IBonusItem)item5;
                    list3 = item6.getObscureBonuses();
                } else {
                    list3 = null;
                }
                List<ObscureBonus> ARMOR_CHEST = list3;
                Item item7 = living2.m_6844_(EquipmentSlot.LEGS).m_41720_();
                if (item7 instanceof IBonusItem) {
                    IBonusItem item8 = (IBonusItem)item7;
                    list2 = item8.getObscureBonuses();
                } else {
                    list2 = null;
                }
                List<ObscureBonus> ARMOR_LEGS = list2;
                Item item9 = living2.m_6844_(EquipmentSlot.FEET).m_41720_();
                if (item9 instanceof IBonusItem) {
                    IBonusItem item10 = (IBonusItem)item9;
                    list = item10.getObscureBonuses();
                } else {
                    list = null;
                }
                List<ObscureBonus> ARMOR_FEET = list;
                Item item11 = living2.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                List<ObscureBonus> HAND = item11 instanceof IBonusItem && !((item2 = (IBonusItem)item11) instanceof ArmorItem) ? item2.getObscureBonuses() : null;
                mod1 += this.getBonus(ARMOR_HEAD, itemclass, itemtype, this.COST_TYPE, "") + this.getBonus(ARMOR_CHEST, itemclass, itemtype, this.COST_TYPE, "") + this.getBonus(ARMOR_LEGS, itemclass, itemtype, this.COST_TYPE, "") + this.getBonus(ARMOR_FEET, itemclass, itemtype, this.COST_TYPE, "") + this.getBonus(HAND, itemclass, itemtype, this.COST_TYPE, "");
                mod2 += this.getBonus(ARMOR_HEAD, itemclass, itemtype, this.COST_TYPE, "%") + this.getBonus(ARMOR_CHEST, itemclass, itemtype, this.COST_TYPE, "%") + this.getBonus(ARMOR_LEGS, itemclass, itemtype, this.COST_TYPE, "%") + this.getBonus(ARMOR_FEET, itemclass, itemtype, this.COST_TYPE, "%") + this.getBonus(HAND, itemclass, itemtype, this.COST_TYPE, "%");
            }
        }
        mod2 = Math.max(mod2, -80);
        return (int)Math.max((double)Math.round((double)(this.COST + mod1) + (double)this.COST * ((double)mod2 / 100.0)), 1.0);
    }

    public int getAmount(Entity entity, int i) {
        Item item;
        LivingEntity living;
        int amount = this.VALUES[i];
        if (amount <= 0) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)ObscureAPIMobEffects.FURY.get())) {
            mod2 += 10 + 10 * Objects.requireNonNull(living.m_21124_((MobEffect)ObscureAPIMobEffects.FURY.get())).m_19564_();
        }
        if ((item = this.ITEM) instanceof IClassItem) {
            IClassItem classitem = (IClassItem)item;
            if (entity instanceof LivingEntity) {
                IBonusItem item2;
                List<ObscureBonus> list;
                List<ObscureBonus> list2;
                List<ObscureBonus> list3;
                List<ObscureBonus> list4;
                LivingEntity living2 = (LivingEntity)entity;
                ObscureClass itemclass = classitem.getObscureClass();
                String itemtype = classitem.getObscureType();
                Item item3 = living2.m_6844_(EquipmentSlot.HEAD).m_41720_();
                if (item3 instanceof IBonusItem) {
                    IBonusItem item4 = (IBonusItem)item3;
                    list4 = item4.getObscureBonuses();
                } else {
                    list4 = null;
                }
                List<ObscureBonus> ARMOR_HEAD = list4;
                Item item5 = living2.m_6844_(EquipmentSlot.CHEST).m_41720_();
                if (item5 instanceof IBonusItem) {
                    IBonusItem item6 = (IBonusItem)item5;
                    list3 = item6.getObscureBonuses();
                } else {
                    list3 = null;
                }
                List<ObscureBonus> ARMOR_CHEST = list3;
                Item item7 = living2.m_6844_(EquipmentSlot.LEGS).m_41720_();
                if (item7 instanceof IBonusItem) {
                    IBonusItem item8 = (IBonusItem)item7;
                    list2 = item8.getObscureBonuses();
                } else {
                    list2 = null;
                }
                List<ObscureBonus> ARMOR_LEGS = list2;
                Item item9 = living2.m_6844_(EquipmentSlot.FEET).m_41720_();
                if (item9 instanceof IBonusItem) {
                    IBonusItem item10 = (IBonusItem)item9;
                    list = item10.getObscureBonuses();
                } else {
                    list = null;
                }
                List<ObscureBonus> ARMOR_FEET = list;
                Item item11 = living2.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                List<ObscureBonus> HAND = item11 instanceof IBonusItem && !((item2 = (IBonusItem)item11) instanceof ArmorItem) ? item2.getObscureBonuses() : null;
                mod1 += this.getBonus(ARMOR_HEAD, itemclass, itemtype, "power", "") + this.getBonus(ARMOR_CHEST, itemclass, itemtype, "power", "") + this.getBonus(ARMOR_LEGS, itemclass, itemtype, "power", "") + this.getBonus(ARMOR_FEET, itemclass, itemtype, "power", "") + this.getBonus(HAND, itemclass, itemtype, "power", "");
                mod2 += this.getBonus(ARMOR_HEAD, itemclass, itemtype, "power", "%") + this.getBonus(ARMOR_CHEST, itemclass, itemtype, "power", "%") + this.getBonus(ARMOR_LEGS, itemclass, itemtype, "power", "%") + this.getBonus(ARMOR_FEET, itemclass, itemtype, "power", "%") + this.getBonus(HAND, itemclass, itemtype, "power", "%");
            }
        }
        return (int)Math.max((double)Math.round((double)(amount + mod1) + (double)amount * ((double)mod2 / 100.0)), 1.0);
    }

    public String getCostString(Entity entity) {
        int cost = this.COST;
        int modCost = this.getCost(entity);
        String costString = TextHelper.translation("ability.cost." + this.COST_TYPE);
        String costAmount = cost < modCost ? "\u00a7c" + modCost : (cost > modCost ? "\u00a72" + modCost : Integer.valueOf(modCost));
        costString = costString.replace("#", costAmount);
        return " " + costString + (String)(cost < modCost ? " \u00a78+" + Math.round(((double)modCost / 1.0 / (double)cost - 1.0) * 100.0) + "%" : (cost > modCost ? " \u00a78-" + Math.round((1.0 - (double)modCost / 1.0 / (double)cost) * 100.0) + "%" : ""));
    }

    public String getAmountString(Entity entity, int i) {
        int amount = this.VALUES[i];
        int modAmount = this.getAmount(entity, i);
        return "" + (Serializable)(amount < modAmount ? "\u00a72" + modAmount : (amount > modAmount ? "\u00a7c" + modAmount : Integer.valueOf(modAmount)));
    }

    private int getBonus(List<ObscureBonus> bonuses, ObscureClass itemclass, String itemtype, String bonus, String operation) {
        int mod2 = 0;
        if (bonuses != null && !bonuses.isEmpty()) {
            for (ObscureBonus entry : bonuses) {
                if (!entry.CLASS.isSameClass(itemclass) || !entry.TYPE.equals(itemtype) || !entry.BONUS.equals(bonus) || !entry.OPERATION.equals(operation)) continue;
                mod2 += entry.AMOUNT;
            }
        }
        return mod2;
    }
}

