/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.quiltmc.installer.action.Action;

public final class CliInstaller {
    public static final String INSTALLER_VERSION = "0.5.0";

    public static void run(String[] args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                builder.append(' ');
            }
            builder.append(args[i]);
        }
        Action<?> action = CliInstaller.parse(builder.toString());
        action.run(msg -> {
            if (action != Action.DISPLAY_HELP) {
                // empty if block
            }
        });
    }

    private static Action<?> parse(String input) {
        String arg;
        Queue<String> split = CliInstaller.splitQuoted(input);
        switch (arg = split.remove()) {
            case "help": {
                return Action.DISPLAY_HELP;
            }
            case "listVersions": {
                if (split.size() == 0) {
                    return Action.listVersions(false, false);
                }
                boolean minecraftSnapshots = false;
                boolean loaderBetas = false;
                boolean hasError = false;
                while (split.peek() != null) {
                    String option = split.remove();
                    if (option.equals("--snapshots")) {
                        minecraftSnapshots = true;
                        continue;
                    }
                    if (option.equals("--loader-betas")) {
                        loaderBetas = true;
                        continue;
                    }
                    if (option.startsWith("--")) {
                        System.err.printf("Invalid option \"%s\"%n", arg);
                        hasError = true;
                        continue;
                    }
                    System.err.printf("Unexpected additional argument \"%s\"%n", arg);
                    hasError = true;
                }
                return !hasError ? Action.listVersions(minecraftSnapshots, loaderBetas) : Action.DISPLAY_HELP;
            }
            case "install": {
                if (split.size() == 0) {
                    System.err.println("Side is required: \"client\" or \"server\"");
                    return Action.DISPLAY_HELP;
                }
                switch (arg = split.remove()) {
                    case "client": {
                        if (split.size() == 0) {
                            System.err.println("Minecraft version is required");
                            return Action.DISPLAY_HELP;
                        }
                        String minecraftVersion = split.remove();
                        if (split.size() == 0) {
                            return Action.installClient(minecraftVersion, null, null, false);
                        }
                        String loaderVersion = null;
                        arg = split.peek();
                        if (!arg.startsWith("-")) {
                            loaderVersion = split.remove();
                        }
                        if (split.size() == 0) {
                            return Action.installClient(minecraftVersion, loaderVersion, null, false);
                        }
                        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                        while (split.peek() != null) {
                            String option = split.remove();
                            if (!option.startsWith("--")) {
                                System.err.printf("Invalid option %s%n", option);
                                return Action.DISPLAY_HELP;
                            }
                            if (option.equals("--no-profile")) {
                                if (options.containsKey("--no-profile")) {
                                    System.err.println("Encountered duplicate option \"--no-profile\", This shouldn't affect anything");
                                }
                                options.put("--no-profile", null);
                                continue;
                            }
                            if (option.startsWith("--install-dir")) {
                                if (options.containsKey("--install-dir")) {
                                    System.err.println("Encountered duplicate option \"--install-dir\"");
                                    return Action.DISPLAY_HELP;
                                }
                                if (option.indexOf(61) == -1) {
                                    System.err.println("Option \"--install-dir\" must specify a value");
                                    return Action.DISPLAY_HELP;
                                }
                                if (!option.startsWith("--install-dir=")) {
                                    System.err.println("Option \"--install-dir\" must have a equals sign (=) right after the option name to get the value");
                                    return Action.DISPLAY_HELP;
                                }
                                String value = CliInstaller.unqoute(option.substring(14));
                                if (value == null) {
                                    System.err.println("Option \"--install-dir\" must have value quoted at start and end of value");
                                    return Action.DISPLAY_HELP;
                                }
                                options.put("--install-dir", value);
                                continue;
                            }
                            System.err.printf("Invalid option %s%n", option);
                            return Action.DISPLAY_HELP;
                        }
                        return Action.installClient(minecraftVersion, loaderVersion, (String)options.get("--install-dir"), !options.containsKey("--no-profile"));
                    }
                    case "server": {
                        if (split.size() == 0) {
                            System.err.println("Minecraft version is required");
                            return Action.DISPLAY_HELP;
                        }
                        String minecraftVersion = split.remove();
                        if (split.size() == 0) {
                            return Action.installServer(minecraftVersion, null, null, false, false);
                        }
                        String loaderVersion = null;
                        arg = split.peek();
                        if (!arg.startsWith("-")) {
                            loaderVersion = split.remove();
                        }
                        if (split.size() == 0) {
                            return Action.installServer(minecraftVersion, loaderVersion, null, false, false);
                        }
                        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                        while (split.peek() != null) {
                            String option = split.remove();
                            if (!option.startsWith("--")) {
                                System.err.printf("Invalid option %s%n", option);
                            }
                            if (option.equals("--create-scripts")) {
                                if (options.containsKey("--create-scripts")) {
                                    System.err.println("Encountered duplicate option \"--create-scripts\", This shouldn't affect anything");
                                }
                                options.put("--create-scripts", null);
                                continue;
                            }
                            if (option.equals("--download-server")) {
                                if (options.containsKey("--download-server")) {
                                    System.err.println("Encountered duplicate option \"--download-server\", This shouldn't affect anything");
                                }
                                options.put("--download-server", null);
                                continue;
                            }
                            if (option.startsWith("--install-dir")) {
                                if (options.containsKey("--install-dir")) {
                                    System.err.println("Encountered duplicate option \"--install-dir\"");
                                    return Action.DISPLAY_HELP;
                                }
                                if (option.indexOf(61) == -1) {
                                    System.err.println("Option \"--install-dir\" must specify a value");
                                    return Action.DISPLAY_HELP;
                                }
                                if (!option.startsWith("--install-dir=")) {
                                    System.err.println("Option \"--install-dir\" must have a equals sign (=) right after the option name to get the value");
                                    return Action.DISPLAY_HELP;
                                }
                                String value = CliInstaller.unqoute(option.substring(14));
                                if (value == null) {
                                    System.err.println("Option \"--install-dir\" must have value quoted at start and end of value");
                                    return Action.DISPLAY_HELP;
                                }
                                options.put("--install-dir", value);
                                continue;
                            }
                            System.err.printf("Invalid option %s%n", option);
                            return Action.DISPLAY_HELP;
                        }
                        return Action.installServer(minecraftVersion, loaderVersion, (String)options.get("--install-dir"), options.containsKey("--create-scripts"), options.containsKey("--download-server"));
                    }
                }
                System.err.printf("Invalid side \"%s\", expected \"client\" or \"server\"%n", arg);
                return Action.DISPLAY_HELP;
            }
        }
        System.err.printf("Invalid argument \"%s\"%n", arg);
        return Action.DISPLAY_HELP;
    }

    private static Queue<String> splitQuoted(String input) {
        LinkedList<String> ret = new LinkedList<String>();
        boolean inQuote = false;
        int lastEnd = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (c != ' ' || inQuote) continue;
            String word = input.substring(lastEnd, i);
            ret.add(word);
            lastEnd = i + 1;
        }
        String word = input.substring(lastEnd);
        ret.add(word);
        if (inQuote) {
            throw new IllegalArgumentException("Unterminated \" found");
        }
        return ret;
    }

    private static String unqoute(String input) {
        if (input.indexOf(34) == -1) {
            return input;
        }
        if (input.indexOf(34) != 0) {
            return null;
        }
        if (input.charAt(input.length() - 1) != '\"') {
            return null;
        }
        return input.substring(1, input.length() - 1);
    }
}

