/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.lib.json5.JsonReader;
import org.quiltmc.installer.lib.json5.JsonWriter;

public final class LauncherProfiles {
    private static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String LOADER_NAME = "quilt-loader";

    public static void updateProfiles(Path gameDir, String name, String gameVersion) throws IOException {
        Object launcherProfiles;
        Path launcherProfilesPath = gameDir.resolve("launcher_profiles.json");
        if (Files.notExists(launcherProfilesPath, new LinkOption[0])) {
            throw new IllegalStateException("No launcher_profiles.json to read from");
        }
        try (JsonReader reader = JsonReader.json(new InputStreamReader(Files.newInputStream(launcherProfilesPath, new OpenOption[0])));){
            launcherProfiles = Gsons.read(reader);
        }
        if (!(launcherProfiles instanceof Map)) {
            throw new IllegalArgumentException("launcher_profiles.json must have a root object!");
        }
        Object rawProfiles = ((Map)launcherProfiles).get("profiles");
        if (!(rawProfiles instanceof Map)) {
            throw new IllegalArgumentException("\"profiles\" field must be an object!");
        }
        Map profiles = (Map)rawProfiles;
        String newProfileName = "quilt-loader-" + gameVersion;
        if (profiles.containsKey(newProfileName)) {
            Object rawProfile = profiles.get(newProfileName);
            if (!(rawProfile instanceof Map)) {
                throw new IllegalStateException(String.format("Cannot update profile of name %s because it is not an object!", newProfileName));
            }
            Map profile = (Map)rawProfile;
            profile.put("lastVersionId", name);
        } else {
            LinkedHashMap<String, String> profile = new LinkedHashMap<String, String>();
            profile.put("name", newProfileName);
            profile.put("type", "custom");
            profile.put("created", ISO_8601.format(new Date()));
            profile.put("lastUsed", ISO_8601.format(new Date()));
            profile.put("icon", LauncherProfiles.createProfileIcon());
            profile.put("lastVersionId", name);
            profiles.put(newProfileName, profile);
        }
        try (JsonWriter writer = JsonWriter.json(Files.newBufferedWriter(launcherProfilesPath, new OpenOption[0]));){
            writer.setIndent("  ");
            Gsons.write(writer, launcherProfiles);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createProfileIcon() {
        try (InputStream stream = LauncherProfiles.class.getClassLoader().getResourceAsStream("icon.png");){
            int len;
            if (stream == null) return "TNT";
            byte[] ret = new byte[4096];
            int offset = 0;
            while ((len = stream.read(ret, offset, ret.length - offset)) != -1) {
                if ((offset += len) != ret.length) continue;
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            String string = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "TNT";
    }

    private LauncherProfiles() {
    }
}

