/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public final class OsPaths {
    private static final String WIN_APPDATA = "APPDATA";
    private static final String MAC_LIBRARY = "Library";
    private static final String MAC_APPLICATION_SUPPORT = "Application Support";
    private static final String DOT_MINECRAFT = ".minecraft";

    public static Path getDefaultInstallationDir() {
        String userHome = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        Path homeDir = Paths.get(userHome, new String[0]);
        if (os.contains("win") && System.getenv(WIN_APPDATA) != null) {
            return Paths.get(System.getenv(WIN_APPDATA), DOT_MINECRAFT);
        }
        if (os.contains("mac")) {
            return homeDir.resolve(MAC_LIBRARY).resolve(MAC_APPLICATION_SUPPORT).resolve("minecraft");
        }
        return homeDir.resolve(DOT_MINECRAFT);
    }

    public static Path getUserDataDir() {
        String userHome = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        Path homeDir = Paths.get(userHome, new String[0]);
        if (os.contains("win") && System.getenv(WIN_APPDATA) != null) {
            return Paths.get(System.getenv(WIN_APPDATA), new String[0]);
        }
        if (os.contains("mac")) {
            return homeDir.resolve(MAC_LIBRARY).resolve(MAC_APPLICATION_SUPPORT);
        }
        return homeDir.resolve(DOT_MINECRAFT);
    }

    private OsPaths() {
    }
}

