/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.ParseException;
import org.quiltmc.installer.QuiltMeta;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.Action;

public final class ListVersions
extends Action<Void> {
    private final boolean minecraftSnapshots;
    private final boolean loaderBetas;

    ListVersions(boolean minecraftSnapshots, boolean loaderBetas) {
        this.minecraftSnapshots = minecraftSnapshots;
        this.loaderBetas = loaderBetas;
    }

    @Override
    public void run(Consumer<Void> statusTracker) {
        CompletionStage versionManifest = ((CompletableFuture)VersionManifest.create().thenAccept(this::displayMinecraftVerions)).exceptionally(this::handleMinecraftVersionExceptions);
        CompletionStage quiltMeta = ((CompletableFuture)QuiltMeta.create("https://meta.quiltmc.org", "https://meta.fabricmc.net", Collections.singleton(QuiltMeta.LOADER_VERSIONS_ENDPOINT)).thenAccept(this::displayLoaderVersions)).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
        ListVersions.println(Localization.get("cli.lookup.versions"));
        CompletableFuture.allOf(new CompletableFuture[]{versionManifest, quiltMeta}).join();
    }

    private void displayMinecraftVerions(VersionManifest manifest) {
        ListVersions.println(Localization.createFrom("cli.latest.minecraft.release", manifest.latestRelease().id()));
        if (this.minecraftSnapshots) {
            ListVersions.println(Localization.createFrom("cli.latest.minecraft.snapshot", manifest.latestSnapshot().id()));
        }
    }

    private void displayLoaderVersions(QuiltMeta meta) {
        List<String> endpoint = meta.getEndpoint(QuiltMeta.LOADER_VERSIONS_ENDPOINT);
        ListVersions.println(Localization.createFrom("cli.latest.loader.release", endpoint.stream().filter(version -> !version.contains("-")).findFirst().get()));
        if (this.loaderBetas) {
            ListVersions.println(Localization.createFrom("cli.latest.loader.beta", endpoint.stream().filter(version -> version.contains("-")).findFirst().get()));
        }
    }

    private Void handleMinecraftVersionExceptions(Throwable exc) {
        ListVersions.eprintln(Localization.get("cli.lookup.failed.minecraft"));
        if (exc instanceof CompletionException) {
            exc = exc.getCause();
        }
        if (exc instanceof UncheckedIOException) {
            if (exc.getCause() instanceof UnknownHostException) {
                ListVersions.eprintln(Localization.get("cli.lookup.failed.connection"));
            } else {
                exc.printStackTrace();
            }
        } else if (exc instanceof ParseException) {
            ListVersions.eprintln(Localization.get("cli.lookup.failed.minecraft.malformed.1"));
            ListVersions.eprintln(Localization.createFrom("cli.lookup.failed.minecraft.malformed.2", "https://github.com/QuiltMC/quilt-installer"));
            exc.printStackTrace();
        } else {
            exc.printStackTrace();
        }
        System.exit(2);
        return null;
    }
}

