/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.gui.swing.SwingInstaller;

abstract class AbstractPanel
extends JPanel {
    final SwingInstaller gui;
    @Nullable
    private VersionManifest manifest;
    @Nullable
    private List<String> loaderVersions;
    @Nullable
    private Collection<String> intermediaryVersions;

    AbstractPanel(SwingInstaller gui) {
        this.gui = gui;
        this.setLayout(new BoxLayout(this, 3));
    }

    JComponent addRow() {
        JPanel rowPanel = new JPanel(new FlowLayout());
        this.add(rowPanel);
        return rowPanel;
    }

    void receiveVersions(VersionManifest manifest, List<String> loaderVersions, Collection<String> intermediaryVersions) {
        this.manifest = manifest;
        this.loaderVersions = loaderVersions;
        this.intermediaryVersions = intermediaryVersions;
    }

    @Nullable
    VersionManifest manifest() {
        return this.manifest;
    }

    @Nullable
    public List<String> loaderVersions() {
        return this.loaderVersions;
    }

    @Nullable
    public Collection<String> intermediaryVersions() {
        return this.intermediaryVersions;
    }

    static void populateMinecraftVersions(JComboBox<String> comboBox, VersionManifest manifest, Collection<String> intermediaryVersions, boolean snapshots) {
        comboBox.removeAllItems();
        for (VersionManifest.Version version : manifest) {
            if (!version.type().equals("release") && (!version.type().equals("snapshot") || !snapshots) || !intermediaryVersions.contains(version.id())) continue;
            comboBox.addItem(version.id());
        }
        comboBox.setEnabled(true);
    }

    static void populateLoaderVersions(JComboBox<String> comboBox, List<String> loaderVersions, boolean betas) {
        comboBox.removeAllItems();
        for (String loaderVersion : loaderVersions) {
            if (!betas && loaderVersion.contains("-")) continue;
            comboBox.addItem(loaderVersion);
        }
        comboBox.setEnabled(true);
    }

    @Nullable
    static String displayFileChooser(String initialDir) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(initialDir));
        chooser.setDialogTitle(Localization.get("gui.install-location.select"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected static boolean showPopup(String title, String description, int optionType, int messageType) {
        JEditorPane pane = new JEditorPane("text/html", "<html><body style=\"" + AbstractPanel.buildEditorPaneStyle() + "\">" + description + "</body></html>");
        pane.setEditable(false);
        pane.addHyperlinkListener(e -> {
            block3: {
                try {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block3;
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                        break block3;
                    }
                    throw new UnsupportedOperationException("Failed to open " + e.getURL().toString());
                }
                catch (Throwable throwable) {
                    AbstractPanel.displayError(throwable);
                }
            }
        });
        return JOptionPane.showOptionDialog(null, pane, title, optionType, messageType, null, null, null) == 0;
    }

    protected static void showInstalledMessage() {
        AbstractPanel.showPopup(Localization.get("dialog.install.successful"), Localization.createFrom("dialog.install.successful.description", "https://quiltmc.org/qsl"), -1, 1);
    }

    private static String buildEditorPaneStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        return String.format("font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), font.isBold() ? "bold" : "normal", font.getSize(), color.getRed(), color.getGreen(), color.getBlue());
    }

    static void displayError(Throwable throwable) {
    }
}

