/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.Action;
import org.quiltmc.installer.action.InstallServer;
import org.quiltmc.installer.gui.swing.AbstractPanel;
import org.quiltmc.installer.gui.swing.SwingInstaller;
import org.quiltmc.installer.lib.json5.JsonReader;

final class ServerPanel
extends AbstractPanel
implements Consumer<InstallServer.MessageType> {
    private final JComboBox<String> minecraftVersionSelector;
    private final JComboBox<String> loaderVersionSelector;
    private final JCheckBox showSnapshotsCheckBox;
    private final JCheckBox showLoaderBetasCheckBox;
    private final JTextField installLocation;
    private final JButton selectInstallationLocation;
    private final JButton installButton;
    private final JCheckBox downloadServerJarButton;
    private final JCheckBox generateLaunchScriptsButton;
    private boolean showSnapshots;
    private boolean showLoaderBetas;
    private boolean downloadServer = true;
    private boolean generateLaunchScripts = false;
    private boolean downloadServerAutoSelected = true;
    private boolean generateLaunchScriptsAutoSelected = true;

    ServerPanel(SwingInstaller gui) {
        super(gui);
        JComponent row1 = this.addRow();
        row1.add(new JLabel(Localization.get("gui.game.version")));
        this.minecraftVersionSelector = new JComboBox();
        row1.add(this.minecraftVersionSelector);
        this.minecraftVersionSelector.setPreferredSize(new Dimension(170, 26));
        this.minecraftVersionSelector.addItem(Localization.get("gui.install.loading"));
        this.minecraftVersionSelector.setEnabled(false);
        this.minecraftVersionSelector.addActionListener(e -> this.updateFlags());
        this.showSnapshotsCheckBox = new JCheckBox(Localization.get("gui.game.version.snapshots"));
        row1.add(this.showSnapshotsCheckBox);
        this.showSnapshotsCheckBox.setEnabled(false);
        this.showSnapshotsCheckBox.addItemListener(e -> {
            if (this.manifest() != null) {
                this.showSnapshots = e.getStateChange() == 1;
                ServerPanel.populateMinecraftVersions(this.minecraftVersionSelector, this.manifest(), this.intermediaryVersions(), this.showSnapshots);
            }
        });
        JComponent row2 = this.addRow();
        row2.add(new JLabel(Localization.get("gui.loader.version")));
        this.loaderVersionSelector = new JComboBox();
        row2.add(this.loaderVersionSelector);
        this.loaderVersionSelector.setPreferredSize(new Dimension(200, 26));
        this.loaderVersionSelector.addItem(Localization.get("gui.install.loading"));
        this.loaderVersionSelector.setEnabled(false);
        this.showLoaderBetasCheckBox = new JCheckBox(Localization.get("gui.loader.version.betas"));
        row2.add(this.showLoaderBetasCheckBox);
        this.showLoaderBetasCheckBox.setEnabled(false);
        this.showLoaderBetasCheckBox.addItemListener(e -> {
            if (this.loaderVersions() != null) {
                this.showLoaderBetas = e.getStateChange() == 1;
                ServerPanel.populateLoaderVersions(this.loaderVersionSelector, this.loaderVersions(), this.showLoaderBetas);
            }
        });
        JComponent row3 = this.addRow();
        row3.add(new JLabel(Localization.get("gui.install-location")));
        this.installLocation = new JTextField();
        row3.add(this.installLocation);
        this.installLocation.setPreferredSize(new Dimension(300, 26));
        this.installLocation.setText(Paths.get(System.getProperty("user.dir"), new String[0]).resolve("server").toString());
        this.selectInstallationLocation = new JButton();
        row3.add(this.selectInstallationLocation);
        this.selectInstallationLocation.setText("...");
        this.selectInstallationLocation.addActionListener(e -> {
            @Nullable String newLocation = ServerPanel.displayFileChooser(this.installLocation.getText());
            if (newLocation != null) {
                this.installLocation.setText(newLocation);
                this.updateFlags();
            }
        });
        JComponent row4 = this.addRow();
        this.downloadServerJarButton = new JCheckBox(Localization.get("gui.server.download.server"), this.downloadServer);
        row4.add(this.downloadServerJarButton);
        this.downloadServerJarButton.addItemListener(e -> {
            this.downloadServer = e.getStateChange() == 1;
        });
        this.generateLaunchScriptsButton = new JCheckBox(Localization.get("gui.server.generate-script"), this.generateLaunchScripts);
        row4.add(this.generateLaunchScriptsButton);
        this.generateLaunchScriptsButton.addItemListener(e -> {
            this.generateLaunchScripts = e.getStateChange() == 1;
        });
        this.generateLaunchScriptsButton.setToolTipText("Coming soon!");
        this.generateLaunchScriptsButton.setEnabled(false);
        JComponent row5 = this.addRow();
        this.installButton = new JButton();
        row5.add(this.installButton);
        this.installButton.setEnabled(false);
        this.installButton.setText(Localization.get("gui.install.loading"));
    }

    @Override
    void receiveVersions(VersionManifest manifest, List<String> loaderVersions, Collection<String> intermediaryVersions) {
        super.receiveVersions(manifest, loaderVersions, intermediaryVersions);
        ServerPanel.populateMinecraftVersions(this.minecraftVersionSelector, manifest, intermediaryVersions, this.showSnapshots);
        this.updateFlags();
        this.showSnapshotsCheckBox.setEnabled(true);
        ServerPanel.populateLoaderVersions(this.loaderVersionSelector, loaderVersions, this.showLoaderBetas);
        this.showLoaderBetasCheckBox.setEnabled(true);
        this.installButton.setText(Localization.get("gui.install"));
        this.installButton.setEnabled(true);
        this.installButton.addActionListener(this::install);
    }

    private void install(ActionEvent event) {
        boolean cancel = false;
        if (!this.downloadServer && this.downloadServerAutoSelected) {
            cancel = !AbstractPanel.showPopup(Localization.get("dialog.install.server.no-jar"), Localization.get("dialog.install.server.no-jar.description"), 0, 2);
        } else if (this.downloadServer && !this.downloadServerAutoSelected) {
            boolean bl = cancel = !AbstractPanel.showPopup(Localization.get("dialog.install.server.overwrite-jar"), Localization.get("dialog.install.server.overwrite-jar.description"), 0, 2);
        }
        if (cancel) {
            return;
        }
        InstallServer action = Action.installServer((String)this.minecraftVersionSelector.getSelectedItem(), (String)this.loaderVersionSelector.getSelectedItem(), this.installLocation.getText(), this.generateLaunchScripts, this.downloadServer);
        action.run(this);
        ServerPanel.showInstalledMessage();
    }

    private void updateFlags() {
        CompletableFuture.supplyAsync(() -> {
            Path serverJar = Paths.get(this.installLocation.getText(), new String[0]).resolve("server.jar");
            if (Files.exists(serverJar, new LinkOption[0])) {
                String string;
                block9: {
                    FileSystem fs = FileSystems.newFileSystem(serverJar, (ClassLoader)null);
                    try {
                        Path versionJson = fs.getPath("version.json", new String[0]);
                        Map map = (Map)Gsons.read(JsonReader.json(Files.newBufferedReader(versionJson)));
                        string = (String)map.get("id");
                        if (fs == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fs != null) {
                                try {
                                    fs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    fs.close();
                }
                return string;
            }
            return "";
        }).thenAcceptAsync(version -> this.downloadServerJarButton.setSelected(!version.equals(this.minecraftVersionSelector.getSelectedItem())), SwingUtilities::invokeLater);
    }

    @Override
    public void accept(InstallServer.MessageType messageType) {
    }
}

