/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.QuiltMeta;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.gui.swing.AbstractPanel;
import org.quiltmc.installer.gui.swing.ClientPanel;
import org.quiltmc.installer.gui.swing.ServerPanel;

public final class SwingInstaller
extends JFrame {
    public static final Executor SWING_EXECUTOR = SwingUtilities::invokeLater;
    private final ClientPanel clientPanel;
    private final ServerPanel serverPanel;

    public static void run() {
        try {
            String clazz = UIManager.getSystemLookAndFeelClassName();
            if (clazz.equals(UIManager.getCrossPlatformLookAndFeelClassName()) && SwingInstaller.useGtk()) {
                clazz = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            }
            UIManager.setLookAndFeel(clazz);
        }
        catch (ReflectiveOperationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(SwingInstaller::new);
    }

    private static boolean useGtk() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Class<?> clazz = Class.forName("sun.awt.SunToolkit");
            if (!clazz.isInstance(toolkit)) {
                return false;
            }
            Class<?> unsafe = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafe.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Object unsafeInstance = theUnsafe.get(null);
            Method staticFieldBase = unsafe.getDeclaredMethod("staticFieldBase", Field.class);
            Method staticFieldOffset = unsafe.getDeclaredMethod("staticFieldOffset", Field.class);
            Field impl_lookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            Method getObj = unsafe.getDeclaredMethod("getObject", Object.class, Long.TYPE);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)getObj.invoke(unsafeInstance, staticFieldBase.invoke(unsafeInstance, impl_lookup), staticFieldOffset.invoke(unsafeInstance, impl_lookup));
            return lookup.findVirtual(clazz, "isNativeGTKAvailable", MethodType.methodType(Boolean.TYPE)).invoke(toolkit);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private SwingInstaller() {
        try {
            JTabbedPane contentPane = new JTabbedPane(1);
            this.clientPanel = new ClientPanel(this);
            contentPane.addTab(Localization.get("tab.client"), null, this.clientPanel, Localization.get("tab.client.tooltip"));
            this.serverPanel = new ServerPanel(this);
            contentPane.addTab(Localization.get("tab.server"), null, this.serverPanel, Localization.get("tab.server.tooltip"));
            HashSet endpoints = new HashSet();
            endpoints.add(QuiltMeta.LOADER_VERSIONS_ENDPOINT);
            endpoints.add(QuiltMeta.INTERMEDIARY_VERSIONS_ENDPOINT);
            ((CompletableFuture)QuiltMeta.create("https://meta.quiltmc.org", "https://meta.fabricmc.net", endpoints).thenAcceptBothAsync(VersionManifest.create(), (quiltMeta, manifest) -> {
                List<String> loaderVersions = quiltMeta.getEndpoint(QuiltMeta.LOADER_VERSIONS_ENDPOINT).stream().filter(v -> !v.startsWith("0.16.0-beta.") || v.length() != 13 || v.charAt(12) == '9').collect(Collectors.toList());
                Set<String> intermediaryVersions = quiltMeta.getEndpoint(QuiltMeta.INTERMEDIARY_VERSIONS_ENDPOINT).keySet();
                this.clientPanel.receiveVersions((VersionManifest)manifest, loaderVersions, (Collection<String>)intermediaryVersions);
                this.serverPanel.receiveVersions((VersionManifest)manifest, loaderVersions, (Collection<String>)intermediaryVersions);
            }, SWING_EXECUTOR)).exceptionally(e -> {
                e.printStackTrace();
                AbstractPanel.displayError(e);
                return null;
            });
            this.setContentPane(contentPane);
            this.setDefaultCloseOperation(3);
            this.setTitle(Localization.get("title"));
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("icon.png")));
            this.pack();
            this.setLocationRelativeTo(null);
            this.setResizable(false);
            this.setVisible(true);
        }
        catch (HeadlessException e2) {
            System.exit(1);
            throw new IllegalStateException();
        }
        catch (Throwable t) {
            AbstractPanel.displayError(t);
            System.exit(1);
            throw new IllegalStateException();
        }
    }
}

