/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.capability;

import invoker54.reviveme.common.api.FallenProvider;
import invoker54.reviveme.common.config.ReviveMeConfig;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class FallenCapability {
    public static final String FALLEN_BOOL = "isFallenREVIVE";
    public static final String FELL_START_INT = "fellStartREVIVE";
    public static final String FELL_END_FLOAT = "fellEndREVIVE";
    public static final String REVIVE_START_INT = "revStartREVIVE";
    public static final String REVIVE_END_INT = "revEndREVIVE";
    public static final String PENALTY_ENUM = "penaltyTypeREVIVE";
    public static final String PENALTY_DOUBLE = "penaltyDoubleREVIVE";
    public static final String OTHERPLAYER_UUID = "otherPlayerREVIVE";
    protected World level;
    protected int revStart = 0;
    protected int revEnd = 0;
    protected int fellStart = 0;
    protected float fellEnd = 0.0f;
    protected DamageSource damageSource = DamageSource.field_76380_i;
    protected boolean isFallen = false;
    protected UUID otherPlayer = null;
    protected Double penaltyAmount = 0.0;
    protected PENALTYPE penaltyType = PENALTYPE.HEALTH;

    public FallenCapability(World level) {
        this.level = level;
    }

    public FallenCapability() {
    }

    public static FallenCapability GetFallCap(LivingEntity player) {
        return (FallenCapability)player.getCapability(FallenProvider.FALLENDATA).orElseGet(FallenCapability::new);
    }

    public void setPenalty(PENALTYPE type, Double amount) {
        this.penaltyAmount = amount;
        this.penaltyType = type;
    }

    public float getPenaltyAmount(LivingEntity player) {
        Double actualAmount = this.penaltyAmount;
        switch (this.penaltyType) {
            case NONE: {
                break;
            }
            case HEALTH: {
                if (!(actualAmount > 0.0) || !(actualAmount < 1.0)) break;
                actualAmount = actualAmount * (double)player.func_110138_aP();
                break;
            }
            case EXPERIENCE: {
                if (!(actualAmount > 0.0) || !(actualAmount < 1.0)) break;
                actualAmount = actualAmount * (double)((PlayerEntity)player).field_71067_cb;
                break;
            }
            case FOOD: {
                if (!(actualAmount > 0.0) || !(actualAmount < 1.0)) break;
                actualAmount = actualAmount * 40.0;
            }
        }
        return Math.round(actualAmount);
    }

    public PENALTYPE getPenaltyType() {
        return this.penaltyType;
    }

    public boolean hasEnough(PlayerEntity player) {
        switch (this.penaltyType) {
            case NONE: {
                return true;
            }
            case HEALTH: {
                return (double)player.func_110143_aJ() > this.penaltyAmount;
            }
            case EXPERIENCE: {
                return (double)player.field_71068_ca > this.penaltyAmount;
            }
            case FOOD: {
                return (double)((float)player.func_71024_bL().func_75116_a() + player.func_71024_bL().func_75115_e()) > this.penaltyAmount;
            }
        }
        return false;
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public float GetTimeLeft(boolean divideByMax) {
        if (ReviveMeConfig.timeLeft == 0) {
            return 1.0f;
        }
        if (divideByMax) {
            return 1.0f - (float)(this.level.func_82737_E() - (long)this.fellStart) / this.fellEnd;
        }
        return ((float)this.fellStart + this.fellEnd - (float)this.level.func_82737_E()) / 20.0f;
    }

    public boolean shouldDie() {
        return (float)this.level.func_82737_E() > this.fellEnd + (float)this.fellStart && ReviveMeConfig.timeLeft != 0;
    }

    public void SetTimeLeft(int timeStart, float maxSeconds) {
        this.fellStart = timeStart;
        this.fellEnd = maxSeconds * 20.0f;
    }

    public void resumeFallTimer() {
        this.fellStart = (int)(this.level.func_82737_E() - (long)(this.revStart - this.fellStart));
    }

    public void ForceDeath() {
        this.SetTimeLeft(1, 0.0f);
    }

    public boolean isFallen() {
        return this.isFallen;
    }

    public void setFallen(boolean fallen) {
        this.isFallen = fallen;
        if (!fallen) {
            this.setProgress(0, 1);
            this.SetTimeLeft(0, 1.0f);
            this.setOtherPlayer(null);
        }
    }

    public UUID getOtherPlayer() {
        return this.otherPlayer;
    }

    public boolean compareUUID(UUID targUUID) {
        if (targUUID == null) {
            return false;
        }
        if (this.getOtherPlayer() == null) {
            return false;
        }
        return this.getOtherPlayer().equals(targUUID);
    }

    public void setOtherPlayer(UUID playerID) {
        this.otherPlayer = playerID;
    }

    public void setProgress(int timeStart, int seconds) {
        this.revStart = timeStart;
        this.revEnd = seconds * 20;
    }

    public float getProgress() {
        return (float)(this.level.func_82737_E() - (long)this.revStart) / (float)this.revEnd;
    }

    public INBT writeNBT() {
        CompoundNBT cNBT = new CompoundNBT();
        cNBT.func_74768_a(FELL_START_INT, this.fellStart);
        cNBT.func_74776_a(FELL_END_FLOAT, this.fellEnd / 20.0f);
        cNBT.func_74757_a(FALLEN_BOOL, this.isFallen);
        cNBT.func_74768_a(REVIVE_START_INT, this.revStart);
        cNBT.func_74768_a(REVIVE_END_INT, this.revEnd / 20);
        cNBT.func_74778_a(PENALTY_ENUM, this.penaltyType.name());
        cNBT.func_74780_a(PENALTY_DOUBLE, this.penaltyAmount.doubleValue());
        if (this.otherPlayer != null) {
            cNBT.func_186854_a(OTHERPLAYER_UUID, this.otherPlayer);
        }
        return cNBT;
    }

    public void readNBT(INBT nbt) {
        CompoundNBT cNBT = (CompoundNBT)nbt;
        this.SetTimeLeft(cNBT.func_74762_e(FELL_START_INT), cNBT.func_74762_e(FELL_END_FLOAT));
        this.setFallen(cNBT.func_74767_n(FALLEN_BOOL));
        this.setProgress(cNBT.func_74762_e(REVIVE_START_INT), cNBT.func_74762_e(REVIVE_END_INT));
        this.setPenalty(PENALTYPE.valueOf(cNBT.func_74779_i(PENALTY_ENUM)), cNBT.func_74769_h(PENALTY_DOUBLE));
        if (cNBT.func_186855_b(OTHERPLAYER_UUID)) {
            this.setOtherPlayer(cNBT.func_186857_a(OTHERPLAYER_UUID));
        } else {
            this.setOtherPlayer(null);
        }
    }

    public static class FallenNBTStorage
    implements Capability.IStorage<FallenCapability> {
        @Nullable
        public INBT writeNBT(Capability<FallenCapability> capability, FallenCapability instance, Direction side) {
            CompoundNBT cNBT = new CompoundNBT();
            cNBT.func_74768_a(FallenCapability.FELL_START_INT, instance.fellStart);
            cNBT.func_74776_a(FallenCapability.FELL_END_FLOAT, instance.fellEnd / 20.0f);
            cNBT.func_74757_a(FallenCapability.FALLEN_BOOL, instance.isFallen());
            cNBT.func_74778_a(FallenCapability.PENALTY_ENUM, instance.penaltyType.name());
            cNBT.func_74780_a(FallenCapability.PENALTY_DOUBLE, instance.penaltyAmount.doubleValue());
            return cNBT;
        }

        public void readNBT(Capability<FallenCapability> capability, FallenCapability instance, Direction side, INBT nbt) {
            CompoundNBT cNBT = (CompoundNBT)nbt;
            instance.SetTimeLeft(cNBT.func_74762_e(FallenCapability.FELL_START_INT), cNBT.func_74762_e(FallenCapability.FELL_END_FLOAT));
            instance.setFallen(cNBT.func_74767_n(FallenCapability.FALLEN_BOOL));
            try {
                instance.setPenalty(PENALTYPE.valueOf(cNBT.func_74779_i(FallenCapability.PENALTY_ENUM)), cNBT.func_74769_h(FallenCapability.PENALTY_DOUBLE));
            }
            catch (Exception e) {
                instance.setPenalty(PENALTYPE.NONE, 0.0);
            }
        }
    }

    public static enum PENALTYPE {
        NONE,
        HEALTH,
        EXPERIENCE,
        FOOD;

    }
}

