/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.config;

import invoker54.reviveme.common.capability.FallenCapability;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="reviveme", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ReviveMeConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static Integer timeLeft;
    public static Integer reviveTime;
    public static Double revivedHealth;
    public static Double revivedFood;
    public static FallenCapability.PENALTYPE penaltyType;
    public static Double penaltyAmount;
    public static Double reviveInvulnTime;

    public static void bakeConfig() {
        timeLeft = (Integer)ReviveMeConfig.COMMON.timeLeft.get();
        reviveTime = (Integer)ReviveMeConfig.COMMON.reviveTime.get();
        revivedHealth = (Double)ReviveMeConfig.COMMON.revivedHealth.get();
        revivedFood = (Double)ReviveMeConfig.COMMON.revivedFood.get();
        penaltyType = (FallenCapability.PENALTYPE)((Object)ReviveMeConfig.COMMON.penaltyType.get());
        penaltyAmount = (Double)ReviveMeConfig.COMMON.penaltyAmount.get();
        reviveInvulnTime = (Double)ReviveMeConfig.COMMON.reviveInvulnTime.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> timeLeft;
        public final ForgeConfigSpec.ConfigValue<Integer> reviveTime;
        public final ForgeConfigSpec.ConfigValue<Double> revivedHealth;
        public final ForgeConfigSpec.ConfigValue<Double> revivedFood;
        public final ForgeConfigSpec.EnumValue<FallenCapability.PENALTYPE> penaltyType;
        public final ForgeConfigSpec.ConfigValue<Double> penaltyAmount;
        public final ForgeConfigSpec.ConfigValue<Double> reviveInvulnTime;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Revive Me! Config");
            this.timeLeft = builder.comment("How long you have before death. Default is 30 seconds. Setting to 0 will disable the timer").defineInRange("Time Left", 30, 0, Integer.MAX_VALUE);
            this.reviveTime = builder.comment("How long to revive someone").define("Revive Time", (Object)4);
            this.revivedHealth = builder.comment("How much health you will be revived with, 0 is max health, Less than 1 is percentage").defineInRange("Revive Health", 10.0, 0.0, 2.147483647E9);
            this.revivedFood = builder.comment("How much food you will be revived with, 0 is max food, Less than 1 is percentage").defineInRange("Revive Food", 6.0, 0.0, 2.147483647E9);
            this.penaltyType = builder.comment("What the reviver will lose").defineEnum("Penalty Type", (Enum)FallenCapability.PENALTYPE.FOOD);
            this.penaltyAmount = builder.comment("Amount that will be taken from reviver, Numbers below 1 and greater than 0 will turn it into a percentage").define("Penalty Amount", (Object)15.0);
            this.reviveInvulnTime = builder.comment("How many seconds of invulnerability you have on revive").defineInRange("Revive_Invuln_Time", 3.0, 0.0, 3.4028234663852886E38);
            builder.pop();
        }
    }
}

