/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="reviveme")
public class FallenTimerEvent {
    @SubscribeEvent
    public static void TickDownTimer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.func_233643_dh_()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (!cap.isFallen() || cap.getOtherPlayer() != null) {
            return;
        }
        if (event.player.func_184812_l_()) {
            cap.setFallen(false);
            event.player.func_213301_b(Pose.STANDING);
            event.player.func_195061_cb();
            event.player.func_70606_j(event.player.func_110138_aP());
            return;
        }
        if (event.player.func_70051_ag()) {
            event.player.func_70031_b(false);
        }
        if (event.player.func_110143_aJ() != 1.0f) {
            event.player.func_70606_j(1.0f);
        }
        event.player.func_71024_bL().func_75114_a(0);
        if (!cap.shouldDie()) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        event.player.func_70097_a(cap.getDamageSource().func_76359_i().func_76348_h(), Float.MAX_VALUE);
    }

    @SubscribeEvent
    public static void TickProgress(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (cap.getOtherPlayer() == null) {
            return;
        }
        if (cap.getProgress() < 1.0f) {
            return;
        }
        if (!cap.isFallen()) {
            return;
        }
        PlayerEntity fellPlayer = event.player;
        if (event.side == LogicalSide.SERVER) {
            ServerPlayerEntity revPlayer = fellPlayer.func_184102_h().func_184103_al().func_177451_a(cap.getOtherPlayer());
            switch (cap.getPenaltyType()) {
                case NONE: {
                    break;
                }
                case HEALTH: {
                    revPlayer.func_70606_j(Math.max(1.0f, revPlayer.func_110143_aJ() - cap.getPenaltyAmount((LivingEntity)revPlayer)));
                    break;
                }
                case EXPERIENCE: {
                    revPlayer.field_71067_cb = (int)((float)revPlayer.field_71067_cb - cap.getPenaltyAmount((LivingEntity)revPlayer));
                    break;
                }
                case FOOD: {
                    FoodStats food = revPlayer.func_71024_bL();
                    float amountNeeded = cap.getPenaltyAmount((LivingEntity)revPlayer);
                    float saturation = food.func_75115_e();
                    food.func_75119_b(food.func_75115_e() - amountNeeded);
                    amountNeeded = Math.max(0.0f, amountNeeded - saturation);
                    food.func_75114_a((int)((float)food.func_75116_a() - amountNeeded));
                }
            }
            float healAmount = ReviveMeConfig.revivedHealth == 0.0 ? fellPlayer.func_110138_aP() : (ReviveMeConfig.revivedHealth > 0.0 && ReviveMeConfig.revivedHealth < 1.0 ? (float)((double)fellPlayer.func_110138_aP() * ReviveMeConfig.revivedHealth) : ReviveMeConfig.revivedHealth.floatValue());
            fellPlayer.func_70606_j(healAmount);
            float foodAmount = ReviveMeConfig.revivedFood == 0.0 ? 40.0f : (ReviveMeConfig.revivedFood > 0.0 && ReviveMeConfig.revivedFood < 1.0 ? (float)(40.0 * ReviveMeConfig.revivedFood) : ReviveMeConfig.revivedFood.floatValue());
            fellPlayer.func_71024_bL().func_75122_a((int)Math.min(20.0f, foodAmount), 0.0f);
            fellPlayer.func_71024_bL().func_75122_a(1, Math.max(0.0f, foodAmount - 20.0f) / 2.0f);
            fellPlayer.func_195061_cb();
            if (ReviveMeConfig.reviveInvulnTime != 0.0) {
                fellPlayer.func_195064_c(new EffectInstance(Effects.field_76429_m, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
                fellPlayer.func_195064_c(new EffectInstance(Effects.field_76426_n, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
            }
        }
        cap.setFallen(false);
        fellPlayer.func_213301_b(Pose.STANDING);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(fellPlayer.func_189512_bd(), cap.writeNBT());
        if (event.side == LogicalSide.SERVER) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> fellPlayer), (Object)new SyncClientCapMsg((INBT)nbt));
        }
    }
}

