/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="reviveme")
public class InteractionEvents {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void useOnPlayer(PlayerInteractEvent.EntityInteract event) {
        if (!event.getSide().isServer()) {
            return;
        }
        PlayerEntity revplayer = event.getPlayer();
        FallenCapability myCap = FallenCapability.GetFallCap((LivingEntity)revplayer);
        if (myCap.isFallen()) {
            return;
        }
        if (revplayer.func_226273_bm_()) {
            return;
        }
        if (!(event.getTarget() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity targPlayer = (PlayerEntity)event.getTarget();
        FallenCapability targCap = FallenCapability.GetFallCap((LivingEntity)targPlayer);
        if (!targCap.isFallen() || targCap.getOtherPlayer() != null) {
            return;
        }
        switch (targCap.getPenaltyType()) {
            case NONE: {
                break;
            }
            case HEALTH: {
                if (!(revplayer.func_110143_aJ() < targCap.getPenaltyAmount((LivingEntity)targPlayer))) break;
                return;
            }
            case EXPERIENCE: {
                if (!((float)revplayer.field_71067_cb < targCap.getPenaltyAmount((LivingEntity)targPlayer))) break;
                return;
            }
            case FOOD: {
                if (!((float)revplayer.func_71024_bL().func_75116_a() + revplayer.func_71024_bL().func_75115_e() < targCap.getPenaltyAmount((LivingEntity)targPlayer))) break;
                return;
            }
        }
        targCap.setProgress((int)revplayer.field_70170_p.func_82737_E(), ReviveMeConfig.reviveTime);
        targCap.setOtherPlayer(revplayer.func_110124_au());
        myCap.setProgress((int)revplayer.field_70170_p.func_82737_E(), ReviveMeConfig.reviveTime);
        myCap.setOtherPlayer(targPlayer.func_110124_au());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(revplayer.func_189512_bd(), myCap.writeNBT());
        nbt.func_218657_a(targPlayer.func_189512_bd(), targCap.writeNBT());
        NetworkHandler.sendToPlayer(targPlayer, new SyncClientCapMsg((INBT)nbt));
        NetworkHandler.sendToPlayer(revplayer, new SyncClientCapMsg((INBT)nbt));
    }

    @SubscribeEvent
    public static void attackPlayer(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        LOGGER.info("START OF ATTACKING");
        LOGGER.info("What is the source? : " + event.getSource());
        if (event.getSource() != null) {
            LOGGER.info("Does it go through invulnerability: " + event.getSource().func_76357_e());
            if (event.getSource().func_76346_g() != null) {
                LOGGER.info("whats the entity? : " + event.getSource().func_76346_g().func_200200_C_().getString());
            }
        }
        if (event.getSource() != null && event.getSource().func_76357_e()) {
            LOGGER.info("Damage bypasses invulnerability, let it pass");
            return;
        }
        if (!cap.isFallen()) {
            LOGGER.info("They have not fallen, let it pass.");
            return;
        }
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof PlayerEntity && event.getSource().func_76346_g().func_213453_ef()) {
            LOGGER.info("It's a sneaking player! let it pass.");
            return;
        }
        LOGGER.info("CANCELING THE ATTACK EVENT");
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void cancelItemUse(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (cap.isFallen()) {
            return;
        }
        if (cap.getOtherPlayer() == null) {
            return;
        }
        if (event.player.func_184587_cr()) {
            event.player.func_184602_cy();
        }
    }
}

