/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import invoker54.invocore.client.Ticker;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientUtil {
    public static final Minecraft mC = Minecraft.func_71410_x();
    public static final TextureManager TEXTURE_MANAGER = Minecraft.func_71410_x().field_71446_o;
    public static final ItemRenderer ITEM_RENDERER = Minecraft.func_71410_x().func_175599_af();
    public static final DecimalFormat d1 = new DecimalFormat("0.0");
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final ArrayList<Bounds> cropBounds = new ArrayList();

    public static void drawWorldLine(MatrixStack stack, Vector3d origin, Vector3d target, float lineWidth, int color) {
        stack.func_227860_a_();
        Vector3d cam = ClientUtil.mC.field_71460_t.func_215316_n().func_216785_c().func_216371_e();
        stack.func_227861_a_(cam.func_82615_a(), cam.func_82617_b(), cam.func_82616_c());
        cam = cam.func_216371_e();
        Matrix4f lastPos = stack.func_227866_c_().func_227870_a_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Vector3d directionVector = target.func_72444_a(cam).func_72431_c(origin.func_72444_a(cam)).func_72432_b();
        Vector3d originUP = origin.func_178787_e(directionVector.func_186678_a((double)(lineWidth / 2.0f)));
        Vector3d originDOWN = origin.func_178787_e(directionVector.func_186678_a((double)(-lineWidth / 2.0f)));
        Vector3d targetUP = target.func_178787_e(directionVector.func_186678_a((double)(lineWidth / 2.0f)));
        Vector3d targetDOWN = target.func_178787_e(directionVector.func_186678_a((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(lastPos, (float)originUP.func_82615_a(), (float)originUP.func_82617_b(), (float)originUP.func_82616_c()).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)targetUP.func_82615_a(), (float)targetUP.func_82617_b(), (float)targetUP.func_82616_c()).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)targetDOWN.func_82615_a(), (float)targetDOWN.func_82617_b(), (float)targetDOWN.func_82616_c()).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)originDOWN.func_82615_a(), (float)originDOWN.func_82617_b(), (float)originDOWN.func_82616_c()).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableDepthTest();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        stack.func_227865_b_();
    }

    public static void drawWorldLine(MatrixStack stack, Vector3d origin, Vector3d target, float lineWidth, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        stack.func_227860_a_();
        Vector3d cam = ClientUtil.mC.field_71460_t.func_215316_n().func_216785_c().func_216371_e();
        stack.func_227861_a_(cam.func_82615_a(), cam.func_82617_b(), cam.func_82616_c());
        cam = cam.func_216371_e();
        Matrix4f lastPos = stack.func_227866_c_().func_227870_a_();
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        Vector3d directionVector = target.func_72444_a(cam).func_72431_c(origin.func_72444_a(cam)).func_72432_b();
        Vector3d originUP = origin.func_178787_e(directionVector.func_186678_a((double)(lineWidth / 2.0f)));
        Vector3d originDOWN = origin.func_178787_e(directionVector.func_186678_a((double)(-lineWidth / 2.0f)));
        Vector3d targetUP = target.func_178787_e(directionVector.func_186678_a((double)(lineWidth / 2.0f)));
        Vector3d targetDOWN = target.func_178787_e(directionVector.func_186678_a((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(lastPos, (float)originUP.func_82615_a(), (float)originUP.func_82617_b(), (float)originUP.func_82616_c()).func_225583_a_(u0, v0).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)targetUP.func_82615_a(), (float)targetUP.func_82617_b(), (float)targetUP.func_82616_c()).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)targetDOWN.func_82615_a(), (float)targetDOWN.func_82617_b(), (float)targetDOWN.func_82616_c()).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)originDOWN.func_82615_a(), (float)originDOWN.func_82617_b(), (float)originDOWN.func_82616_c()).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        stack.func_227865_b_();
    }

    public static void blitImage(MatrixStack stack, int x0, int width, int y0, int height, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        Matrix4f lastPos = stack.func_227866_c_().func_227870_a_();
        int x1 = x0 + width;
        int y1 = y0 + height;
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(lastPos, (float)x0, (float)y1, 0.0f).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)x1, (float)y1, 0.0f).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)x1, (float)y0, 0.0f).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)x0, (float)y0, 0.0f).func_225583_a_(u0, v0).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableDepthTest();
    }

    public static void blitColor(MatrixStack stack, int x0, int width, int y0, int height, int color) {
        Matrix4f lastPos = stack.func_227866_c_().func_227870_a_();
        int x1 = x0 + width;
        int y1 = y0 + height;
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(lastPos, (float)x0, (float)y1, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)x1, (float)y1, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)x1, (float)y0, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(lastPos, (float)x0, (float)y0, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static PlayerEntity getPlayer() {
        return ClientUtil.mC.field_71439_g;
    }

    public static World getWorld() {
        return ClientUtil.mC.field_71441_e;
    }

    public static Vector3d smoothLerp(Vector3d oldPos, Vector3d newPos, boolean useDelta) {
        return new Vector3d(ClientUtil.smoothLerp(oldPos.field_72450_a, newPos.field_72450_a, useDelta), ClientUtil.smoothLerp(oldPos.field_72448_b, newPos.field_72448_b, useDelta), ClientUtil.smoothLerp(oldPos.field_72449_c, newPos.field_72449_c, useDelta));
    }

    public static double smoothLerp(double oldDouble, double newDouble, boolean useDelta) {
        return MathHelper.func_219803_d((double)(useDelta ? (double)Ticker.getDelta(true, true) : (double)mC.func_184121_ak()), (double)oldDouble, (double)newDouble);
    }

    public static void copyEntityMovement(LivingEntity copier, LivingEntity toCopy) {
        copier.func_233576_c_(toCopy.func_213303_ch());
        copier.field_70169_q = toCopy.field_70169_q;
        copier.field_70142_S = toCopy.field_70142_S;
        copier.field_70167_r = toCopy.field_70167_r;
        copier.field_70137_T = toCopy.field_70137_T;
        copier.field_70166_s = toCopy.field_70166_s;
        copier.field_70136_U = toCopy.field_70136_U;
        copier.func_213317_d(toCopy.func_213322_ci());
        copier.func_70034_d(toCopy.func_70079_am());
        copier.field_70758_at = toCopy.field_70758_at;
        copier.func_181013_g(toCopy.field_70761_aq);
        copier.field_70760_ar = toCopy.field_70760_ar;
    }

    public static boolean inBounds(float xSpot, float ySpot, Bounds bounds) {
        if (xSpot < (float)bounds.x0 || xSpot > (float)bounds.x1) {
            return false;
        }
        return !(ySpot < (float)bounds.y0) && !(ySpot > (float)bounds.y1);
    }

    public static void beginCrop(double x, double width, double y, double height, boolean fresh) {
        if (fresh) {
            cropBounds.add(new Bounds((int)x, (int)width, (int)y, (int)height));
        }
        double scale = mC.func_228018_at_().func_198100_s();
        int windowHeight = mC.func_228018_at_().func_198087_p();
        y = (double)windowHeight - (height + y);
        RenderSystem.enableScissor((int)((int)(x *= scale)), (int)((int)(y *= scale)), (int)((int)(width *= scale)), (int)((int)(height *= scale)));
    }

    public static void endCrop() {
        if (cropBounds.size() != 0) {
            cropBounds.remove(cropBounds.size() - 1);
        }
        if (!cropBounds.isEmpty()) {
            Bounds cropBound = cropBounds.get(cropBounds.size() - 1);
            ClientUtil.beginCrop(cropBound.x0, cropBound.x1 - cropBound.x0, cropBound.y0, cropBound.y1 - cropBound.y0, false);
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static String ticksToTime(int ticks) {
        int hours = ticks / 72000;
        int minutes = (ticks -= hours * 7200) / 1200;
        int seconds = (ticks -= minutes * 1200) / 20;
        return (hours <= 9 ? "0" : "") + hours + ":" + (minutes <= 9 ? "0" : "") + minutes + ":" + (seconds <= 9 ? "0" : "") + seconds;
    }

    public static String formatValue(double value) {
        if (value == 0.0) {
            return "0";
        }
        String suffix = " KMBT";
        String formattedNumber = "";
        DecimalFormat formatter = new DecimalFormat("#,###.#");
        int power = (int)StrictMath.log10(value);
        formattedNumber = formatter.format(value /= Math.pow(10.0, power / 3 * 3));
        return (formattedNumber = formattedNumber + suffix.charAt(power / 3)).length() > 4 ? formattedNumber.replaceAll("\\.[0-9]+ ", "") : formattedNumber;
    }

    @Deprecated
    public static void drawStretchText(MatrixStack stack, String text, float currSize, int targSize, int x, int y, int color, boolean shadow) {
        stack.func_227860_a_();
        float newScale = (float)targSize / currSize;
        stack.func_227862_a_(newScale, newScale, newScale);
        x = Math.round((float)x / newScale);
        y = Math.round((float)y / newScale);
        if (shadow) {
            ClientUtil.mC.field_71466_p.func_238405_a_(stack, text, (float)x, (float)y, color);
        } else {
            ClientUtil.mC.field_71466_p.func_238421_b_(stack, text, (float)x, (float)y, color);
        }
        stack.func_227865_b_();
    }

    public static class ListEntry
    extends AbstractList.AbstractListEntry<ListEntry> {
        protected SimpleList parent;
        protected int height = 0;
        protected int heightPadding = 1;
        protected boolean isMouseOver = false;

        public ListEntry(SimpleList parent, int height) {
            this.parent = parent;
            this.setHeight(height);
        }

        public int getWidth() {
            return 0;
        }

        public void setHeight(int newHeight) {
            this.height = newHeight;
        }

        public int getHeight() {
            return this.height + this.heightPadding * 2;
        }

        public void func_230432_a_(MatrixStack stack, int index, int y0, int x0, int rowWidth, int rowHeight, int xMouse, int yMouse, boolean isMouseOver, float partialTicks) {
            this.isMouseOver = xMouse >= x0 && xMouse <= x0 + rowWidth && yMouse >= y0 && yMouse <= y0 + rowHeight;
        }

        public boolean func_231047_b_(double xMouse, double yMouse) {
            return this.isMouseOver;
        }
    }

    public static class SimpleList
    extends AbstractList<ListEntry> {
        public final List<ITextComponent> toolTip = new ArrayList<ITextComponent>();
        Image background;
        int screenWidth;
        int screenHeight;
        protected ListEntry hoverEntry = null;

        public SimpleList(int x0, int width, int y0, int height, int screenWidth, int screenHeight, Image background) {
            super(mC, width, 0, y0, y0 + height, 30);
            this.field_230675_l_ = x0;
            this.field_230674_k_ = x0 + width;
            this.func_244605_b(false);
            this.func_244606_c(false);
            this.func_230944_a_(false, 0);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.background = background;
            LOGGER.debug("WHATS MY X0: " + x0);
            LOGGER.debug("WHATS MY WIDTH: " + width);
            LOGGER.debug("WHATS MY Y0: " + y0);
            LOGGER.debug("WHATS MY HEIGHT: " + height);
        }

        public void recalcWidth() {
            int width = 0;
            for (ListEntry entry : this.func_231039_at__()) {
                if (entry.getWidth() <= width) continue;
                width = entry.getWidth();
            }
            this.field_230670_d_ = width;
        }

        public void updatePosition(int x0, int y0, int height) {
            this.func_230959_g_(x0);
            this.field_230672_i_ = y0;
            this.field_230673_j_ = y0 + height;
        }

        public void func_230430_a_(MatrixStack stack, int xMouse, int yMouse, float partialTicks) {
            if (this.func_231039_at__().isEmpty()) {
                return;
            }
            super.func_230430_a_(stack, xMouse, yMouse, partialTicks);
            ClientUtil.beginCrop(this.field_230675_l_, this.field_230674_k_ - this.field_230675_l_, this.field_230672_i_, this.field_230673_j_ - this.field_230672_i_, true);
            if (!this.toolTip.isEmpty()) {
                GuiUtils.drawHoveringText((MatrixStack)stack, this.toolTip, (int)xMouse, (int)yMouse, (int)this.screenWidth, (int)this.screenHeight, (int)-1, (FontRenderer)ClientUtil.mC.field_71466_p);
                this.toolTip.clear();
            }
            ClientUtil.endCrop();
        }

        protected void func_238478_a_(MatrixStack stack, int p_238478_2_, int p_238478_3_, int xMouse, int yMouse, float p_238478_6_) {
            int i = this.func_230965_k_();
            this.hoverEntry = null;
            int currY0 = (int)((double)this.field_230672_i_ - this.func_230966_l_());
            for (int index = 0; index < i; ++index) {
                int k = currY0;
                int height = ((ListEntry)this.func_230953_d_(index)).getHeight();
                ListEntry e = (ListEntry)this.func_230953_d_(index);
                int k1 = this.func_230949_c_();
                int j2 = this.func_230968_n_();
                e.func_230432_a_(stack, index, k, j2, k1, height, xMouse, yMouse, this.func_231047_b_(xMouse, yMouse) && Objects.equals(this.func_230933_a_(xMouse, yMouse), (Object)e), p_238478_6_);
                currY0 += e.getHeight();
                if (!e.func_231047_b_(xMouse, yMouse)) continue;
                this.hoverEntry = e;
            }
        }

        public int func_230968_n_() {
            return this.field_230675_l_;
        }

        public int addEntry(@Nonnull ListEntry entry) {
            return super.func_230513_b_((AbstractList.AbstractListEntry)entry);
        }

        protected int func_230952_d_() {
            return this.field_230675_l_ + this.func_230949_c_();
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        public boolean func_231044_a_(double xMouse, double yMouse, int button) {
            this.func_230947_b_(xMouse, yMouse, button);
            if (!this.func_231047_b_(xMouse, yMouse)) {
                return false;
            }
            if (this.hoverEntry != null) {
                if (this.hoverEntry.func_231044_a_(xMouse, yMouse, button)) {
                    this.func_231035_a_((IGuiEventListener)this.hoverEntry);
                    this.func_231037_b__(true);
                    return true;
                }
            } else if (button == 0) {
                this.func_230938_a_((int)(xMouse - (double)(this.field_230675_l_ + this.field_230670_d_ / 2 - this.func_230949_c_() / 2)), (int)(yMouse - (double)this.field_230672_i_) + (int)this.func_230966_l_() - 4);
                return true;
            }
            return false;
        }
    }

    public static class Image {
        protected ResourceLocation location;
        protected int u0;
        protected int v0;
        protected float imageWidth;
        protected float imageHeight;
        public int x0;
        protected int origWidth;
        protected int actualWidth;
        public int y0;
        protected int actualHeight;
        protected int origHeight;
        protected int scale;

        public Image(ResourceLocation loc, int u0, float imageWidth, int v0, float imageHeight, int scale) {
            this.location = loc;
            this.u0 = u0;
            this.imageWidth = imageWidth;
            this.actualWidth = (int)imageWidth;
            this.origWidth = (int)imageWidth;
            this.v0 = v0;
            this.imageHeight = imageHeight;
            this.actualHeight = (int)imageHeight;
            this.origHeight = (int)imageHeight;
            this.scale = scale;
        }

        public void resetScale() {
            this.actualWidth = this.origWidth;
            this.actualHeight = this.origHeight;
        }

        public int centerOnImageX(int targWidth) {
            return this.x0 + (this.actualWidth - targWidth) / 2;
        }

        public int centerOnImageY(int targHeight) {
            return this.y0 + (this.actualHeight - targHeight) / 2;
        }

        public void centerImageX(int x0, int width) {
            this.x0 = x0 + (width - this.actualWidth) / 2;
        }

        public void centerImageY(int y0, int height) {
            this.y0 = y0 + (height - this.actualHeight) / 2;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x0 && mouseX <= this.x0 + this.actualWidth && mouseY >= this.y0 && mouseY <= this.y0 + this.actualHeight;
        }

        public int getWidth() {
            return this.actualWidth;
        }

        public int getHeight() {
            return this.actualHeight;
        }

        public int getRight() {
            return this.x0 + this.getWidth();
        }

        public int getDown() {
            return this.y0 + this.getHeight();
        }

        public void moveTo(int x0, int y0) {
            this.x0 = x0;
            this.y0 = y0;
        }

        public void setImageSize(float imageWidth, float imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
        }

        public void setActualSize(int actualWidth, int actualHeight) {
            this.actualWidth = actualWidth;
            this.actualHeight = actualHeight;
        }

        public void RenderImage(MatrixStack stack) {
            TEXTURE_MANAGER.func_110577_a(this.location);
            ClientUtil.blitImage(stack, this.x0, this.actualWidth, this.y0, this.actualHeight, this.u0, this.imageWidth, this.v0, this.imageHeight, this.scale);
            TEXTURE_MANAGER.func_147645_c(this.location);
        }
    }

    public static class SimpleButton
    extends Button {
        public boolean hidden = false;

        public SimpleButton(int x, int y, int width, int height, ITextComponent textComponent, Button.IPressable onPress) {
            super(x, y, width, height, textComponent, onPress);
            this.field_230694_p_ = true;
        }

        public void func_230431_b_(MatrixStack stack, int xMouse, int yMouse, float partialTicks) {
            if (this.hidden) {
                return;
            }
            FontRenderer fontrenderer = ClientUtil.mC.field_71466_p;
            TEXTURE_MANAGER.func_110577_a(field_230687_i_);
            int i = this.func_230989_a_(this.func_230449_g_());
            i = 46 + i * 20;
            ClientUtil.blitImage(stack, this.field_230690_l_, this.field_230688_j_ / 2, this.field_230691_m_, this.field_230689_k_, 0.0f, (float)this.field_230688_j_ / 2.0f, i, 20.0f, 256.0f);
            ClientUtil.blitImage(stack, this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230688_j_ / 2, this.field_230691_m_, this.field_230689_k_, 200 - this.field_230688_j_ / 2, this.field_230688_j_ / 2, i, 20.0f, 256.0f);
            int j = this.getFGColor();
            SimpleButton.func_238472_a_((MatrixStack)stack, (FontRenderer)fontrenderer, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
        }
    }

    public static class Bounds {
        int x0;
        int x1;
        int y0;
        int y1;

        public Bounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public Bounds() {
        }

        public void adjustBounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public int getMinX() {
            return this.x0;
        }

        public int getMaxX() {
            return this.x1;
        }

        public int getMinY() {
            return this.y0;
        }

        public int getMaxY() {
            return this.y1;
        }
    }
}

