/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import invoker54.invocore.client.ClientUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextUtil {
    private static int black = new Color(0, 0, 0, 255).getRGB();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void renderText(MatrixStack stack, ITextComponent text, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(text);
        TextUtil.renderText(stack, list, shadow, x0, maxWidth, y0, maxHeight, padding, align);
    }

    public static void renderText(MatrixStack stack, List<ITextComponent> textLines, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        FontRenderer font = ClientUtil.mC.field_71466_p;
        stack.func_227860_a_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        float maxTxtHeight = textLines.size() * 8;
        maxTxtHeight -= 1.0f;
        maxTxtHeight += (float)(padding * 2);
        float maxTxtWidth = 0.0f;
        for (ITextComponent textComponent : textLines) {
            int currentWidth = font.func_78256_a(textComponent.getString());
            if (!((float)currentWidth > maxTxtWidth)) continue;
            maxTxtWidth = currentWidth;
        }
        maxTxtWidth += (float)(padding * 2);
        if (shadow) {
            maxTxtHeight += 1.0f;
            maxTxtWidth += 1.0f;
        }
        float heightLeft = maxHeight - maxTxtHeight;
        float widthLeft = maxWidth - maxTxtWidth;
        float scaleFactor = 0.0f;
        if (heightLeft < widthLeft || heightLeft == widthLeft) {
            scaleFactor = maxHeight / maxTxtHeight;
        } else if (heightLeft > widthLeft) {
            scaleFactor = maxWidth / maxTxtWidth;
        }
        stack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        for (int a = 0; a < textLines.size(); ++a) {
            ITextComponent currText = textLines.get(a);
            float y = y0 / scaleFactor;
            float f = (maxHeight - maxTxtHeight * scaleFactor) / 2.0f;
            font.getClass();
            y += (f + (float)(a * 9) * scaleFactor) / scaleFactor;
            float x = x0 / scaleFactor;
            switch (align) {
                case LEFT: {
                    x = (x + (float)padding) / scaleFactor;
                    break;
                }
                case MIDDLE: {
                    x += (maxWidth - (float)(font.func_238414_a_((ITextProperties)currText) - 1) * scaleFactor) / 2.0f / scaleFactor;
                    break;
                }
                case RIGHT: {
                    x = (x + maxWidth) / scaleFactor - ((float)padding / scaleFactor + (float)font.func_238414_a_((ITextProperties)currText) * scaleFactor);
                }
            }
            TextUtil.renderText(currText, stack, x, y, shadow);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
        stack.func_227865_b_();
    }

    public static void renderText(ITextComponent text, MatrixStack stack, float x, float y, boolean shadow) {
        RenderSystem.disableDepthTest();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int i = "deadmau5".equals(text.getString()) ? -10 : 0;
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        int lightCoords = 0xF000F0;
        boolean j = false;
        FontRenderer fontrenderer = ClientUtil.mC.field_71466_p;
        fontrenderer.func_243247_a(text, x, y, -1, shadow, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, true, 0, lightCoords);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
    }

    public static enum txtAlignment {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

