/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.capability;

import invoker54.reviveme.common.api.FallenProvider;
import invoker54.reviveme.common.config.ReviveMeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FallenCapability {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String FALLEN_BOOL = "isFallenREVIVE";
    public static final String FELL_START_INT = "fellStartREVIVE";
    public static final String FELL_END_FLOAT = "fellEndREVIVE";
    public static final String REVIVE_START_INT = "revStartREVIVE";
    public static final String REVIVE_END_INT = "revEndREVIVE";
    public static final String PENALTY_ENUM = "penaltyTypeREVIVE";
    public static final String PENALTY_DOUBLE = "penaltyDoubleREVIVE";
    public static final String PENALTY_ITEM = "penaltyItemREVIVE";
    public static final String OTHERPLAYER_UUID = "otherPlayerREVIVE";
    public static final String SACRIFICEITEMS_STRING = "sacrificeItemStringREVIVE";
    public static final String SACRIFICEITEMS_BOOL = "sacrificeItemsBoolREVIVE";
    public static final String REVIVECHANCE_BOOL = "reviveChanceBoolREVIVE";
    protected Level level;
    protected int revStart = 0;
    protected int revEnd = 0;
    protected int fellStart = 0;
    protected float fellEnd = 0.0f;
    protected DamageSource damageSource = DamageSource.f_19317_;
    protected boolean isFallen = false;
    protected UUID otherPlayer = null;
    protected Double penaltyAmount = 0.0;
    protected ItemStack penaltyItem = ItemStack.f_41583_;
    protected PENALTYPE penaltyType = PENALTYPE.HEALTH;
    protected List<Item> sacrificialItems = new ArrayList<Item>();
    protected boolean sacrificedItemsUsed = false;
    protected boolean reviveChanceUsed = false;

    public FallenCapability(Level level) {
        this.level = level;
    }

    public FallenCapability() {
    }

    public static FallenCapability GetFallCap(LivingEntity player) {
        return (FallenCapability)player.getCapability(FallenProvider.FALLENDATA).orElseGet(FallenCapability::new);
    }

    public void setPenalty(PENALTYPE type, Double amount, String penaltyItem) {
        this.penaltyItem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(penaltyItem)));
        this.setPenalty(type, amount);
    }

    public void setPenalty(PENALTYPE type, Double amount) {
        this.penaltyAmount = amount;
        this.penaltyType = type;
    }

    public float getPenaltyAmount(LivingEntity player) {
        Double actualAmount = this.penaltyAmount;
        switch (this.penaltyType) {
            case NONE: {
                break;
            }
            case HEALTH: {
                if (!(actualAmount > 0.0) || !(actualAmount < 1.0)) break;
                actualAmount = actualAmount * (double)player.m_21233_();
                break;
            }
            case EXPERIENCE: {
                if (!(actualAmount > 0.0) || !(actualAmount < 1.0)) break;
                actualAmount = actualAmount * (double)((Player)player).f_36078_;
                break;
            }
            case FOOD: {
                if (!(actualAmount > 0.0) || !(actualAmount < 1.0)) break;
                actualAmount = actualAmount * 40.0;
                break;
            }
        }
        if (player instanceof Player && ((Player)player).m_7500_()) {
            actualAmount = 0.0;
        }
        return Math.round(actualAmount);
    }

    public ItemStack getPenaltyItem() {
        return this.penaltyItem;
    }

    public PENALTYPE getPenaltyType() {
        return this.penaltyType;
    }

    public boolean hasEnough(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        return switch (this.penaltyType) {
            default -> throw new IncompatibleClassChangeError();
            case PENALTYPE.NONE -> true;
            case PENALTYPE.HEALTH -> {
                if ((double)player.m_21223_() > this.penaltyAmount) {
                    yield true;
                }
                yield false;
            }
            case PENALTYPE.EXPERIENCE -> {
                if ((double)player.f_36078_ > this.penaltyAmount) {
                    yield true;
                }
                yield false;
            }
            case PENALTYPE.FOOD -> {
                if ((double)((float)player.m_36324_().m_38702_() + Math.max(player.m_36324_().m_38722_(), 0.0f)) > this.penaltyAmount) {
                    yield true;
                }
                yield false;
            }
            case PENALTYPE.ITEM -> (double)player.m_150109_().m_18947_(this.penaltyItem.m_41720_()) > this.penaltyAmount;
        };
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public float GetTimeLeft(boolean divideByMax) {
        if (divideByMax) {
            return 1.0f - (float)(this.level.m_46467_() - (long)this.fellStart) / this.fellEnd;
        }
        return ((float)this.fellStart + this.fellEnd - (float)this.level.m_46467_()) / 20.0f;
    }

    public boolean shouldDie() {
        return (float)this.level.m_46467_() > this.fellEnd + (float)this.fellStart && ReviveMeConfig.timeLeft != 0;
    }

    public void SetTimeLeft(int timeStart, float maxSeconds) {
        this.fellStart = timeStart;
        this.fellEnd = maxSeconds * 20.0f;
    }

    public void resumeFallTimer() {
        this.fellStart = (int)(this.level.m_46467_() - (long)(this.revStart - this.fellStart));
    }

    public void ForceDeath() {
        this.SetTimeLeft(1, 0.0f);
    }

    public boolean isFallen() {
        return this.isFallen;
    }

    public void setFallen(boolean fallen) {
        this.isFallen = fallen;
        if (!fallen) {
            this.setProgress(0, 1);
            this.SetTimeLeft(0, 1.0f);
            this.setOtherPlayer(null);
        }
    }

    public UUID getOtherPlayer() {
        return this.otherPlayer;
    }

    public boolean isReviver(UUID targUUID) {
        if (targUUID == null) {
            return false;
        }
        if (this.getOtherPlayer() == null) {
            return false;
        }
        return this.getOtherPlayer().equals(targUUID);
    }

    public void setOtherPlayer(UUID playerID) {
        this.otherPlayer = playerID;
    }

    public void setProgress(int timeStart, int seconds) {
        this.revStart = timeStart;
        this.revEnd = seconds * 20;
    }

    public float getProgress() {
        return (float)(this.level.m_46467_() - (long)this.revStart) / (float)this.revEnd;
    }

    public void setSacrificialItems(@Nonnull ArrayList<Item> itemList) {
        this.sacrificialItems = itemList;
    }

    public ArrayList<Item> getItemList() {
        return new ArrayList<Item>(this.sacrificialItems);
    }

    public boolean usedSacrificedItems() {
        return this.sacrificedItemsUsed;
    }

    public void setSacrificedItemsUsed(boolean flag) {
        this.sacrificedItemsUsed = flag;
    }

    public boolean usedChance() {
        return this.reviveChanceUsed;
    }

    public void setReviveChanceUsed(boolean flag) {
        this.reviveChanceUsed = flag;
    }

    public Tag writeNBT() {
        CompoundTag cNBT = new CompoundTag();
        cNBT.m_128405_(FELL_START_INT, this.fellStart);
        cNBT.m_128350_(FELL_END_FLOAT, this.fellEnd / 20.0f);
        cNBT.m_128379_(FALLEN_BOOL, this.isFallen);
        cNBT.m_128405_(REVIVE_START_INT, this.revStart);
        cNBT.m_128405_(REVIVE_END_INT, this.revEnd / 20);
        cNBT.m_128359_(PENALTY_ENUM, this.penaltyType.name());
        cNBT.m_128347_(PENALTY_DOUBLE, this.penaltyAmount.doubleValue());
        cNBT.m_128359_(PENALTY_ITEM, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.penaltyItem.m_41720_()).toString());
        StringBuilder ItemList = new StringBuilder();
        for (Item item : this.sacrificialItems) {
            ItemList.append(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item)).append(",");
        }
        cNBT.m_128359_(SACRIFICEITEMS_STRING, ItemList.toString());
        cNBT.m_128379_(SACRIFICEITEMS_BOOL, this.sacrificedItemsUsed);
        cNBT.m_128379_(REVIVECHANCE_BOOL, this.reviveChanceUsed);
        if (this.otherPlayer != null) {
            cNBT.m_128362_(OTHERPLAYER_UUID, this.otherPlayer);
        }
        return cNBT;
    }

    public void readNBT(Tag nbt) {
        CompoundTag cNBT = (CompoundTag)nbt;
        this.SetTimeLeft(cNBT.m_128451_(FELL_START_INT), cNBT.m_128451_(FELL_END_FLOAT));
        this.setFallen(cNBT.m_128471_(FALLEN_BOOL));
        this.setProgress(cNBT.m_128451_(REVIVE_START_INT), cNBT.m_128451_(REVIVE_END_INT));
        this.setPenalty(PENALTYPE.valueOf(cNBT.m_128461_(PENALTY_ENUM)), cNBT.m_128459_(PENALTY_DOUBLE), cNBT.m_128461_(PENALTY_ITEM));
        this.sacrificialItems.clear();
        for (String itemString : cNBT.m_128461_(SACRIFICEITEMS_STRING).split(",")) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString));
            if (item == Items.f_41852_) continue;
            this.sacrificialItems.add(item);
        }
        this.sacrificedItemsUsed = cNBT.m_128471_(SACRIFICEITEMS_BOOL);
        this.reviveChanceUsed = cNBT.m_128471_(REVIVECHANCE_BOOL);
        if (cNBT.m_128403_(OTHERPLAYER_UUID)) {
            this.setOtherPlayer(cNBT.m_128342_(OTHERPLAYER_UUID));
        } else {
            this.setOtherPlayer(null);
        }
    }

    public static enum PENALTYPE {
        NONE,
        HEALTH,
        EXPERIENCE,
        FOOD,
        ITEM;

    }
}

