/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.config;

import invoker54.reviveme.common.capability.FallenCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="reviveme", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ReviveMeConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static Integer timeLeft;
    public static Integer reviveTime;
    public static Double revivedHealth;
    public static Double revivedFood;
    public static FallenCapability.PENALTYPE penaltyType;
    public static Double penaltyAmount;
    public static String penaltyItem;
    public static Double reviveInvulnTime;
    public static Double reviveChance;
    public static Double sacrificialItemPercent;
    public static Double fallenPenaltyTimer;
    public static boolean selfReviveMultiplayer;
    public static List<String> blockedCommands;
    public static Boolean compactReviveUI;
    private static boolean isDirty;

    public static void bakeConfig() {
        timeLeft = (Integer)ReviveMeConfig.COMMON.timeLeft.get();
        reviveTime = (Integer)ReviveMeConfig.COMMON.reviveTime.get();
        revivedHealth = (Double)ReviveMeConfig.COMMON.revivedHealth.get();
        revivedFood = (Double)ReviveMeConfig.COMMON.revivedFood.get();
        penaltyType = (FallenCapability.PENALTYPE)((Object)ReviveMeConfig.COMMON.penaltyType.get());
        penaltyAmount = (Double)ReviveMeConfig.COMMON.penaltyAmount.get();
        penaltyItem = (String)ReviveMeConfig.COMMON.penaltyItem.get();
        reviveInvulnTime = (Double)ReviveMeConfig.COMMON.reviveInvulnTime.get();
        reviveChance = (Double)ReviveMeConfig.COMMON.reviveChance.get();
        sacrificialItemPercent = (Double)ReviveMeConfig.COMMON.sacrificialItemPercent.get();
        fallenPenaltyTimer = (Double)ReviveMeConfig.COMMON.fallenPenaltyTimer.get();
        selfReviveMultiplayer = (Boolean)ReviveMeConfig.COMMON.selfReviveMultiplayer.get();
        blockedCommands = (List)ReviveMeConfig.COMMON.blockedCommands.get();
        compactReviveUI = (Boolean)ReviveMeConfig.COMMON.compactReviveUI.get();
    }

    public static CompoundTag serialize() {
        CompoundTag mainTag = new CompoundTag();
        mainTag.m_128379_("selfReviveMultiplayer", selfReviveMultiplayer);
        String allBlockedCommands = "";
        for (String string : blockedCommands) {
            allBlockedCommands = allBlockedCommands.concat(string + ",");
        }
        mainTag.m_128359_("blockedCommands", allBlockedCommands);
        return mainTag;
    }

    public static void deserialize(CompoundTag mainTag) {
        selfReviveMultiplayer = mainTag.m_128471_("selfReviveMultiplayer");
        blockedCommands = Arrays.asList(mainTag.m_128461_("blockedCommands").split(","));
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfigEvent eventConfig) {
        if (eventConfig.getConfig().getSpec() == COMMON_SPEC) {
            ReviveMeConfig.bakeConfig();
            ReviveMeConfig.markDirty(true);
        }
    }

    public static void markDirty(boolean dirty) {
        isDirty = dirty;
    }

    public static boolean isDirty() {
        return isDirty;
    }

    static {
        isDirty = false;
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> timeLeft;
        public final ForgeConfigSpec.ConfigValue<Integer> reviveTime;
        public final ForgeConfigSpec.ConfigValue<Double> revivedHealth;
        public final ForgeConfigSpec.ConfigValue<Double> revivedFood;
        public final ForgeConfigSpec.EnumValue<FallenCapability.PENALTYPE> penaltyType;
        public final ForgeConfigSpec.ConfigValue<Double> penaltyAmount;
        public final ForgeConfigSpec.ConfigValue<String> penaltyItem;
        public final ForgeConfigSpec.ConfigValue<Double> reviveInvulnTime;
        public final ForgeConfigSpec.ConfigValue<Double> reviveChance;
        public final ForgeConfigSpec.ConfigValue<Double> sacrificialItemPercent;
        public final ForgeConfigSpec.ConfigValue<Double> fallenPenaltyTimer;
        public final ForgeConfigSpec.ConfigValue<Boolean> selfReviveMultiplayer;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockedCommands;
        public final ForgeConfigSpec.ConfigValue<Boolean> compactReviveUI;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Revive Me! Config");
            this.timeLeft = builder.comment("How long you have before death. Default is 30 seconds. Setting to 0 will disable the timer").defineInRange("Time Left", 30, 0, Integer.MAX_VALUE);
            this.reviveTime = builder.comment("How long to revive someone").define("Revive Time", (Object)3);
            this.revivedHealth = builder.comment("How much health you will be revived with, 0 is max health, Less than 1 is percentage").defineInRange("Revive Health", 10.0, 0.0, 2.147483647E9);
            this.revivedFood = builder.comment("How much food you will be revived with, 0 is max food, Less than 1 is percentage").defineInRange("Revive Food", 6.0, 0.0, 2.147483647E9);
            this.penaltyType = builder.comment("What the reviver will lose").defineEnum("Penalty Type", (Enum)FallenCapability.PENALTYPE.FOOD);
            this.penaltyAmount = builder.comment("Amount that will be taken from reviver, Numbers below 1 and greater than 0 will turn it into a percentage").define("Penalty Amount", (Object)10.0);
            this.penaltyItem = builder.comment("Item used to revive fallen players (Only if you selected ITEM as penalty type). Usage: MODID:ITEM").define("Revive Item", (Object)"minecraft:golden_apple");
            this.reviveInvulnTime = builder.comment("How many seconds of invulnerability you have on revive").defineInRange("Revive_Invuln_Time", 5.0, 0.0, 3.4028234663852886E38);
            this.reviveChance = builder.comment("(SinglePlayer only) How high your chance is to revive.").defineInRange("Revive Chance", 0.5, 0.0, 1.0);
            this.sacrificialItemPercent = builder.comment("(SinglePlayer only) Percentage to lose for sacrificial items.").defineInRange("Sacrificial item percentage", 0.5, 0.0, 1.0);
            this.fallenPenaltyTimer = builder.comment("how long the self-revive penalty will last in SECONDS until you can use both options again").defineInRange("Self_Revive_Penalty_Timer", 45.0, 0.0, Double.MAX_VALUE);
            this.selfReviveMultiplayer = builder.comment("If you can use self-revive methods in multiplayer").define("Self_Revive_Multiplayer", false);
            this.blockedCommands = builder.comment("Commands the player isn't allowed to use while fallen").define("Blocked_Commands", new ArrayList());
            builder.pop();
            builder.push("Client Settings");
            this.compactReviveUI = builder.comment("Makes self-revive UI smaller, more compact").define("Compact_UI", false);
            builder.pop();
        }
    }
}

