/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.network.message;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallenTimerEvent;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SacrificeItemsMsg {
    public static void handle(SacrificeItemsMsg msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (!player.m_6084_()) {
                return;
            }
            FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
            if (!cap.usedSacrificedItems() && cap.getItemList().size() != 0) {
                block0: for (Item item : cap.getItemList()) {
                    Inventory playerInv = player.m_150109_();
                    int amountToLose = (int)Math.round(Math.max(1.0, (double)playerInv.m_18947_(item) * ReviveMeConfig.sacrificialItemPercent));
                    for (int a = 0; a < playerInv.m_6643_(); ++a) {
                        ItemStack currStack = playerInv.m_8020_(a);
                        if (currStack.m_150930_(item)) {
                            int takeAway = Math.min(amountToLose, currStack.m_41613_());
                            amountToLose -= takeAway;
                            currStack.m_41764_(currStack.m_41613_() - takeAway);
                        }
                        if (amountToLose == 0) continue block0;
                    }
                }
                cap.setSacrificialItems(new ArrayList<Item>());
                cap.setSacrificedItemsUsed(true);
                FallenTimerEvent.revivePlayer((Player)player);
            } else {
                player.m_20331_(false);
                player.m_6469_(cap.getDamageSource().m_19380_().m_19381_(), Float.MAX_VALUE);
            }
        });
        context.setPacketHandled(true);
    }
}

