/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import invoker54.invocore.client.Ticker;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientUtil {
    public static final Minecraft mC = Minecraft.m_91087_();
    public static final TextureManager TEXTURE_MANAGER = Minecraft.m_91087_().f_90987_;
    public static final ItemRenderer ITEM_RENDERER = Minecraft.m_91087_().m_91291_();
    public static final DecimalFormat d1 = new DecimalFormat("0.0");
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final ArrayList<Bounds> cropBounds = new ArrayList();

    public static void drawWorldLine(PoseStack stack, Vec3 origin, Vec3 target, float lineWidth, int color) {
        stack.m_85836_();
        Vec3 cam = ClientUtil.mC.f_91063_.m_109153_().m_90583_().m_82548_();
        stack.m_85837_(cam.m_7096_(), cam.m_7098_(), cam.m_7094_());
        cam = cam.m_82548_();
        Matrix4f lastPos = stack.m_85850_().m_85861_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Vec3 directionVector = target.m_82505_(cam).m_82537_(origin.m_82505_(cam)).m_82541_();
        Vec3 originUP = origin.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 originDOWN = origin.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        Vec3 targetUP = target.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 targetDOWN = target.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(lastPos, (float)originUP.m_7096_(), (float)originUP.m_7098_(), (float)originUP.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(lastPos, (float)targetUP.m_7096_(), (float)targetUP.m_7098_(), (float)targetUP.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(lastPos, (float)targetDOWN.m_7096_(), (float)targetDOWN.m_7098_(), (float)targetDOWN.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(lastPos, (float)originDOWN.m_7096_(), (float)originDOWN.m_7098_(), (float)originDOWN.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        RenderSystem.m_69481_();
        stack.m_85849_();
    }

    public static void drawWorldLine(PoseStack stack, Vec3 origin, Vec3 target, float lineWidth, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        stack.m_85836_();
        Vec3 cam = ClientUtil.mC.f_91063_.m_109153_().m_90583_().m_82548_();
        stack.m_85837_(cam.m_7096_(), cam.m_7098_(), cam.m_7094_());
        cam = cam.m_82548_();
        Matrix4f lastPos = stack.m_85850_().m_85861_();
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        Vec3 directionVector = target.m_82505_(cam).m_82537_(origin.m_82505_(cam)).m_82541_();
        Vec3 originUP = origin.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 originDOWN = origin.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        Vec3 targetUP = target.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 targetDOWN = target.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        RenderSystem.m_69453_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(lastPos, (float)originUP.m_7096_(), (float)originUP.m_7098_(), (float)originUP.m_7094_()).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_85982_(lastPos, (float)targetUP.m_7096_(), (float)targetUP.m_7098_(), (float)targetUP.m_7094_()).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_85982_(lastPos, (float)targetDOWN.m_7096_(), (float)targetDOWN.m_7098_(), (float)targetDOWN.m_7094_()).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_85982_(lastPos, (float)originDOWN.m_7096_(), (float)originDOWN.m_7098_(), (float)originDOWN.m_7094_()).m_7421_(u0, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        RenderSystem.m_69481_();
        stack.m_85849_();
    }

    public static void blitImage(PoseStack stack, float x0, float width, float y0, float height, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        Matrix4f lastPos = stack.m_85850_().m_85861_();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(lastPos, x0, y1, 0.0f).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_85982_(lastPos, x1, y1, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_85982_(lastPos, x1, y0, 0.0f).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_85982_(lastPos, x0, y0, 0.0f).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void blitColor(PoseStack stack, float x0, float width, float y0, float height, int color) {
        Matrix4f lastPos = stack.m_85850_().m_85861_();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(lastPos, x0, y1, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(lastPos, x1, y1, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(lastPos, x1, y0, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(lastPos, x0, y0, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void blitItem(PoseStack stack, float x0, float width, float y0, float height, ItemStack itemStack) {
        boolean flag;
        Lighting.m_84930_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        ItemRenderer renderer = mC.m_91291_();
        BakedModel bakedModel = renderer.m_174264_(itemStack, null, null, 0);
        RenderSystem.m_69465_();
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x0, (double)y0, (double)(100.0f + renderer.f_115093_));
        posestack.m_85837_((double)(width / 2.0f), (double)(height / 2.0f), 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(width, height, 16.0f);
        RenderSystem.m_157182_();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        renderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static Player getPlayer() {
        return ClientUtil.mC.f_91074_;
    }

    public static Level getWorld() {
        return ClientUtil.mC.f_91073_;
    }

    public static Vec3 smoothLerp(Vec3 oldPos, Vec3 newPos, boolean useDelta) {
        return new Vec3(ClientUtil.smoothLerp(oldPos.f_82479_, newPos.f_82479_, useDelta), ClientUtil.smoothLerp(oldPos.f_82480_, newPos.f_82480_, useDelta), ClientUtil.smoothLerp(oldPos.f_82481_, newPos.f_82481_, useDelta));
    }

    public static double smoothLerp(double oldDouble, double newDouble, boolean useDelta) {
        return Mth.m_14139_((double)(useDelta ? (double)Ticker.getDelta(true, true) : (double)mC.m_91296_()), (double)oldDouble, (double)newDouble);
    }

    public static void copyEntityMovement(LivingEntity copier, LivingEntity toCopy) {
        copier.m_20219_(toCopy.m_20182_());
        copier.f_19854_ = toCopy.f_19854_;
        copier.f_19790_ = toCopy.f_19790_;
        copier.f_19855_ = toCopy.f_19855_;
        copier.f_19791_ = toCopy.f_19791_;
        copier.f_19856_ = toCopy.f_19856_;
        copier.f_19792_ = toCopy.f_19792_;
        copier.m_20256_(toCopy.m_20184_());
        copier.m_5616_(toCopy.m_6080_());
        copier.f_20886_ = toCopy.f_20886_;
        copier.m_5618_(toCopy.f_20883_);
        copier.f_20884_ = toCopy.f_20884_;
    }

    public static boolean inBounds(float xSpot, float ySpot, Bounds bounds) {
        if (xSpot < (float)bounds.x0 || xSpot > (float)bounds.x1) {
            return false;
        }
        return !(ySpot < (float)bounds.y0) && !(ySpot > (float)bounds.y1);
    }

    public static void beginCrop(double x, double width, double y, double height, boolean fresh) {
        if (fresh) {
            cropBounds.add(new Bounds((int)x, (int)width, (int)y, (int)height));
        }
        double scale = mC.m_91268_().m_85449_();
        int windowHeight = mC.m_91268_().m_85446_();
        y = (double)windowHeight - (height + y);
        RenderSystem.m_69488_((int)((int)(x *= scale)), (int)((int)(y *= scale)), (int)((int)(width *= scale)), (int)((int)(height *= scale)));
    }

    public static void endCrop() {
        if (cropBounds.size() != 0) {
            cropBounds.remove(cropBounds.size() - 1);
        }
        if (!cropBounds.isEmpty()) {
            Bounds cropBound = cropBounds.get(cropBounds.size() - 1);
            ClientUtil.beginCrop(cropBound.x0, cropBound.x1 - cropBound.x0, cropBound.y0, cropBound.y1 - cropBound.y0, false);
        } else {
            RenderSystem.m_69471_();
        }
    }

    public static String ticksToTime(int ticks) {
        int hours = ticks / 72000;
        int minutes = (ticks -= hours * 7200) / 1200;
        int seconds = (ticks -= minutes * 1200) / 20;
        return (hours <= 9 ? "0" : "") + hours + ":" + (minutes <= 9 ? "0" : "") + minutes + ":" + (seconds <= 9 ? "0" : "") + seconds;
    }

    public static String formatValue(double value) {
        if (value == 0.0) {
            return "0";
        }
        String suffix = " KMBT";
        Object formattedNumber = "";
        DecimalFormat formatter = new DecimalFormat("#,###.#");
        int power = (int)StrictMath.log10(value);
        formattedNumber = formatter.format(value /= Math.pow(10.0, power / 3 * 3));
        return ((String)(formattedNumber = (String)formattedNumber + suffix.charAt(power / 3))).length() > 4 ? ((String)formattedNumber).replaceAll("\\.[0-9]+ ", "") : formattedNumber;
    }

    @Deprecated
    public static void drawStretchText(PoseStack stack, String text, float currSize, int targSize, int x, int y, int color, boolean shadow) {
        stack.m_85836_();
        float newScale = (float)targSize / currSize;
        stack.m_85841_(newScale, newScale, newScale);
        x = Math.round((float)x / newScale);
        y = Math.round((float)y / newScale);
        if (shadow) {
            ClientUtil.mC.f_91062_.m_92750_(stack, text, (float)x, (float)y, color);
        } else {
            ClientUtil.mC.f_91062_.m_92883_(stack, text, (float)x, (float)y, color);
        }
        stack.m_85849_();
    }

    public static class Bounds {
        int x0;
        int x1;
        int y0;
        int y1;

        public Bounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public Bounds() {
        }

        public void adjustBounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public int getMinX() {
            return this.x0;
        }

        public int getMaxX() {
            return this.x1;
        }

        public int getMinY() {
            return this.y0;
        }

        public int getMaxY() {
            return this.y1;
        }
    }

    public static class ListEntry
    extends AbstractSelectionList.Entry<ListEntry> {
        protected SimpleList parent;
        protected int height = 0;
        protected int heightPadding = 1;
        protected boolean isMouseOver = false;

        public ListEntry(SimpleList parent, int height) {
            this.parent = parent;
            this.setHeight(height);
        }

        public int getWidth() {
            return 0;
        }

        public void setHeight(int newHeight) {
            this.height = newHeight;
        }

        public int getHeight() {
            return this.height + this.heightPadding * 2;
        }

        public void m_6311_(PoseStack stack, int index, int y0, int x0, int rowWidth, int rowHeight, int xMouse, int yMouse, boolean isMouseOver, float partialTicks) {
            this.isMouseOver = xMouse >= x0 && xMouse <= x0 + rowWidth && yMouse >= y0 && yMouse <= y0 + rowHeight;
        }

        public boolean m_5953_(double xMouse, double yMouse) {
            return this.isMouseOver;
        }
    }

    public static class SimpleList
    extends AbstractSelectionList<ListEntry> {
        public final List<Component> toolTip = new ArrayList<Component>();
        Image background;
        int screenWidth;
        int screenHeight;
        protected ListEntry hoverEntry = null;

        public SimpleList(int x0, int width, int y0, int height, int screenWidth, int screenHeight, Image background) {
            super(mC, width, 0, y0, y0 + height, 30);
            this.f_93393_ = x0;
            this.f_93392_ = x0 + width;
            this.m_93488_(false);
            this.m_93496_(false);
            this.m_93473_(false, 0);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.background = background;
            LOGGER.debug("WHATS MY X0: " + x0);
            LOGGER.debug("WHATS MY WIDTH: " + width);
            LOGGER.debug("WHATS MY Y0: " + y0);
            LOGGER.debug("WHATS MY HEIGHT: " + height);
        }

        public void recalcWidth() {
            int width = 0;
            for (ListEntry entry : this.m_6702_()) {
                if (entry.getWidth() <= width) continue;
                width = entry.getWidth();
            }
            this.f_93388_ = width;
        }

        public void updatePosition(int x0, int y0, int height) {
            this.m_93507_(x0);
            this.f_93390_ = y0;
            this.f_93391_ = y0 + height;
        }

        public void m_6305_(PoseStack stack, int xMouse, int yMouse, float partialTicks) {
            if (this.m_6702_().isEmpty()) {
                return;
            }
            super.m_6305_(stack, xMouse, yMouse, partialTicks);
            ClientUtil.beginCrop(this.f_93393_, this.f_93392_ - this.f_93393_, this.f_93390_, this.f_93391_ - this.f_93390_, true);
            if (!this.toolTip.isEmpty() && ClientUtil.mC.f_91080_ != null) {
                ClientUtil.mC.f_91080_.m_96597_(stack, this.toolTip, xMouse, yMouse);
                this.toolTip.clear();
            }
            ClientUtil.endCrop();
        }

        protected void m_239227_(@NotNull PoseStack stack, int xMouse, int yMouse, float p_238478_6_) {
            int i = this.m_5773_();
            this.hoverEntry = null;
            int currY0 = (int)((double)this.f_93390_ - this.m_93517_());
            for (int index = 0; index < i; ++index) {
                int k = currY0;
                int height = ((ListEntry)this.m_93500_(index)).getHeight();
                ListEntry e = (ListEntry)this.m_93500_(index);
                int k1 = this.m_5759_();
                int j2 = this.m_5747_();
                e.m_6311_(stack, index, k, j2, k1, height, xMouse, yMouse, this.m_5953_(xMouse, yMouse) && Objects.equals(this.m_93412_(xMouse, yMouse), (Object)e), p_238478_6_);
                currY0 += e.getHeight();
                if (!e.m_5953_(xMouse, yMouse)) continue;
                this.hoverEntry = e;
            }
        }

        public int m_5747_() {
            return this.f_93393_;
        }

        public int addEntry(@Nonnull ListEntry entry) {
            return super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        protected int m_5756_() {
            return this.f_93393_ + this.m_5759_();
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public boolean m_6375_(double xMouse, double yMouse, int button) {
            this.m_93481_(xMouse, yMouse, button);
            if (!this.m_5953_(xMouse, yMouse)) {
                return false;
            }
            if (this.hoverEntry != null) {
                if (this.hoverEntry.m_6375_(xMouse, yMouse, button)) {
                    this.m_7522_((GuiEventListener)this.hoverEntry);
                    this.m_7897_(true);
                    return true;
                }
            } else if (button == 0) {
                this.m_6205_((int)(xMouse - (double)(this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2)), (int)(yMouse - (double)this.f_93390_) + (int)this.m_93517_() - 4);
                return true;
            }
            return false;
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    public static class Image {
        protected ResourceLocation location;
        protected int u0;
        protected int v0;
        protected float imageWidth;
        protected float imageHeight;
        public int x0;
        protected int origWidth;
        protected int actualWidth;
        public int y0;
        protected int actualHeight;
        protected int origHeight;
        protected int scale;

        public Image(ResourceLocation loc, int u0, float imageWidth, int v0, float imageHeight, int scale) {
            this.location = loc;
            this.u0 = u0;
            this.imageWidth = imageWidth;
            this.actualWidth = (int)imageWidth;
            this.origWidth = (int)imageWidth;
            this.v0 = v0;
            this.imageHeight = imageHeight;
            this.actualHeight = (int)imageHeight;
            this.origHeight = (int)imageHeight;
            this.scale = scale;
        }

        public void resetScale() {
            this.actualWidth = this.origWidth;
            this.actualHeight = this.origHeight;
        }

        public int centerOnImageX(int targWidth) {
            return this.x0 + (this.actualWidth - targWidth) / 2;
        }

        public int centerOnImageY(int targHeight) {
            return this.y0 + (this.actualHeight - targHeight) / 2;
        }

        public void centerImageX(int x0, int width) {
            this.x0 = x0 + (width - this.actualWidth) / 2;
        }

        public void centerImageY(int y0, int height) {
            this.y0 = y0 + (height - this.actualHeight) / 2;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x0 && mouseX <= this.x0 + this.actualWidth && mouseY >= this.y0 && mouseY <= this.y0 + this.actualHeight;
        }

        public int getWidth() {
            return this.actualWidth;
        }

        public int getHeight() {
            return this.actualHeight;
        }

        public int getRight() {
            return this.x0 + this.getWidth();
        }

        public int getDown() {
            return this.y0 + this.getHeight();
        }

        public void moveTo(int x0, int y0) {
            this.x0 = x0;
            this.y0 = y0;
        }

        public void setImageSize(float imageWidth, float imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
        }

        public void setActualSize(int actualWidth, int actualHeight) {
            this.actualWidth = actualWidth;
            this.actualHeight = actualHeight;
        }

        public void RenderImage(PoseStack stack) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
            ClientUtil.blitImage(stack, this.x0, this.actualWidth, this.y0, this.actualHeight, this.u0, this.imageWidth, this.v0, this.imageHeight, this.scale);
            TEXTURE_MANAGER.m_118513_(this.location);
        }
    }

    public static class SimpleButton
    extends Button {
        public boolean hidden = false;

        public SimpleButton(int x, int y, int width, int height, Component textComponent, Button.OnPress onPress) {
            super(x, y, width, height, textComponent, onPress);
            this.f_93624_ = true;
        }

        public void m_6303_(PoseStack stack, int xMouse, int yMouse, float partialTicks) {
            if (this.hidden) {
                return;
            }
            Font fontrenderer = ClientUtil.mC.f_91062_;
            TEXTURE_MANAGER.m_174784_(f_93617_);
            int i = this.m_7202_(this.f_93622_);
            i = 46 + i * 20;
            ClientUtil.blitImage(stack, this.f_93620_, this.f_93618_ / 2, this.f_93621_, this.f_93619_, 0.0f, (float)this.f_93618_ / 2.0f, i, 20.0f, 256.0f);
            ClientUtil.blitImage(stack, this.f_93620_ + this.f_93618_ / 2, this.f_93618_ / 2, this.f_93621_, this.f_93619_, 200 - this.f_93618_ / 2, this.f_93618_ / 2, i, 20.0f, 256.0f);
            int j = this.getFGColor();
            SimpleButton.m_93215_((PoseStack)stack, (Font)fontrenderer, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        }
    }
}

