/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.reviveme.ReviveMe;
import invoker54.reviveme.common.api.FallenProvider;
import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.common.network.message.SyncConfigMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reviveme")
public class CapabilityEvents {
    public static final Map<UUID, ArrayList<UUID>> playerTracking = new HashMap<UUID, ArrayList<UUID>>();

    @SubscribeEvent
    public static void AttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(ReviveMe.FALLEN_LOC, (ICapabilityProvider)new FallenProvider(((Entity)event.getObject()).f_19853_));
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UUID playerUUID = event.getEntity().m_20148_();
        playerTracking.putIfAbsent(playerUUID, new ArrayList());
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.getEntity());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(playerUUID.toString(), cap.writeNBT());
        NetworkHandler.sendToPlayer(event.getEntity(), new SyncClientCapMsg((Tag)nbt));
        NetworkHandler.sendToPlayer(event.getEntity(), new SyncConfigMsg(ReviveMeConfig.serialize()));
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        playerTracking.remove(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onStartTrack(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player targPlayer = (Player)event.getTarget();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)targPlayer);
        playerTracking.putIfAbsent(targPlayer.m_20148_(), new ArrayList());
        playerTracking.get(targPlayer.m_20148_()).add(event.getEntity().m_20148_());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(targPlayer.m_20149_(), cap.writeNBT());
        NetworkHandler.sendToPlayer(event.getEntity(), new SyncClientCapMsg((Tag)nbt));
    }

    @SubscribeEvent
    public static void onStopTrack(PlayerEvent.StopTracking event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player targPlayer = (Player)event.getTarget();
        if (playerTracking.get(targPlayer.m_20148_()) == null) {
            return;
        }
        playerTracking.get(targPlayer.m_20148_()).remove(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)player);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(player.m_20149_(), cap.writeNBT());
        NetworkHandler.sendToPlayer(player, new SyncClientCapMsg((Tag)nbt));
    }
}

