/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import invoker54.reviveme.init.MobEffectInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="reviveme")
public class FallenTimerEvent {
    @SubscribeEvent
    public static void TickDownTimer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_21224_()) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (!cap.isFallen() || cap.getOtherPlayer() != null) {
            return;
        }
        if (event.player.m_7500_()) {
            cap.setFallen(false);
            event.player.m_20124_(Pose.STANDING);
            event.player.m_20331_(false);
            if (event.side.isServer()) {
                event.player.m_21219_();
                event.player.m_21153_(event.player.m_21233_());
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_(event.player.m_20149_(), cap.writeNBT());
                if (event.side == LogicalSide.SERVER) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> event.player), (Object)new SyncClientCapMsg((Tag)nbt));
                }
            }
            return;
        }
        if (!event.player.m_20147_()) {
            event.player.m_20331_(true);
        }
        if (event.player.m_20142_()) {
            event.player.m_6858_(false);
        }
        if (event.player.m_21223_() != 1.0f) {
            event.player.m_21153_(1.0f);
        }
        event.player.m_36324_().m_38705_(0);
        if (!cap.shouldDie()) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        event.player.m_20331_(false);
        event.player.m_6469_(cap.getDamageSource().m_19381_().m_19380_(), Float.MAX_VALUE);
    }

    @SubscribeEvent
    public static void TickProgress(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)event.player);
        if (cap.getOtherPlayer() == null) {
            return;
        }
        if (cap.getProgress() < 1.0f) {
            return;
        }
        if (!cap.isFallen()) {
            return;
        }
        Player fellPlayer = event.player;
        if (event.side == LogicalSide.SERVER) {
            ServerPlayer reviver = fellPlayer.m_20194_().m_6846_().m_11259_(cap.getOtherPlayer());
            FallenTimerEvent.takeFromReviver((Player)reviver, fellPlayer);
        }
        FallenTimerEvent.revivePlayer(fellPlayer);
    }

    public static void takeFromReviver(Player reviver, Player fallen) {
        if (reviver == null) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)fallen);
        if (!reviver.m_7500_()) {
            block0 : switch (cap.getPenaltyType()) {
                case NONE: {
                    break;
                }
                case HEALTH: {
                    reviver.m_21153_(Math.max(1.0f, reviver.m_21223_() - cap.getPenaltyAmount((LivingEntity)reviver)));
                    break;
                }
                case EXPERIENCE: {
                    reviver.m_6749_(-Math.round(cap.getPenaltyAmount((LivingEntity)reviver)));
                    break;
                }
                case FOOD: {
                    FoodData food = reviver.m_36324_();
                    float amountNeeded = cap.getPenaltyAmount((LivingEntity)reviver);
                    float saturation = food.m_38722_();
                    if (saturation > 0.0f) {
                        food.m_38717_(Math.max(0.0f, food.m_38722_() - amountNeeded));
                    }
                    amountNeeded = Math.max(0.0f, amountNeeded - saturation);
                    food.m_38705_((int)((float)food.m_38702_() - amountNeeded));
                    break;
                }
                case ITEM: {
                    int itemAmount = (int)cap.getPenaltyAmount((LivingEntity)reviver);
                    Item penaltyItem = cap.getPenaltyItem().m_41720_();
                    Inventory playerInv = reviver.m_150109_();
                    for (int a = 0; a < playerInv.m_6643_(); ++a) {
                        ItemStack currStack = playerInv.m_8020_(a);
                        if (currStack.m_150930_(penaltyItem)) {
                            int takeAway = Math.min(itemAmount, currStack.m_41613_());
                            itemAmount -= takeAway;
                            currStack.m_41764_(currStack.m_41613_() - takeAway);
                        }
                        if (itemAmount == 0) break block0;
                    }
                    break;
                }
            }
        }
    }

    public static void revivePlayer(Player fallen) {
        FallenCapability cap = FallenCapability.GetFallCap((LivingEntity)fallen);
        float healAmount = ReviveMeConfig.revivedHealth == 0.0 ? fallen.m_21233_() : (ReviveMeConfig.revivedHealth > 0.0 && ReviveMeConfig.revivedHealth < 1.0 ? (float)((double)fallen.m_21233_() * ReviveMeConfig.revivedHealth) : ReviveMeConfig.revivedHealth.floatValue());
        fallen.m_21153_(healAmount);
        float foodAmount = ReviveMeConfig.revivedFood == 0.0 ? 40.0f : (ReviveMeConfig.revivedFood > 0.0 && ReviveMeConfig.revivedFood < 1.0 ? (float)(40.0 * ReviveMeConfig.revivedFood) : ReviveMeConfig.revivedFood.floatValue());
        fallen.m_36324_().m_38707_((int)Math.min(20.0f, foodAmount), 0.0f);
        fallen.m_36324_().m_38707_(1, Math.max(0.0f, foodAmount - 20.0f) / 2.0f);
        fallen.m_21219_();
        if (cap.usedChance() || cap.usedSacrificedItems()) {
            fallen.m_7292_(new MobEffectInstance(MobEffectInit.FALLEN_EFFECT, (int)(ReviveMeConfig.fallenPenaltyTimer * 20.0)));
        }
        fallen.m_20331_(false);
        if (ReviveMeConfig.reviveInvulnTime != 0.0) {
            fallen.m_7292_(new MobEffectInstance(MobEffects.f_19606_, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
            fallen.m_7292_(new MobEffectInstance(MobEffects.f_19607_, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
        }
        cap.setFallen(false);
        fallen.m_20124_(Pose.STANDING);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(fallen.m_20149_(), cap.writeNBT());
        if (!fallen.f_19853_.f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> fallen), (Object)new SyncClientCapMsg((Tag)nbt));
        }
    }
}

