/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="reviveme")
public class InteractionEvents {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void useOnPlayer(PlayerInteractEvent.EntityInteract event) {
        if (!event.getSide().isServer()) {
            return;
        }
        Player revplayer = event.getEntity();
        FallenCapability myCap = FallenCapability.GetFallCap((LivingEntity)revplayer);
        if (myCap.isFallen()) {
            return;
        }
        if (revplayer.m_20163_()) {
            return;
        }
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player targPlayer = (Player)event.getTarget();
        FallenCapability targCap = FallenCapability.GetFallCap((LivingEntity)targPlayer);
        if (!targCap.isFallen() || targCap.getOtherPlayer() != null) {
            return;
        }
        if (!targCap.hasEnough(revplayer)) {
            return;
        }
        targCap.setProgress((int)revplayer.f_19853_.m_46467_(), ReviveMeConfig.reviveTime);
        targCap.setOtherPlayer(revplayer.m_20148_());
        myCap.setProgress((int)revplayer.f_19853_.m_46467_(), ReviveMeConfig.reviveTime);
        myCap.setOtherPlayer(targPlayer.m_20148_());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(revplayer.m_20149_(), myCap.writeNBT());
        nbt.m_128365_(targPlayer.m_20149_(), targCap.writeNBT());
        NetworkHandler.sendToPlayer(targPlayer, new SyncClientCapMsg((Tag)nbt));
        NetworkHandler.sendToPlayer(revplayer, new SyncClientCapMsg((Tag)nbt));
    }

    @SubscribeEvent
    public static void cancelItemUse(LivingEntityUseItemEvent.Tick event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap(event.getEntity());
        if (cap.isFallen()) {
            return;
        }
        if (cap.getOtherPlayer() == null) {
            return;
        }
        event.setCanceled(true);
        event.setDuration(0);
    }

    @SubscribeEvent
    public static void stopItemUse(LivingEntityUseItemEvent.Start event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        FallenCapability cap = FallenCapability.GetFallCap(event.getEntity());
        if (cap.isFallen()) {
            return;
        }
        if (cap.getOtherPlayer() == null) {
            return;
        }
        event.setCanceled(true);
        event.setDuration(0);
    }
}

