/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3829;
import net.minecraft.class_3965;

public abstract class AbstractTradingBlockEntity
extends class_2586
implements class_3829 {
    protected int transaction;
    protected UUID owner = class_156.field_25140;
    protected class_1799 selling = class_1799.field_8037;
    protected int storedSellingItems = 0;
    protected int maxStorage = 3456;

    public AbstractTradingBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.transaction = compoundTag.method_10550("transactions");
        this.owner = compoundTag.method_25926("owner");
        this.selling = class_1799.method_7915((class_2487)compoundTag.method_10562("selling"));
        this.storedSellingItems = compoundTag.method_10550("storedItems");
        this.maxStorage = compoundTag.method_10550("maxStorage");
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569("transactions", this.transaction);
        compoundTag.method_25927("owner", this.owner);
        compoundTag.method_10566("selling", (class_2520)this.selling.method_7953(new class_2487()));
        compoundTag.method_10569("storedItems", this.storedSellingItems);
        compoundTag.method_10569("maxStorage", this.maxStorage);
    }

    public void method_5448() {
        this.transaction = 0;
        this.storedSellingItems = 0;
        this.selling = class_1799.field_8037;
    }

    protected void markUpdated() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public abstract boolean attemptPurchase(class_1657 var1, class_1799 var2, boolean var3);

    public abstract void sendInformationToOwner(class_1657 var1);

    public abstract class_1269 interactWithTradingBlock(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_1268 var5, class_3965 var6);

    public abstract void userLeftClickTradingBlock(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4);

    public int putItemIntoShop(class_1799 item) {
        if (!item.method_7960()) {
            if (this.storedSellingItems > this.maxStorage) {
                return 0;
            }
            int itemsInserted = Math.min(item.method_7947(), this.remainingItemStorage());
            this.storedSellingItems += itemsInserted;
            item.method_7934(itemsInserted);
            return itemsInserted;
        }
        return 0;
    }

    public void extractItemsFromShop(class_1937 level, class_2338 pos) {
        int itemsToTake = Math.min(64, this.storedSellingItems);
        class_1799 selling = this.getSelling().method_7972();
        selling.method_7939(itemsToTake);
        class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)selling);
        this.storedSellingItems -= itemsToTake;
    }

    public void clearShop(class_3965 result) {
        for (class_1799 stack : this.dropItems()) {
            class_2248.method_36992((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2350)result.method_17780(), (class_1799)stack);
        }
        this.selling = class_1799.field_8037;
        this.storedSellingItems = 0;
        this.markUpdated();
    }

    public class_2371<class_1799> dropItems() {
        class_2371 list = class_2371.method_10211();
        int itemsStored = this.storedSellingItems;
        int maxStackSize = this.selling.method_7914();
        while (itemsStored != 0) {
            class_1799 copy = this.selling.method_7972();
            if (itemsStored >= maxStackSize) {
                copy.method_7939(maxStackSize);
                list.add((Object)copy);
                itemsStored -= maxStackSize;
                continue;
            }
            copy.method_7939(itemsStored);
            list.add((Object)copy);
            itemsStored -= itemsStored;
        }
        return list;
    }

    public void addSellingItem(class_1799 item) {
        this.selling = item;
        this.markUpdated();
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public class_1799 getSelling() {
        return this.selling;
    }

    public int remainingItemStorage() {
        return this.maxStorage - this.storedSellingItems;
    }
}

