/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.AbstractTradingBlock;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class BarteringBlockEntity
extends AbstractTradingBlockEntity {
    class_1799 currency = class_1799.field_8037;
    int currencyStored = 0;

    public BarteringBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ShoppyMod.BARTING_STATION_ENTITY, blockPos, blockState);
    }

    public BarteringBlockEntity(class_2591<?> blockEntity, class_2338 blockPos, class_2680 blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.currency = class_1799.method_7915((class_2487)compoundTag.method_10562("currency"));
        this.currencyStored = compoundTag.method_10550("storedCurrency");
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10566("currency", (class_2520)this.currency.method_7953(new class_2487()));
        compoundTag.method_10569("storedCurrency", this.currencyStored);
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.currency = class_1799.field_8037;
        this.currencyStored = 0;
        this.markUpdated();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        tag.method_10566("currency", (class_2520)this.currency.method_7953(new class_2487()));
        tag.method_10566("selling", (class_2520)this.selling.method_7953(new class_2487()));
        tag.method_25927("owner", this.owner);
        return tag;
    }

    public void addCurrencyItem(class_1799 item) {
        this.currency = item;
        this.markUpdated();
    }

    @Override
    public void clearShop(class_3965 result) {
        super.clearShop(result);
        this.currency = class_1799.field_8037;
        this.currencyStored = 0;
        this.markUpdated();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean attemptPurchase(class_1657 player, class_1799 currencyInHand, boolean creativeBlock) {
        class_3222 owner = this.field_11863.method_8503().method_3760().method_14602(this.owner);
        if (!class_1799.method_31577((class_1799)currencyInHand, (class_1799)this.currency)) {
            class_2588 component = new class_2588("barter.purchase.no_held_item");
            component.method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)component, class_156.field_25140);
            return false;
        }
        int price = this.currency.method_7947();
        if (currencyInHand.method_7947() < price) {
            class_5250 required = new class_2585("x" + price).method_10862(ShoppyMod.VARIABLE_STYLE);
            class_5250 had = new class_2585("x" + currencyInHand.method_7947()).method_10862(ShoppyMod.VARIABLE_STYLE);
            class_2588 component = new class_2588("barter.purchase.not_enough_items", new Object[]{required, had});
            component.method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)component, class_156.field_25140);
            return false;
        }
        int amountToGive = this.selling.method_7947();
        if (amountToGive > this.storedSellingItems) {
            class_5250 buyerMsg = new class_2588("barter.purchase.shop_empty").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)buyerMsg, class_156.field_25140);
            if (owner == null) return false;
            class_5250 location = new class_2588("X: %s, Y: %s, Z: %s", new Object[]{this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()}).method_10862(ShoppyMod.VARIABLE_STYLE);
            class_5250 ownerMsg = new class_2588("barter.purchase.owner.shop_empty", new Object[]{location}).method_10862(ShoppyMod.CONSTANTS_STYLE);
            owner.method_9203((class_2561)ownerMsg, class_156.field_25140);
            return false;
        }
        if (this.remainingCurrencySpaces() <= 0 && !creativeBlock) {
            class_5250 buyerMsg = new class_2588("barter.purchase.currency_full", new Object[]{this.currency.method_7954()}).method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)buyerMsg, class_156.field_25140);
            if (owner == null) return false;
            if (creativeBlock) return false;
            class_5250 location = new class_2588("X: %s, Y: %s, Z: %s", new Object[]{this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()}).method_10862(ShoppyMod.VARIABLE_STYLE);
            class_5250 ownerMsg = new class_2588("barter.purchase.owner.currency_full", new Object[]{location}).method_10862(ShoppyMod.CONSTANTS_STYLE);
            owner.method_9203((class_2561)ownerMsg, class_156.field_25140);
            return false;
        }
        if (player.method_31548().method_7376() == -1) {
            class_5250 component = new class_2588("common.purchase.full_inventory").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)component, class_156.field_25140);
            return false;
        }
        currencyInHand.method_7934(price);
        player.method_7270(this.selling.method_7972());
        class_5250 buyer = new class_2588("barter.purchase.transaction_success", new Object[]{this.selling.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
        player.method_9203((class_2561)buyer, class_156.field_25140);
        if (!creativeBlock) {
            this.storedSellingItems -= amountToGive;
            this.currencyStored += price;
        }
        if (owner == null) return true;
        class_5250 sellerMsg = new class_2588("barter.purchase.owner.transaction_success", new Object[]{player.method_5476(), this.selling.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
        owner.method_9203((class_2561)sellerMsg, class_156.field_25140);
        return true;
    }

    @Override
    public class_2371<class_1799> dropItems() {
        class_2371 list = class_2371.method_10211();
        list.addAll(super.dropItems());
        int currency = this.currencyStored;
        int maxStackSize = this.currency.method_7914();
        while (currency != 0) {
            class_1799 copy = this.currency.method_7972();
            if (currency >= maxStackSize) {
                copy.method_7939(maxStackSize);
                list.add((Object)copy);
                currency -= maxStackSize;
                continue;
            }
            copy.method_7939(currency);
            list.add((Object)copy);
            currency -= currency;
        }
        return list;
    }

    public int remainingCurrencySpaces() {
        return this.maxStorage - this.currencyStored;
    }

    @Override
    public int remainingItemStorage() {
        return this.maxStorage - this.storedSellingItems;
    }

    public class_1799 getCurrency() {
        return this.currency;
    }

    @Override
    public void sendInformationToOwner(class_1657 player) {
        class_5250 component = new class_2588("barter.information.owner.extraction").method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_9203((class_2561)component, class_156.field_25140);
        class_5250 profits = new class_2585("" + this.currencyStored).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 translatedProfits = new class_2588("barter.information.owner.profits", new Object[]{profits}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        class_5250 storedItems = new class_2585("" + this.storedSellingItems).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 toBeSold = new class_2588("barter.information.owner.barter", new Object[]{storedItems}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_9203((class_2561)translatedProfits, class_156.field_25140);
        player.method_9203((class_2561)toBeSold, class_156.field_25140);
    }

    @Override
    public class_1269 interactWithTradingBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_243 hit = blockHitResult.method_17784().method_1020(class_243.method_24954((class_2382)blockPos));
        class_1799 item = player.method_6047();
        if (player.method_18276() && hit.method_10214() > 0.5) {
            this.clearShop(blockHitResult);
            return class_1269.field_5812;
        }
        boolean sameItem = this.getCurrency().method_7962(item);
        if (hit.method_10214() <= 0.5 && (this.getCurrency().method_7960() || sameItem)) {
            if (item.method_7947() == 1 && sameItem) {
                if (this.currency.method_7947() < this.currency.method_7914()) {
                    this.currency.method_7939(this.currency.method_7947() + 1);
                }
                this.markUpdated();
                return class_1269.field_5812;
            }
            this.addCurrencyItem(item.method_7972());
            class_5250 setup = new class_2588("barter.setup.owner.add_currency", new Object[]{item.method_7954()}).method_10862(ShoppyMod.CONSTANTS_STYLE);
            player.method_9203((class_2561)setup, class_156.field_25140);
            return class_1269.field_5812;
        }
        if (hit.method_10214() > 0.5) {
            if (this.getSelling().method_7960()) {
                this.addSellingItem(item.method_7972());
                class_5250 setup = new class_2588("barter.setup.owner.add_selling", new Object[]{item.method_7954()}).method_10862(ShoppyMod.CONSTANTS_STYLE);
                player.method_9203((class_2561)setup, class_156.field_25140);
            } else if (class_1799.method_31577((class_1799)item, (class_1799)this.getSelling())) {
                this.putItemIntoShop(item);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    @Override
    public void userLeftClickTradingBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        class_5250 amountBeingSold = new class_2585("x" + this.getSelling().method_7947()).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 itemBeingSold = this.getSelling().method_7954().method_27661().method_27694(style -> {
            style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(this.getSelling())));
            return style;
        });
        class_5250 currencyAmount = new class_2585("x" + this.getCurrency().method_7947()).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 itemBeingTraded = this.getCurrency().method_7954().method_27661().method_27694(style -> {
            style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(this.getCurrency())));
            return style;
        });
        class_5250 component = new class_2588("barter.information.user.selling_info", new Object[]{amountBeingSold, itemBeingSold, currencyAmount, itemBeingTraded}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_9203((class_2561)component, class_156.field_25140);
    }

    @Override
    public void extractItemsFromShop(class_1937 level, class_2338 pos) {
        if (this.remainingCurrencySpaces() != this.maxStorage) {
            int itemsToTake = Math.min(64, this.currencyStored);
            class_1799 currency = this.getCurrency().method_7972();
            currency.method_7939(itemsToTake);
            AbstractTradingBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)currency);
            this.currencyStored -= itemsToTake;
        } else {
            super.extractItemsFromShop(level, pos);
        }
    }
}

