/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.octoecon.api.Economy;
import com.epherical.octoecon.api.user.UniqueUser;
import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ShopBlockEntity
extends AbstractTradingBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean isBuyingFromPlayer = false;
    private int price = 0;
    private Economy economy = ShoppyMod.economyInstance;

    public ShopBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ShoppyMod.SHOP_BLOCK_ENTITY, blockPos, blockState);
    }

    public ShopBlockEntity(class_2591<?> blockEntity, class_2338 blockPos, class_2680 blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.isBuyingFromPlayer = compoundTag.method_10577("buyingFromPlayer");
        this.price = compoundTag.method_10550("price");
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10556("buyingFromPlayer", this.isBuyingFromPlayer);
        compoundTag.method_10569("price", this.price);
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.isBuyingFromPlayer = false;
        this.markUpdated();
    }

    @Override
    public boolean attemptPurchase(class_1657 player, class_1799 currencyInHand, boolean creativeBlock) {
        class_3222 owner = this.field_11863.method_8503().method_3760().method_14602(this.owner);
        if (this.economy == null) {
            class_5250 noEconomy = new class_2588("shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)noEconomy, class_156.field_25140);
            return false;
        }
        UniqueUser ownerUser = this.economy.getOrCreatePlayerAccount(this.owner);
        UniqueUser user = this.economy.getOrCreatePlayerAccount(player.method_5667());
        if (user != null && ownerUser != null) {
            if (this.isBuyingFromPlayer) {
                if (creativeBlock && user.hasAmount(this.economy.getDefaultCurrency(), this.price)) {
                    return this.shopBuyFromPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, true);
                }
                if (ownerUser.hasAmount(this.economy.getDefaultCurrency(), this.price)) {
                    return this.shopBuyFromPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, false);
                }
                class_5250 msg = new class_2588("shop.buying.not_enough_funds").method_10862(ShoppyMod.ERROR_STYLE);
                player.method_9203((class_2561)msg, class_156.field_25140);
                return false;
            }
            if (creativeBlock && user.hasAmount(this.economy.getDefaultCurrency(), this.price)) {
                return this.shopSellToPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, true);
            }
            if (user.hasAmount(this.economy.getDefaultCurrency(), this.price)) {
                return this.shopSellToPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, false);
            }
            class_5250 notEnoughMoney = new class_2588("shop.purchase.not_enough_money").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)notEnoughMoney, class_156.field_25140);
            return false;
        }
        class_5250 noAccounts = new class_2588("shop.purchase.no_account").method_10862(ShoppyMod.ERROR_STYLE);
        player.method_9203((class_2561)noAccounts, class_156.field_25140);
        LOGGER.error("Missing accounts for a shop transaction!! Player involved {}, UUIDs involved (PURCHASER {}) (OWNER {})", (Object)player.method_5820(), (Object)player.method_5667(), (Object)this.getOwner());
        LOGGER.error("This could be a result of an economy implementation being unable to handle offline players?");
        return false;
    }

    private boolean shopSellToPlayer(class_1657 player, class_1799 currencyInHand, UniqueUser ownerUser, UniqueUser playerShopping, class_1657 owner, boolean creative) {
        int amountToGive = this.selling.method_7947();
        if (amountToGive > this.storedSellingItems) {
            class_5250 buyerMsg = new class_2588("shop.purchase.shop_empty").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)buyerMsg, class_156.field_25140);
            if (owner != null) {
                class_5250 location = new class_2588("X: %s, Y: %s, Z: %s", new Object[]{this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()}).method_10862(ShoppyMod.VARIABLE_STYLE);
                class_5250 ownerMsg = new class_2588("shop.purchase.owner.shop_empty", new Object[]{location}).method_10862(ShoppyMod.CONSTANTS_STYLE);
                owner.method_9203((class_2561)ownerMsg, class_156.field_25140);
            }
            return false;
        }
        if (player.method_31548().method_7376() == -1) {
            class_5250 component = new class_2588("common.purchase.full_inventory").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)component, class_156.field_25140);
            return false;
        }
        player.method_7270(this.selling.method_7972());
        if (creative) {
            playerShopping.withdrawMoney(this.economy.getDefaultCurrency(), this.price, "creative shop purchase");
        } else {
            playerShopping.sendTo(ownerUser, this.economy.getDefaultCurrency(), this.price);
            this.storedSellingItems -= amountToGive;
        }
        class_5250 buyer = new class_2588("shop.purchase.transaction_success", new Object[]{this.selling.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
        player.method_9203((class_2561)buyer, class_156.field_25140);
        if (owner != null) {
            class_5250 sellerMsg = new class_2588("shop.purchase.owner.transaction_success", new Object[]{player.method_5476(), this.selling.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
            owner.method_9203((class_2561)sellerMsg, class_156.field_25140);
        }
        return true;
    }

    private boolean shopBuyFromPlayer(class_1657 player, class_1799 currencyInHand, UniqueUser ownerUser, UniqueUser playerShopping, class_1657 owner, boolean creative) {
        int moneyToGiveToPlayer = this.price;
        int storageLeft = this.remainingItemStorage() - this.selling.method_7947();
        if (storageLeft < 0) {
            class_5250 notEnoughSpace = new class_2588("shop.buying.full").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)notEnoughSpace, class_156.field_25140);
            return false;
        }
        if (currencyInHand.method_7960() || !class_1799.method_31577((class_1799)currencyInHand, (class_1799)this.selling)) {
            class_5250 notSameItem = new class_2588("shop.buying.no_held_item").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)notSameItem, class_156.field_25140);
            return false;
        }
        if (currencyInHand.method_7947() < this.selling.method_7947()) {
            class_5250 notEnough = new class_2588("shop.buying.not_enough_items").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)notEnough, class_156.field_25140);
            return false;
        }
        currencyInHand.method_7934(this.selling.method_7947());
        if (creative) {
            playerShopping.depositMoney(this.economy.getDefaultCurrency(), moneyToGiveToPlayer, "creative mode shop");
        } else {
            ownerUser.sendTo(playerShopping, this.economy.getDefaultCurrency(), moneyToGiveToPlayer);
            this.storedSellingItems += this.selling.method_7947();
        }
        class_2561 priceComp = this.economy.getDefaultCurrency().format(this.price);
        class_5250 seller = new class_2588("shop.buying.player.success", new Object[]{this.selling.method_7954(), priceComp}).method_10862(ShoppyMod.APPROVAL_STYLE);
        player.method_9203((class_2561)seller, class_156.field_25140);
        if (owner != null) {
            class_5250 buyerMsg = new class_2588("shop.buying.owner.success", new Object[]{player.method_5476(), this.selling.method_7954(), priceComp}).method_10862(ShoppyMod.APPROVAL_STYLE);
            owner.method_9203((class_2561)buyerMsg, class_156.field_25140);
        }
        return true;
    }

    @Override
    public void sendInformationToOwner(class_1657 player) {
        if (this.economy == null) {
            class_5250 noEconomy = new class_2588("shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)noEconomy, class_156.field_25140);
            return;
        }
        class_5250 type = this.isBuyingFromPlayer ? new class_2588("shop.status.buy").method_10862(ShoppyMod.VARIABLE_STYLE) : new class_2588("shop.status.sell").method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 items = new class_2585("" + this.storedSellingItems).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 contents = new class_2588("shop.information.owner.contents", new Object[]{type, this.selling.method_7954(), items}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_9203((class_2561)contents, class_156.field_25140);
    }

    @Override
    public class_1269 interactWithTradingBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_243 hit = blockHitResult.method_17784().method_1020(class_243.method_24954((class_2382)blockPos));
        class_1799 item = player.method_6047();
        if (this.economy == null) {
            class_5250 noEconomy = new class_2588("shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)noEconomy, class_156.field_25140);
            return class_1269.field_21466;
        }
        if (hit.method_10214() > 0.5 && player.method_18276()) {
            this.clearShop(blockHitResult);
            return class_1269.field_5812;
        }
        if (hit.method_10214() > 0.5) {
            if (this.getSelling().method_7960()) {
                this.addSellingItem(item.method_7972());
                class_5250 message = this.isBuyingFromPlayer ? new class_2588("shop.setup.owner.add_buying", new Object[]{item.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE) : new class_2588("shop.setup.owner.add_selling", new Object[]{item.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
                player.method_9203((class_2561)message, class_156.field_25140);
            } else if (class_1799.method_31577((class_1799)item, (class_1799)this.getSelling())) {
                this.putItemIntoShop(item);
            }
            return class_1269.field_5812;
        }
        if (hit.method_10214() <= 0.5) {
            if (player.method_18276()) {
                this.updateTradingStatus(!this.isBuyingFromPlayer);
                class_5250 status = this.isBuyingFromPlayer ? new class_2588("shop.status.buying").method_10862(ShoppyMod.VARIABLE_STYLE) : new class_2588("shop.status.selling").method_10862(ShoppyMod.VARIABLE_STYLE);
                class_5250 update = new class_2588("shop.status.update", new Object[]{status}).method_10862(ShoppyMod.CONSTANTS_STYLE);
                player.method_9203((class_2561)update, class_156.field_25140);
            } else {
                class_5250 message = new class_2588("shop.pricing.owner.update").method_10862(ShoppyMod.APPROVAL_STYLE);
                player.method_9203((class_2561)message, class_156.field_25140);
                ShoppyMod.awaitingResponse.put(player.method_5667(), this);
            }
        }
        return class_1269.field_21466;
    }

    @Override
    public void userLeftClickTradingBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        if (this.economy == null) {
            class_5250 noEconomy = new class_2588("shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_9203((class_2561)noEconomy, class_156.field_25140);
            return;
        }
        class_5250 amountBeingSold = new class_2585("x" + this.getSelling().method_7947()).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 itemBeingSold = this.getSelling().method_7954().method_27661().method_27694(style -> {
            style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(this.getSelling())));
            return style;
        });
        class_2561 currencyAmount = this.economy.getDefaultCurrency().format(this.price);
        class_5250 component = this.isBuyingFromPlayer ? new class_2588("shop.information.user.buying_info", new Object[]{amountBeingSold, itemBeingSold, currencyAmount}).method_10862(ShoppyMod.CONSTANTS_STYLE) : new class_2588("shop.information.user.selling_info", new Object[]{amountBeingSold, itemBeingSold, currencyAmount}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_9203((class_2561)component, class_156.field_25140);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        tag.method_10556("buyingFromPlayer", this.isBuyingFromPlayer);
        tag.method_10566("selling", (class_2520)this.selling.method_7953(new class_2487()));
        tag.method_10569("price", this.price);
        tag.method_25927("owner", this.owner);
        return tag;
    }

    private void updateTradingStatus(boolean value) {
        this.isBuyingFromPlayer = value;
        this.markUpdated();
    }

    public void setPrice(int price) {
        this.price = price;
        this.markUpdated();
    }

    public int getPrice() {
        return this.price;
    }

    public boolean isBuyingFromPlayer() {
        return this.isBuyingFromPlayer;
    }
}

