/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.octoecon.api.user.UniqueUser;
import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import com.epherical.shoppy.menu.shopping.ShoppingMenu;
import com.epherical.shoppy.menu.shopping.ShoppingMenuOwner;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ShopBlockEntity
extends AbstractTradingBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean isBuyingFromPlayer = false;
    private int price = 0;
    protected final class_3913 data = new class_3913(){

        public int method_17390(int data) {
            return switch (data) {
                case 0 -> ShopBlockEntity.this.selling.method_7947();
                case 1 -> ShopBlockEntity.this.storedSellingItems;
                case 2 -> ShopBlockEntity.this.price;
                case 3 -> {
                    if (ShopBlockEntity.this.isBuyingFromPlayer) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int key, int value) {
            switch (key) {
                case 0: {
                    ShopBlockEntity.this.selling.method_7939(value);
                    break;
                }
                case 1: {
                    ShopBlockEntity.this.storedSellingItems = value;
                    break;
                }
                case 2: {
                    ShopBlockEntity.this.price = value;
                    break;
                }
                case 3: {
                    ShopBlockEntity.this.isBuyingFromPlayer = value != 0;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public ShopBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ShoppyMod.SHOP_BLOCK_ENTITY, blockPos, blockState);
    }

    public ShopBlockEntity(class_2591<?> blockEntity, class_2338 blockPos, class_2680 blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.isBuyingFromPlayer = compoundTag.method_10577("buyingFromPlayer");
        this.price = compoundTag.method_10550("price");
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10556("buyingFromPlayer", this.isBuyingFromPlayer);
        compoundTag.method_10569("price", this.price);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.shoppy.shop_block");
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.isBuyingFromPlayer = false;
        this.markUpdated();
    }

    @Override
    public boolean attemptPurchase(class_1657 player, boolean creativeBlock) {
        class_1799 currencyInHand = class_1799.field_8037;
        try {
            class_1661 inventory = player.method_31548();
            currencyInHand = inventory.method_5438(inventory.method_7395(this.selling));
        }
        catch (ArrayIndexOutOfBoundsException inventory) {
            // empty catch block
        }
        class_3222 owner = this.field_11863.method_8503().method_3760().method_14602(this.owner);
        if (ShoppyMod.economyInstance == null) {
            class_5250 noEconomy = class_2561.method_43471((String)"shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)noEconomy);
            return false;
        }
        UniqueUser ownerUser = ShoppyMod.economyInstance.getOrCreatePlayerAccount(this.owner);
        UniqueUser user = ShoppyMod.economyInstance.getOrCreatePlayerAccount(player.method_5667());
        if (user != null && ownerUser != null) {
            if (this.isBuyingFromPlayer) {
                if (creativeBlock && user.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), this.price)) {
                    return this.shopBuyFromPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, true);
                }
                if (ownerUser.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), this.price)) {
                    return this.shopBuyFromPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, false);
                }
                class_5250 msg = class_2561.method_43471((String)"shop.buying.not_enough_funds").method_10862(ShoppyMod.ERROR_STYLE);
                player.method_43496((class_2561)msg);
                return false;
            }
            if (creativeBlock && user.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), this.price)) {
                return this.shopSellToPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, true);
            }
            if (user.hasAmount(ShoppyMod.economyInstance.getDefaultCurrency(), this.price)) {
                return this.shopSellToPlayer(player, currencyInHand, ownerUser, user, (class_1657)owner, false);
            }
            class_5250 notEnoughMoney = class_2561.method_43471((String)"shop.purchase.not_enough_money").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)notEnoughMoney);
            return false;
        }
        class_5250 noAccounts = class_2561.method_43471((String)"shop.purchase.no_account").method_10862(ShoppyMod.ERROR_STYLE);
        player.method_43496((class_2561)noAccounts);
        LOGGER.error("Missing accounts for a shop transaction!! Player involved {}, UUIDs involved (PURCHASER {}) (OWNER {})", (Object)player.method_5820(), (Object)player.method_5667(), (Object)this.getOwner());
        LOGGER.error("This could be a result of an ShoppyMod.economyInstance implementation being unable to handle offline players?");
        return false;
    }

    private boolean shopSellToPlayer(class_1657 player, class_1799 currencyInHand, UniqueUser ownerUser, UniqueUser playerShopping, class_1657 owner, boolean creative) {
        int amountToGive = this.selling.method_7947();
        if (amountToGive > this.storedSellingItems) {
            class_5250 buyerMsg = class_2561.method_43471((String)"shop.purchase.shop_empty").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)buyerMsg);
            if (owner != null) {
                class_5250 location = class_2561.method_43469((String)"X: %s, Y: %s, Z: %s", (Object[])new Object[]{this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()}).method_10862(ShoppyMod.VARIABLE_STYLE);
                class_5250 ownerMsg = class_2561.method_43469((String)"shop.purchase.owner.shop_empty", (Object[])new Object[]{location}).method_10862(ShoppyMod.CONSTANTS_STYLE);
                owner.method_43496((class_2561)ownerMsg);
            }
            return false;
        }
        if (player.method_31548().method_7376() == -1) {
            class_5250 component = class_2561.method_43471((String)"common.purchase.full_inventory").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)component);
            return false;
        }
        player.method_7270(this.selling.method_7972());
        if (creative) {
            playerShopping.withdrawMoney(ShoppyMod.economyInstance.getDefaultCurrency(), this.price, "creative shop purchase");
        } else {
            playerShopping.sendTo(ownerUser, ShoppyMod.economyInstance.getDefaultCurrency(), this.price);
            this.storedSellingItems -= amountToGive;
        }
        class_5250 buyer = class_2561.method_43469((String)"shop.purchase.transaction_success", (Object[])new Object[]{this.selling.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
        player.method_43496((class_2561)buyer);
        if (owner != null) {
            class_5250 sellerMsg = class_2561.method_43469((String)"shop.purchase.owner.transaction_success", (Object[])new Object[]{player.method_5476(), this.selling.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
            owner.method_43496((class_2561)sellerMsg);
        }
        return true;
    }

    private boolean shopBuyFromPlayer(class_1657 player, class_1799 currencyInHand, UniqueUser ownerUser, UniqueUser playerShopping, class_1657 owner, boolean creative) {
        int moneyToGiveToPlayer = this.price;
        int storageLeft = this.remainingItemStorage() - this.selling.method_7947();
        if (storageLeft < 0) {
            class_5250 notEnoughSpace = class_2561.method_43471((String)"shop.buying.full").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)notEnoughSpace);
            return false;
        }
        if (currencyInHand.method_7960() || !class_1799.method_31577((class_1799)currencyInHand, (class_1799)this.selling)) {
            class_5250 notSameItem = class_2561.method_43471((String)"shop.buying.no_held_item").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)notSameItem);
            return false;
        }
        if (currencyInHand.method_7947() < this.selling.method_7947()) {
            class_5250 notEnough = class_2561.method_43471((String)"shop.buying.not_enough_items").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)notEnough);
            return false;
        }
        currencyInHand.method_7934(this.selling.method_7947());
        if (creative) {
            playerShopping.depositMoney(ShoppyMod.economyInstance.getDefaultCurrency(), moneyToGiveToPlayer, "creative mode shop");
        } else {
            ownerUser.sendTo(playerShopping, ShoppyMod.economyInstance.getDefaultCurrency(), moneyToGiveToPlayer);
            this.storedSellingItems += this.selling.method_7947();
        }
        class_2561 priceComp = ShoppyMod.economyInstance.getDefaultCurrency().format(this.price);
        class_5250 seller = class_2561.method_43469((String)"shop.buying.player.success", (Object[])new Object[]{this.selling.method_7954(), priceComp}).method_10862(ShoppyMod.APPROVAL_STYLE);
        player.method_43496((class_2561)seller);
        if (owner != null) {
            class_5250 buyerMsg = class_2561.method_43469((String)"shop.buying.owner.success", (Object[])new Object[]{player.method_5476(), this.selling.method_7954(), priceComp}).method_10862(ShoppyMod.APPROVAL_STYLE);
            owner.method_43496((class_2561)buyerMsg);
        }
        return true;
    }

    @Override
    public void sendInformationToOwner(class_1657 player) {
        if (ShoppyMod.economyInstance == null) {
            class_5250 noEconomy = class_2561.method_43471((String)"shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)noEconomy);
            return;
        }
        class_5250 type = this.isBuyingFromPlayer ? class_2561.method_43471((String)"shop.status.buy").method_10862(ShoppyMod.VARIABLE_STYLE) : class_2561.method_43471((String)"shop.status.sell").method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 items = class_2561.method_43470((String)("" + this.storedSellingItems)).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 contents = class_2561.method_43469((String)"shop.information.owner.contents", (Object[])new Object[]{type, this.selling.method_7954(), items}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_43496((class_2561)contents);
    }

    @Override
    public class_1269 interactWithTradingBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_243 hit = blockHitResult.method_17784().method_1020(class_243.method_24954((class_2382)blockPos));
        class_1799 item = player.method_6047();
        if (ShoppyMod.economyInstance == null) {
            class_5250 noEconomy = class_2561.method_43471((String)"shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)noEconomy);
            return class_1269.field_21466;
        }
        if (hit.method_10214() > 0.5 && player.method_18276()) {
            this.clearShop(blockHitResult);
            return class_1269.field_5812;
        }
        if (hit.method_10214() > 0.5) {
            if (this.getSelling().method_7960()) {
                this.addSellingItem(item.method_7972());
                class_5250 message = this.isBuyingFromPlayer ? class_2561.method_43469((String)"shop.setup.owner.add_buying", (Object[])new Object[]{item.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE) : class_2561.method_43469((String)"shop.setup.owner.add_selling", (Object[])new Object[]{item.method_7954()}).method_10862(ShoppyMod.APPROVAL_STYLE);
                player.method_43496((class_2561)message);
            } else if (class_1799.method_31577((class_1799)item, (class_1799)this.getSelling())) {
                this.putItemIntoShop(item);
            }
            return class_1269.field_5812;
        }
        if (hit.method_10214() <= 0.5) {
            if (player.method_18276()) {
                this.updateTradingStatus(!this.isBuyingFromPlayer);
                class_5250 status = this.isBuyingFromPlayer ? class_2561.method_43471((String)"shop.status.buying").method_10862(ShoppyMod.VARIABLE_STYLE) : class_2561.method_43471((String)"shop.status.selling").method_10862(ShoppyMod.VARIABLE_STYLE);
                class_5250 update = class_2561.method_43469((String)"shop.status.update", (Object[])new Object[]{status}).method_10862(ShoppyMod.CONSTANTS_STYLE);
                player.method_43496((class_2561)update);
            } else {
                class_5250 message = class_2561.method_43471((String)"shop.pricing.owner.update").method_10862(ShoppyMod.APPROVAL_STYLE);
                player.method_43496((class_2561)message);
                ShoppyMod.awaitingResponse.put(player.method_5667(), this);
            }
        }
        return class_1269.field_21466;
    }

    @Override
    public void userLeftClickTradingBlock(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        if (ShoppyMod.economyInstance == null) {
            class_5250 noEconomy = class_2561.method_43471((String)"shop.error.no_economy").method_10862(ShoppyMod.ERROR_STYLE);
            player.method_43496((class_2561)noEconomy);
            return;
        }
        class_5250 amountBeingSold = class_2561.method_43470((String)("x" + this.getSelling().method_7947())).method_10862(ShoppyMod.VARIABLE_STYLE);
        class_5250 itemBeingSold = this.getSelling().method_7954().method_27661().method_27694(style -> {
            style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(this.getSelling())));
            return style;
        });
        class_2561 currencyAmount = ShoppyMod.economyInstance.getDefaultCurrency().format(this.price);
        class_5250 component = this.isBuyingFromPlayer ? class_2561.method_43469((String)"shop.information.user.buying_info", (Object[])new Object[]{amountBeingSold, itemBeingSold, currencyAmount}).method_10862(ShoppyMod.CONSTANTS_STYLE) : class_2561.method_43469((String)"shop.information.user.selling_info", (Object[])new Object[]{amountBeingSold, itemBeingSold, currencyAmount}).method_10862(ShoppyMod.CONSTANTS_STYLE);
        player.method_43496((class_2561)component);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        tag.method_10556("buyingFromPlayer", this.isBuyingFromPlayer);
        tag.method_10566("selling", (class_2520)this.selling.method_7953(new class_2487()));
        tag.method_10569("price", this.price);
        tag.method_25927("owner", this.owner);
        return tag;
    }

    public void updateTradingStatus(boolean value) {
        this.isBuyingFromPlayer = value;
        this.markUpdated();
    }

    public void setPrice(int price) {
        this.price = price;
        this.markUpdated();
    }

    public int getPrice() {
        return this.price;
    }

    public boolean isBuyingFromPlayer() {
        return this.isBuyingFromPlayer;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        if (this.getOwner().equals(player.method_5667())) {
            return ShoppingMenuOwner.realContainer(i, inventory, this, this.data);
        }
        return ShoppingMenu.realContainer(i, inventory, this, this.data);
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return null;
    }

    public int method_5439() {
        return 2;
    }

    public boolean method_5442() {
        return this.selling.method_7960();
    }

    public class_1799 method_5438(int pSlot) {
        class_1799 item;
        int take;
        if (pSlot == 0) {
            take = this.storedSellingItems;
            item = this.getSelling().method_7972();
        } else if (pSlot == 1) {
            item = this.getSelling();
            take = this.getSelling().method_7947();
        } else {
            return class_1799.field_8037;
        }
        item.method_7939(take);
        return item;
    }

    public class_1799 method_5434(int slot, int amountToRemove) {
        class_1799 item = this.method_5438(slot);
        if (slot == 0) {
            this.storedSellingItems -= amountToRemove;
        }
        this.markUpdated();
        return item.method_7971(amountToRemove);
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, 64);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 1) {
            this.selling = stack;
        }
        this.markUpdated();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }
}

