/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsAPI;
import net.spell_engine.internals.SpellCast;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.attributes.SpellAttributes;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.BerserkerAbilities;
import net.sweenus.simplyskills.abilities.RangerAbilities;
import net.sweenus.simplyskills.abilities.RogueAbilities;
import net.sweenus.simplyskills.abilities.SpellbladeAbilities;
import net.sweenus.simplyskills.abilities.WizardAbilities;
import net.sweenus.simplyskills.network.CooldownPacket;
import net.sweenus.simplyskills.network.KeybindPacket;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class SignatureAbilities {
    public static void signatureAbilityManager(class_1657 player) {
        String wizardSkillTree = "simplyskills_wizard";
        String berserkerSkillTree = "simplyskills_berserker";
        String rogueSkillTree = "simplyskills_rogue";
        String rangerSkillTree = "simplyskills_ranger";
        String spellbladeSkillTree = "simplyskills_spellblade";
        boolean ability_success = false;
        String ability = "";
        if (SkillsAPI.getUnlockedCategories((class_3222)((class_3222)player)).contains(wizardSkillTree)) {
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShower, (class_1309)player)) {
                ability_success = WizardAbilities.signatureWizardMeteorShower(wizardSkillTree, player);
                ability = "MeteorShower";
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceComet, (class_1309)player)) {
                ability_success = WizardAbilities.signatureWizardIceComet(wizardSkillTree, player);
                ability = "IceComet";
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischarge, (class_1309)player)) {
                ability_success = WizardAbilities.signatureWizardStaticDischarge(wizardSkillTree, player);
                ability = "StaticDischarge";
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBolt, (class_1309)player)) {
                ability_success = WizardAbilities.signatureWizardArcaneBolt(wizardSkillTree, player);
                ability = "ArcaneBolt";
            }
        }
        if (SkillsAPI.getUnlockedCategories((class_3222)((class_3222)player)).contains(berserkerSkillTree)) {
            if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationRampage, (class_1309)player)) {
                ability_success = BerserkerAbilities.signatureBerserkerRampage(berserkerSkillTree, player);
                ability = "Rampage";
            }
            if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationBloodthirsty, (class_1309)player)) {
                ability_success = BerserkerAbilities.signatureBerserkerBloodthirsty(berserkerSkillTree, player);
                ability = "Bloodthirsty";
            }
            if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationBerserking, (class_1309)player)) {
                ability_success = BerserkerAbilities.signatureBerserkerBerserking(berserkerSkillTree, player);
                ability = "Berserking";
            }
        }
        if (SkillsAPI.getUnlockedCategories((class_3222)((class_3222)player)).contains(rogueSkillTree)) {
            if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationEvasion, (class_1309)player)) {
                ability_success = RogueAbilities.signatureRogueEvasion(rogueSkillTree, player);
                ability = "Evasion";
            }
            if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationPreparation, (class_1309)player)) {
                ability_success = RogueAbilities.signatureRoguePreparation(rogueSkillTree, player);
                ability = "Preparation";
            }
            if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationSiphoningStrikes, (class_1309)player)) {
                ability_success = RogueAbilities.signatureRogueSiphoningStrikes(rogueSkillTree, player);
                ability = "SiphoningStrikes";
            }
        }
        if (SkillsAPI.getUnlockedCategories((class_3222)((class_3222)player)).contains(rangerSkillTree)) {
            if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrows, (class_1309)player)) {
                ability_success = RangerAbilities.signatureRangerElementalArrows(rangerSkillTree, player);
                ability = "ElementalArrows";
            }
            if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengage, (class_1309)player)) {
                ability_success = RangerAbilities.signatureRangerDisengage(rangerSkillTree, player);
                ability = "Disengage";
            }
            if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationArrowRain, (class_1309)player)) {
                ability_success = RangerAbilities.signatureRangerArrowRain(rangerSkillTree, player);
                ability = "ArrowRain";
            }
        }
        if (SkillsAPI.getUnlockedCategories((class_3222)((class_3222)player)).contains(spellbladeSkillTree)) {
            if (HelperMethods.isUnlocked(spellbladeSkillTree, SkillReferencePosition.spellbladeSpecialisationElementalSurge, (class_1309)player)) {
                ability_success = SpellbladeAbilities.signatureSpellbladeElementalSurge(spellbladeSkillTree, player);
                ability = "ElementalSurge";
            }
            if (HelperMethods.isUnlocked(spellbladeSkillTree, SkillReferencePosition.spellbladeSpecialisationElementalImpact, (class_1309)player)) {
                ability_success = SpellbladeAbilities.signatureSpellbladeElementalImpact(spellbladeSkillTree, player);
                ability = "ElementalImpact";
            }
            if (HelperMethods.isUnlocked(spellbladeSkillTree, SkillReferencePosition.spellbladeSpecialisationSpellweaver, (class_1309)player)) {
                ability_success = SpellbladeAbilities.signatureSpellbladeSpellweaver(spellbladeSkillTree, player);
                ability = "Spellweaver";
            }
        }
        if (!player.field_6002.field_9236) {
            SignatureAbilities.signatureAbilityCooldownManager(ability, ability_success, player);
        }
    }

    public static void signatureAbilityCooldownManager(String ability, boolean useSuccess, class_1657 player) {
        float spellHasteCDReduce = SimplySkills.generalConfig.spellHasteCooldownReductionModifier;
        int minimumCD = SimplySkills.generalConfig.minimumAchievableCooldown * 1000;
        int useDelay = (int)SimplySkills.generalConfig.minimumTimeBetweenAbilityUse * 1000;
        int cooldown = 500;
        String type = "";
        switch (ability) {
            case "ArcaneBolt": {
                cooldown = SimplySkills.wizardConfig.signatureWizardArcaneBoltCooldown * 1000;
                type = "magic";
                break;
            }
            case "IceComet": {
                cooldown = SimplySkills.wizardConfig.signatureWizardIceCometCooldown * 1000;
                type = "magic";
                break;
            }
            case "MeteorShower": {
                cooldown = SimplySkills.wizardConfig.signatureWizardMeteorShowerCooldown * 1000;
                type = "magic";
                break;
            }
            case "StaticDischarge": {
                cooldown = SimplySkills.wizardConfig.signatureWizardStaticDischargeCooldown * 1000;
                type = "magic";
                break;
            }
            case "Berserking": {
                cooldown = SimplySkills.berserkerConfig.signatureBerserkerBerserkingCooldown * 1000;
                type = "physical";
                break;
            }
            case "Bloodthirsty": {
                cooldown = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyCooldown * 1000;
                type = "physical";
                break;
            }
            case "Rampage": {
                cooldown = SimplySkills.berserkerConfig.signatureBerserkerRampageCooldown * 1000;
                type = "physical";
                break;
            }
            case "SiphoningStrikes": {
                cooldown = SimplySkills.rogueConfig.signatureRogueSiphoningStrikesCooldown * 1000;
                type = "physical";
                break;
            }
            case "Evasion": {
                cooldown = SimplySkills.rogueConfig.signatureRogueEvasionCooldown * 1000;
                type = "physical";
                break;
            }
            case "Preparation": {
                cooldown = SimplySkills.rogueConfig.signatureRoguePreparationCooldown * 1000;
                type = "physical";
                break;
            }
            case "ArrowRain": {
                cooldown = SimplySkills.rangerConfig.effectRangerArrowRainCooldown * 1000;
                type = "mixed";
                break;
            }
            case "Disengage": {
                cooldown = SimplySkills.rangerConfig.signatureRangerDisengageCooldown * 1000;
                type = "physical";
                break;
            }
            case "ElementalArrows": {
                cooldown = SimplySkills.rangerConfig.effectRangerElementalArrowsCooldown * 1000;
                type = "magic";
                break;
            }
            case "ElementalImpact": {
                cooldown = SimplySkills.spellbladeConfig.signatureSpellbladeElementalImpactCooldown * 1000;
                type = "mixed";
                break;
            }
            case "ElementalSurge": {
                cooldown = SimplySkills.spellbladeConfig.signatureSpellbladeElementalSurgeCooldown * 1000;
                type = "physical";
                break;
            }
            case "Spellweaver": {
                cooldown = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverCooldown * 1000;
                type = "magic";
            }
        }
        double spellHaste = player.method_26825((class_1320)SpellAttributes.HASTE.attribute);
        double sendCooldown = (double)cooldown - (spellHaste - 100.0) * (double)spellHasteCDReduce * 100.0;
        if (sendCooldown < (double)minimumCD && useSuccess) {
            sendCooldown = minimumCD;
        }
        if (!useSuccess) {
            sendCooldown = useDelay;
        }
        SignatureAbilities.sendCooldownPacket((class_3222)player, (int)sendCooldown);
    }

    public static void castSpellEngineTargeted(class_1657 player, String spellIdentifier, int range) {
        class_1297 target = HelperMethods.getTargetedEntity((class_1297)player, range);
        if (target != null) {
            class_1799 itemStack = player.method_6047();
            class_1268 hand = player.method_6058();
            SpellCast.Action action = SpellCast.Action.RELEASE;
            class_2960 spellID = new class_2960(spellIdentifier);
            ArrayList<class_1297> list = new ArrayList<class_1297>();
            list.add(target);
            SpellHelper.performSpell((class_1937)player.field_6002, (class_1657)player, (class_2960)spellID, list, (class_1799)itemStack, (SpellCast.Action)action, (class_1268)hand, (int)20);
        }
    }

    public static void castSpellEngineIndirectTarget(class_1657 player, String spellIdentifier, int range, class_1297 target) {
        if (target != null) {
            class_1799 itemStack = player.method_6047();
            class_1268 hand = player.method_6058();
            SpellCast.Action action = SpellCast.Action.RELEASE;
            class_2960 spellID = new class_2960(spellIdentifier);
            ArrayList<class_1297> list = new ArrayList<class_1297>();
            list.add(target);
            SpellHelper.performSpell((class_1937)player.field_6002, (class_1657)player, (class_2960)spellID, list, (class_1799)itemStack, (SpellCast.Action)action, (class_1268)hand, (int)20);
        }
    }

    public static boolean castSpellEngineAOE(class_1657 player, String spellIdentifier, int radius, int chance, boolean singleTarget) {
        class_1799 itemStack = player.method_6047();
        class_1268 hand = player.method_6058();
        SpellCast.Action action = SpellCast.Action.RELEASE;
        class_2960 spellID = new class_2960(spellIdentifier);
        ArrayList<class_1309> list = new ArrayList<class_1309>();
        class_238 box = HelperMethods.createBox((class_1297)player, radius);
        for (class_1297 entities : player.field_6002.method_8333((class_1297)player, box, class_1301.field_6157)) {
            class_1309 le;
            if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
            if (player.method_6051().method_43048(100) < chance) {
                list.add(le);
            }
            if (!singleTarget) continue;
            break;
        }
        if (!list.isEmpty()) {
            SpellHelper.performSpell((class_1937)player.field_6002, (class_1657)player, (class_2960)spellID, list, (class_1799)itemStack, (SpellCast.Action)action, (class_1268)hand, (int)20);
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendKeybindPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        class_2817 packet = new class_2817(KeybindPacket.ABILITY1_PACKET, buf);
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void sendCooldownPacket(class_3222 player, int cooldown) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(cooldown);
        class_2658 packet = new class_2658(CooldownPacket.COOLDOWN_PACKET, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CooldownPacket.COOLDOWN_PACKET, (class_2540)packet.method_11458());
    }
}

