/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.util;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.puffish.skillsmod.SkillsAPI;
import net.sweenus.simplyskills.SimplySkills;

public class HelperMethods {
    public static boolean checkFriendlyFire(class_1309 livingEntity, class_1657 player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        if (!HelperMethods.checkEntityBlacklist(livingEntity, player)) {
            return false;
        }
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntity;
            if (playerEntity == player) {
                return false;
            }
            return playerEntity.method_7256(player);
        }
        if (livingEntity instanceof class_1321) {
            class_1321 tameableEntity = (class_1321)livingEntity;
            if (tameableEntity.method_6177() != null) {
                return tameableEntity.method_6177() != player;
            }
            return true;
        }
        return true;
    }

    public static boolean isBehindTarget(class_1309 attacker, class_1309 target) {
        return target.method_43078() < attacker.method_43078() + 32.0f && target.method_43078() > attacker.method_43078() - 32.0f;
    }

    public static boolean isUnlocked(String tree, String skill, class_1309 livingEntity) {
        class_3222 serverPlayer;
        if (livingEntity instanceof class_3222 && SkillsAPI.getUnlockedSkills((class_3222)(serverPlayer = (class_3222)livingEntity), (String)tree).isPresent()) {
            if (skill != null) {
                return ((Collection)SkillsAPI.getUnlockedSkills((class_3222)serverPlayer, (String)tree).get()).contains(skill);
            }
            return SkillsAPI.getUnlockedCategories((class_3222)serverPlayer).contains(tree);
        }
        return false;
    }

    public static boolean checkEntityBlacklist(class_1309 livingEntity, class_1657 player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        return !(livingEntity instanceof class_1531) && !(livingEntity instanceof class_1646);
    }

    public static double getAttackDamage(class_1799 stack) {
        return stack.method_7909().method_7844(class_1304.field_6173).get((Object)class_5134.field_23721).stream().mapToDouble(class_1322::method_6186).sum();
    }

    public static class_238 createBox(class_1297 entity, int radius) {
        class_238 box = new class_238(entity.method_23317() + (double)radius, entity.method_23318() + (double)((float)radius / 3.0f), entity.method_23321() + (double)radius, entity.method_23317() - (double)radius, entity.method_23318() - (double)((float)radius / 3.0f), entity.method_23321() - (double)radius);
        return box;
    }

    public static class_238 createBoxAtBlock(class_2338 blockpos, int radius) {
        class_238 box = new class_238((double)(blockpos.method_10263() + radius), (double)(blockpos.method_10264() + radius), (double)(blockpos.method_10260() + radius), (double)(blockpos.method_10263() - radius), (double)(blockpos.method_10264() - radius), (double)(blockpos.method_10260() - radius));
        return box;
    }

    public static class_238 createBoxBetween(class_2338 blockpos, class_2338 blockpos2, int radius) {
        class_238 box = new class_238((double)(blockpos.method_10263() + radius), (double)(blockpos.method_10264() + radius), (double)(blockpos.method_10260() + radius), (double)(blockpos2.method_10263() - radius), (double)(blockpos2.method_10264() - radius), (double)(blockpos2.method_10260() - radius));
        return box;
    }

    public static class_1297 getTargetedEntity(class_1297 user, int range) {
        class_238 searchBox;
        class_243 userView;
        class_243 rayCastEnd;
        class_243 rayCastOrigin = user.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)user, (class_243)rayCastOrigin, (class_243)(rayCastEnd = rayCastOrigin.method_1019(userView = user.method_5828(1.0f).method_1029().method_1021((double)range))), (class_238)(searchBox = user.method_5829().method_1009((double)range, (double)range, (double)range)), target -> !target.method_7325() && target.method_5863() && target instanceof class_1309, (double)(range * range));
        if (hitResult != null) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static class_243 getPositionLookingAt(class_1657 player, int range) {
        class_239 result = player.method_5745((double)range, 0.0f, false);
        if (result.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_3965 blockResult = (class_3965)result;
        return blockResult.method_17784();
    }

    public static void incrementStatusEffect(class_1309 livingEntity, class_1291 statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.method_6092(new class_1293(statusEffect, duration, currentAmplifier));
                return;
            }
            livingEntity.method_6092(new class_1293(statusEffect, duration, currentAmplifier + amplifier));
        }
        livingEntity.method_6092(new class_1293(statusEffect, duration));
    }

    public static boolean stringContainsAny(String string, String[] stringList) {
        for (String s : stringList) {
            if (!string.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static void decrementStatusEffect(class_1309 livingEntity, class_1291 statusEffect) {
        if (livingEntity.method_6059(statusEffect)) {
            int currentAmplifier = livingEntity.method_6112(statusEffect).method_5578();
            int currentDuration = livingEntity.method_6112(statusEffect).method_5584();
            if (currentAmplifier < 1) {
                livingEntity.method_6016(statusEffect);
                return;
            }
            livingEntity.method_6016(statusEffect);
            livingEntity.method_6092(new class_1293(statusEffect, currentDuration, currentAmplifier - 1));
        }
    }

    public static boolean buffSteal(class_1309 user, class_1309 target, boolean strip, boolean singular) {
        List list = target.method_6026().stream().toList();
        if (list.isEmpty()) {
            return false;
        }
        for (class_1293 statusEffectInstance : list) {
            class_1291 statusEffect = statusEffectInstance.method_5579();
            if (!statusEffect.method_5573()) continue;
            int duration = statusEffectInstance.method_5584();
            if (user != null) {
                HelperMethods.incrementStatusEffect(user, statusEffect, duration, 1, 99);
            }
            if (strip) {
                HelperMethods.decrementStatusEffect(target, statusEffectInstance.method_5579());
            }
            if (!singular) continue;
            return true;
        }
        return true;
    }

    public static void spawnParticle(class_1937 world, class_2394 particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.field_9236) {
            world.method_8406(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.0);
        }
    }

    public static void spawnParticlesPlane(class_1937 world, class_2394 particle, class_2338 blockpos, int radius, double xvelocity, double yvelocity, double zvelocity) {
        class_238 box = HelperMethods.createBoxAtBlock(blockpos, radius);
        double xpos = blockpos.method_10263() - (radius + 1);
        double ypos = blockpos.method_10264();
        double zpos = blockpos.method_10260() - (radius + 1);
        for (int i = radius * 2; i > 0; --i) {
            for (int j = radius * 2; j > 0; --j) {
                float choose = (float)(Math.random() * 1.0);
                HelperMethods.spawnParticle(world, particle, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, xvelocity, yvelocity, zvelocity);
            }
        }
    }

    public static boolean respecialise(class_3222 user) {
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        for (String specialisation : specialisations) {
            SkillsAPI.eraseCategory((class_3222)user, (String)specialisation);
        }
        SkillsAPI.resetSkills((class_3222)user, (String)"simplyskills");
        return true;
    }

    public static void treeResetOnDeath(class_3222 user) {
        if (SimplySkills.generalConfig.treeResetOnDeath) {
            List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
            for (String specialisation : specialisations) {
                SkillsAPI.eraseCategory((class_3222)user, (String)specialisation);
                SkillsAPI.eraseCategory((class_3222)user, (String)"simplyskills");
            }
        }
    }
}

